(function() {
	'use strict';

	var dataModelDetails = {
			
			activeDataCollectionperiod : false,

			clearStaticColumns : function() {
			    this.staticColumnsDropdownWidget.StaticColumnsDropdown('clear');
			},
			
			codelistId : null,
			
			codelistLabel : null,

			constants : {
				CODELIST : 'codelist',
				DATATYPE_RANGE : "attributeDatatype",
				MANDATORY : 'attributeMandatory',
				CODELIST : 'attributeCodelist',
				NO_DUPLICATES : 'entityNoDuplicates',
				CLSubset : 'tupleCodeListSubset',
				INTEGER : 'integer',
				DECIMAL : 'decimal',
				DATE : 'date'
			},

			createDataTable : function() {
				// Create datatable
				$('#regional-data-collection-data-model-details-datatable').PortletDataTable({
					ajax :	{
						url : window.config.createResourceURL('getConstraintsByDataModelId'),
						type : 'POST',
						cache : false,
						dataType : "json",
						data : function() {
							return window.ajaxCalls.formatDataForAjaxCall({ id : dataModelDetails.getdataModelID() });
						},
						beforeSend : function(xhr) {
							dataModelDetails.clearMessage();
						},
						dataSrc : function(data) {
							let serverResponse = $.parseJSON(data.result);
							dataModelDetails.setActiveDataCollectionperiod(serverResponse.activeDataCollectionperiod);
							var data = serverResponse.constraints;
							
							$.each(data, function(index, value) {
								if(typeof value.constraintType !== 'undefined' && value.constraintType === dataModelDetails.constants.DATATYPE_RANGE && typeof value.datatype !== 'undefined') {
									data[index].constraintType += ' / RANGE / ' + data[index].datatype.toUpperCase();
								} else if( typeof value.constraintType !== 'undefined' && value.constraintType === dataModelDetails.constants.NO_DUPLICATES ) {
									data[index].field = data[index].fields.map(function(x){
										return x.fieldName;
									});
								}
							});
							
							return data;
						},
						error : function(jqXHR, exception) {
							dataModelDetails.errorHandling(jqXHR, exception);
						},
						complete : function() {
//							dataModelDetails.globalCompleteCallback();
						},
						timeout : 20000
					},
					columnDefs : [{
						title : "Rule",
						fieldName : "label",
						targets : 0,
						width: '25%'
					}, {
						title : "Dimension",
						fieldName : "field",
						targets : 1,
						width: '25%'
					}, {
						title : "Type",
						fieldName : "constraintType",
						targets :  2
					}, {
						title : 'Trigger',
						fieldName : 'trigger',
						targets : 3
					}, {
						title : 'Error Message',
						fieldName : 'errorMessage',
						targets : 4
					}],
					order : [[0, "asc"]],
					toolbar : $('#regional-data-collection-data-model-details-toolbar'),
					onDrawDtCallback : function() {
						dataModelDetails.dataModelDetailsContainer.find('#regional-data-collection-data-model-details-add-button').attr('disabled', dataModelDetails.isActiveDataCollectionperiod());
//						Removing this class will disable toggling 
						if(dataModelDetails.isActiveDataCollectionperiod()) {
							dataModelDetails.dataModelDetailsContainer.find('#regional-data-collection-data-model-details-remove-button').removeClass('toggle-on-row-selection');
						} else {
							dataModelDetails.dataModelDetailsContainer.find('#regional-data-collection-data-model-details-remove-button').addClass('toggle-on-row-selection');
						}
//						This should also be taken into account for the edit button
					}
				});

				// Get Widget Instance
				this.dataTable = $('#regional-data-collection-data-model-details-datatable').data("dt-PortletDataTable");
			},

			dataModelData : null,

			dataModelDetailsContainer : null,

			dataModelID : null,
			
			dataModelName : null,

			entityConstraintMultiselectValues : [],
			
			getCodelistFieldsForDataModel : function() {
				var url = "getCodelistFieldsForDataModel";
				
				var data = {
						id : dataModelDetails.dataModelID,
						fieldId : $('#regional-data-collection-data-model-constaints-add-dimension-attribute').val()
				};
				
				var bSC = function() {
					dataModelDetails.showSpinnerInAddClsSubsetConstraint();
					dataModelDetails.clearMessage();
				};
				
				var oSC = function(data) {
					var data = $.parseJSON(data.result);
					
					$('#add-modal-codelist-constraint-display-field').html('');
					$('#add-modal-codelist-constraint-persist-field').html('');
					
					$.each(data.fields, function(i,value) {
						var $option = $('<option></option>', {
							text : value,
							value : value
						}).appendTo($('#add-modal-codelist-constraint-display-field'));
						
						$option.clone().appendTo($('#add-modal-codelist-constraint-persist-field'));
						$option.clone().appendTo($('#regional-data-collection-data-model-constaints-add-tuple-constraint-dimension-attribute-first-tuple-dropdown'));
					});
					
					dataModelDetails.codelistId = data.codelistId;
					dataModelDetails.codelistLabel = data.codelistLabel;
					$('#add-modal-codelist-constraint-codelist-label').text(data.codelistLabel);
				};
				
				var oEC = function(jqXHR, exception) {
					dataModelDetails.errorHandling(jqXHR, exception);
					$('#regional-data-collection-data-model-details-add-modal').modal('hide');
				};
				
				var oCC = function() {
					dataModelDetails.hideSpinnerInAddAttributeCodelistConstraint();
					dataModelDetails.hideSpinnerInAddClsSubsetConstraint();
				}
				
				window.ajaxCalls.post(url, data, bSC, oSC, oEC, oCC);
			},

			getDataModelData : function() {
			    return this.dataModelData;
			},

			getdataModelDetails : function() {
				this.createDataTable();
			},

			getdataModelID : function() {
				return this.dataModelID;
			},
			
			getDataModelName : function() {
				return this.dataModelName;
			},
			
			hideSpinnerInAddAttributeCodelistConstraint : function() {
				dataModelDetails.spinnerInAddClsSubsetConstraint.hide();
			},
			
			hideSpinnerInAddClsSubsetConstraint : function() {
				dataModelDetails.spinnerInAddClsSubsetConstraint.hide();
			},

			hideSpinnerInAddDataModelModal : function() {
				dataModelDetails.spinnerInAddDataModelModal.hide();
			},

			hideSpinnerInAddEntityConstraintModal : function() {
				dataModelDetails.spinnerInAddEntityConstraintModal.hide();
			},

			hideSpinnerInEditDataModelModal : function() {
				dataModelDetails.spinnerInEditDataModelModal.hide();
			},

			init : function($container, data) {
				this.dataModelDetailsContainer = $container;
				this.loadCSS();
				this.loadContent();
				this.setDataModelData(data);
			},
			
			initAddDataModelDetailsWidget : function() {
				var addDataModelModal = $('#regional-data-collection-data-model-details-add-modal-container').ModalWidget({
					ajaxCall : window.ajaxCalls,
					config : window.config,
					modalHeaderText : 'Add Constraint for ' + dataModelDetails.getDataModelName(),
					modalButtons : [],
					modalCss : {
						width : 'auto'
					},
					widgetName : 'AddDataModelDetailsBaseEditor',
					modalWidgetOptions : {
						dataModelDetails : dataModelDetails,
						ajaxCalls : window.ajaxCalls,
						config : window.config,
						defaultCallback : function(elem, options) {
							options.dataModel = dataModel;
							options.parentEditorElement = $('#regional-data-collection-data-model-details-add-modal-container');
							elem.CodelistConstraintEditor(options);
						},
						setButtonVisibility : function(name, visible) {
							addDataModelModal.ModalWidget('setButtonVisibility', name, visible);
						}
					}
				});
				
				var modalButtons = [];
				var buttonProps = {
						dismissModal : true,
						label : 'Save',
						className : 'save-button',
						disabled : true,
						handler : function() {
							var modalBody = addDataModelModal.ModalWidget('getModalBody');
							var widget = addDataModelModal.ModalWidget('option', 'widgetName');
							
							var data = modalBody[widget]('getData');
							var constraintLabel = modalBody[widget]('getConstraintLabel');

							let tableData = [];
                            dataModelDetails.dataTable.getRowsData().rows().every( function() {
                                tableData.push( this.data() );
                            });

                            let sameTypeConstraintsLength = 0;
                            if( typeof data.field === "string" )
                                sameTypeConstraintsLength = tableData.filter( td => ( td.constraintType.indexOf( data.constraintType ) > -1 && td.field.indexOf( data.field ) > -1 ) ).length;
                            else {
                                sameTypeConstraintsLength = tableData.filter( td => ( td.constraintType.indexOf( data.constraintType ) > -1 && data.fields.filter( field => td.field.indexOf(field) > -1 ) ) ).length;
                            }

							if( sameTypeConstraintsLength > 0 ) {
                                dataModelDetails.showMessage("Multiple constraints of the same type and dimension are not allowed", "error");
                                return;
							}
							
							var postData = {
									jsonData : JSON.stringify(data),
									dataModelId : dataModelDetails.dataModelID
							};

							var bSC = dataModelDetails.clearMessage;

							var oSC = function(data) {
								var callback = function() {
									dataModelDetails.showMessage("Constraint <b>" + constraintLabel + "</b> added successfully", "success");									
								};
								dataModelDetails.reloadData(callback);
							};

							var oEC = function(jqXHR, textStatus, errorThrown) { dataModelDetails.showMessage(jqXHR.responseText, "error"); };

							var oCC = null;

							window.ajaxCalls.post('addNewConstraint', postData, bSC, oSC, oEC, oCC);
						}
				};
				modalButtons.push(buttonProps);
				
				addDataModelModal.ModalWidget('option', 'modalButtons', modalButtons);
			},
			
			initDeleteDataModelDetailsWidget : function() {
				var modalButtons = [];
				var buttonProps = {
						dismissModal : true,
						label : 'Delete',
						className : 'save-button',
						disabled : false,
						handler : function() {
							var data = {};
							data.dataModelId = dataModelDetails.getdataModelID();
							data.constraintId = dataModelDetails.dataTable.getSelectedRowData().id;

							var constraintLabel = dataModelDetails.dataTable.getSelectedRowData().label;

							var bSC = function() {
								var callback = function() {
									dataModelDetails.showMessage('Constraint <b>' + constraintLabel + '</b> was deleted successfully', "success");									
								};
								dataModelDetails.reloadData(callback);
							};

							window.ajaxCalls.post('deleteConstraint', data, dataModelDetails.clearMessage, bSC, dataModelDetails.errorHandling, undefined);
						}
				};
				modalButtons.push(buttonProps);
				
				var deleteDataModelModal = $('#regional-data-collection-data-model-details-remove-modal-container').ModalWidget({
					ajaxCall : window.ajaxCalls,
					config : window.config,
					modalHeaderText : 'Delete data model',
					modalButtons : modalButtons,
					widgetName : 'DeleteDataModelDetailsEditor',
					modalWidgetOptions : {
						dataModelDetails : dataModelDetails,
						ajaxCalls : window.ajaxCalls,
						config : window.config,
						setButtonVisibility : function(name, visible) {
							deleteDataModelModal.ModalWidget('setButtonVisibility', name, visible);
						}
					}
				});
			},
			
			initEditDataModelDetailsWidget : function() {
				var editDataModelModal = $('#regional-data-collection-data-model-details-edit-modal-container').ModalWidget({
					ajaxCall : window.ajaxCalls,
					config : window.config,
					modalHeaderText : 'Edit Constraint of ' + dataModelDetails.getDataModelName(),
					modalButtons : [],
					modalCss : {
						width : 'auto'
					},
					widgetName : 'EditDataModelDetailsBaseEditor',
					modalWidgetOptions : {
						dataModelDetails : dataModelDetails,
						ajaxCalls : window.ajaxCalls,
						config : window.config,
						setButtonVisibility : function(name, visible) {
							editDataModelModal.ModalWidget('setButtonVisibility', name, visible);
						}
					}
				});

				var modalButtons = [];
				var buttonProps = {
						dismissModal : true,
						label : 'Save',
						className : 'save-button',
						disabled : dataModelDetails.isActiveDataCollectionperiod(),
						handler : function() {
							var data = editDataModelModal.ModalWidget('getData');
							data.dataModelId = dataModelDetails.getdataModelID();
							data.id = dataModelDetails.dataTable.getSelectedRowData().id;

                            let selectedRowData = dataModelDetails.dataTable.getSelectedRowData();
                            let tableData = [];
                            dataModelDetails.dataTable.getRowsData().rows().every( function() {
                                tableData.push( this.data() );
                            });

                            let sameTypeConstraintsLength = 0;

							if( typeof data.field === "string" )
                                sameTypeConstraintsLength = tableData.filter( td => ( td.constraintType.indexOf( data.constraintType ) > -1 && td.field.indexOf( data.field ) > -1 && td.id !== data.id ) ).length;
                            else {
                                sameTypeConstraintsLength = tableData.filter( td => ( td.constraintType.indexOf( data.constraintType ) > -1 && data.fields.filter( field => td.field.indexOf(field) > -1 && td.id !== data.id ) && td.id !== data.id ) ).length;
                            }

							if( sameTypeConstraintsLength > 0 ) {
                                dataModelDetails.showMessage("Multiple constraints of the same type and dimension are not allowed", "error");
                                return;
							}
							
							var postData = {
									jsonData : JSON.stringify(data),
									dataModelId : dataModelDetails.dataModelID,
									constraintId : dataModelDetails.dataTable.getSelectedRowData().id
							};
							var constraintLabel = dataModelDetails.dataTable.getSelectedRowData().label;

							var oSC = function() {
								var callback = function() {
									dataModelDetails.showMessage('The constraint was updated successfully', "success");
								};
								dataModelDetails.reloadData(callback);
							};

							window.ajaxCalls.post('editConstraints', postData, dataModelDetails.clearMessage, oSC, dataModelDetails.errorHandling, undefined);
						}
				};
				if(dataModelDetails.activeDataCollectionperiod === false) {
                    modalButtons.push(buttonProps);
				    editDataModelModal.ModalWidget('option', 'modalButtons', modalButtons);
				}
			},

			initializeStaticColumnsDropdown : function() {
			    this.staticColumnsDropdownWidget = $('.regional-data-collection-data-model-details-static-fields-container').StaticColumnsDropdown({
			        ajaxCalls : window.ajaxCalls,
                    config : window.config,
                    dataModelDetails : dataModelDetails,
                    notificator : window.notificator
			    });
			},

			initUIBindings : function() {
				$('#regional-data-collection-data-model-details-go-to-data-model-screen').off().on('click', function() {
					window.dataModel.dataModelContainer.removeClass('hidden');

					dataModelDetails.dataModelDetailsContainer.addClass('hidden');

					setTimeout(function() {
					    window.dataModel.reloadData();
					}, 150);
				});

				$('#regional-data-collection-data-model-details-add-button').off().on('click', function() {
					dataModelDetails.initAddDataModelDetailsWidget();
				});

				$('#regional-data-collection-data-model-details-remove-button').off().on('click', function() {
					dataModelDetails.initDeleteDataModelDetailsWidget();
				});

				$('#regional-data-collection-data-model-details-edit-button').off().on('click', function() {
					dataModelDetails.initEditDataModelDetailsWidget();
				});
			},

			isActiveDataCollectionperiod : function() {
				return this.activeDataCollectionperiod;
			},

			loadContent : function(){
				let $spinner =  window.config.getLoadContentSpinner();
				$spinner.insertBefore(this.dataModelDetailsContainer);
				this.dataModelDetailsContainer.load(window.config.contextPath + 'modules/data-model/data-model-details.jsp', function() {
					$spinner.remove();
					dataModelDetails.notificator = $("#regional-data-collection-data-model-details-notificator");
					dataModelDetails.spinner = dataModelDetails.dataModelDetailsContainer.find(".spinner");
					dataModelDetails.spinnerInAddDataModelModal = $('#regional-data-collection-data-model-constaints-columns-loader');
					dataModelDetails.spinnerInEditDataModelModal = $('#regional-data-collection-data-model-constaints-columns-loader-edit');
					dataModelDetails.spinnerInAddEntityConstraintModal = $('#regional-data-collection-data-model-constaints-entity-columns-loader');
					dataModelDetails.spinnerInAttribteConstraintCodelist = $('.add-modal-tuple-constraint-codelist-subset-section');
					dataModelDetails.spinnerInAddClsSubsetConstraint = $('.cls-fields-loader');
					$('#regional-data-collection-data-model-details-constraint-title').text(dataModel.dataTable.getSelectedRowData().label);
					dataModelDetails.dataModelDetailsContainer.removeClass('hidden');

					dataModelDetails.initUIBindings();

					dataModelDetails.setdataModelID(dataModel.dataTable.getSelectedRowData().id);
					dataModelDetails.setdataModelName(dataModel.dataTable.getSelectedRowData().label);

                    dataModelDetails.initializeStaticColumnsDropdown();
					dataModelDetails.getdataModelDetails();
				});
			},

			loadCSS : function() {
				$("<link/>", {
					rel : "stylesheet",
					type : "text/css",
					href : window.config.contextPath + "modules/data-model/data-model-details.css"
				}).appendTo("head");
			},

			reloadData : function(callback) {
				if(typeof callback === 'undefined') {
					dataModelDetails.dataTable.refreshData(dataModelDetails.clearMessage);
				} else {
					dataModelDetails.dataTable.refreshData(callback);
				}
			},

			reloadStaticColumns : function() {
			    this.staticColumnsDropdownWidget.StaticColumnsDropdown('option', 'dataModelDetails', dataModelDetails);
                this.staticColumnsDropdownWidget.StaticColumnsDropdown('reload');
            },

			setActiveDataCollectionperiod : function(value) {
				this.activeDataCollectionperiod = value;
			},

			setDataModelData : function(data) {
			    this.dataModelData = data;
			},

			setdataModelID : function(id) {
				this.dataModelID = id;
			},

			setdataModelName : function(name) {
				this.dataModelName = name;
			},

			showSpinnerInAddClsSubsetConstraint : function() {
				dataModelDetails.spinnerInAddClsSubsetConstraint.show();
			},

			showSpinnerInAddDataModelModal : function() {
				dataModelDetails.spinnerInAddDataModelModal.show();
			},

			showSpinnerInAddEntityConstraintModal : function() {
				dataModelDetails.spinnerInAddEntityConstraintModal.show();
			},

			spinnerInAddDataModelModal : null,

			spinnerInAddEntityConstraintModal : null,

			spinnerInAddClsSubsetConstraint : null,

			showSpinnerInEditDataModelModal : function() {
				dataModelDetails.spinnerInEditDataModelModal.show();
			},

			showMessage : function(text, type) {
				window.notificator.setText(dataModelDetails.notificator, text, type);
			},

			staticColumnsDropdown : null,

			clearMessage : function() {
				window.notificator.clearMessage(dataModelDetails.notificator);
			},

			errorHandling : function(jqXHR, exception) {
				window.notificator.errorHandling(dataModelDetails.notificator, jqXHR, exception);
			},
	};

	window.dataModelDetails = dataModelDetails;
})();