(function() {
	var dataModelFormValidation = {
			init : function() {
				this.initAddDataModelForm();
			},
			
			initAddDataModelForm : function() {
				$('#regional-data-collection-data-model-import-form').validate({
			        onkeyup: function (element, event) {
			            if (event.which === 9 && this.elementValue(element) === "") {
			                return;
			            } else {
			                this.element(element);
			            }
			        },
			        onfocusout : function (element, event) {
			            if (event.which === 9 && this.elementValue(element) === "") {
			                return;
			            } else {
			                this.element(element);
			            }
			        },
					rules : {
						'regional-data-collection-data-model-import-form-name' : {
							required : true
						},
						
						'regional-data-collection-data-model-import-form-version' : {
							required : true
						},
						
						'regional-data-collection-data-model-import-form-file' : {
							required : true,
						    extension : 'xml'
						}
					},
				    highlight : function(element) {
				    	$(element).closest('.control-group').addClass('error');
				    },
				    success : function(label, element) {
					    $(element).closest('.control-group').removeClass('error');
					    label.remove();
				    },
				    errorPlacement : function(error, element) {
				    	error.css('color', 'red');
				    	error.appendTo( element.closest('.controls') );
				    }
				});
				
				//Enable disable form-submit button 
				$('#regional-data-collection-data-model-import-form input:not(#regional-data-collection-data-model-import-form-file-name)')
				.bind('input', function() {
					var valid = $(this).closest("form").validate().checkForm();
					$('#regional-data-collection-data-model-import-modal-save').attr("disabled", !valid);
				});
				
				$('#regional-data-collection-data-model-import-form-file').on('change', function() {
					var valid = $(this).closest("form").validate().checkForm();
					$('#regional-data-collection-data-model-import-modal-save').attr("disabled", !valid);
				});
			}
	};
	
	window.dataModelFormValidation = dataModelFormValidation;
})();