$.widget('rdb.EditCodelistConstraintEditor', $.rdb.BaseWidget, {
	options : {
		ajaxCalls : null,
		callback : null,
		config : null,
		constraintType : null,
		dataModelDetails : null,
		dataModel : null,
		dimensinonAttributeLoaderContainerClassName : 'regional-data-collection-data-model-constaints-columns-loader-container',
		diplayAndPersistFieldLoaderContainerClassName : 'cls-fields-loader',
		formElementsIdClassNames : {
			dimensionAttribute : '#regional-data-collection-data-model-constaints-edit-dimension-attribute',
			clLabel : '#edit-modal-codelist-constraint-codelist-label',
			displayField : '#edit-modal-codelist-constraint-display-field',
			persistField : '#edit-modal-codelist-constraint-persist-field'
		},
		myConstraintType : 'attributeCodelist',
		parentEditorElement : null,
		setButtonVisibility : null,
		selectedRowConstraintType : null,
		url : null
	},
	
	_create : function() {
		var self = this;
		if( typeof DEBUGWIDGETS !== 'undefined' && DEBUGWIDGETS === true )
		    console.log("EditCodelistConstraintEditor");
		this.options.url = 'modules/data-model/edit-data-model-details-editors/edit-data-model-details-sub-editors/codelist-constraint-editor/codelist-constraint-editor.jsp';
		this.options.callback = function() {
			self.initUIBindings();
			self.initValidation();

			if( self.options.dataModelDetails.activeDataCollectionperiod ) {
                self.turnFormElementsReadonly();
            }
		};
		
		this._super();
	},
	
	_destroy : function() {
	    this.find('[name="' +  this.options.formElementsIdClassNames.dimensionAttribute.substring(1) + '"]').rules('remove');
        this.find('[name="' + this.options.formElementsIdClassNames.displayField.substring(1) + '"]').rules('remove');
        this.find('[name="' + this.options.formElementsIdClassNames.persistField.substring(1) + '"]').rules('remove');

		this.element.html('')
	},
	
	dimensinonAttributeLoader : null,
	
	diplayAndPersistFieldLoaders : null,
	
	fillDimensionAttributesDropdown : function() {
		var self = this;
		var url = 'getColumnsOfDataModel';

		var data = {};
		data["id"] = this.options.dataModelDetails.getdataModelID();

		var bSC = function(){
			if(self.dimensinonAttributeLoader === null) {
				self.dimensinonAttributeLoader = self.options.config.getInlineSpinner();
				self.dimensinonAttributeLoader.appendTo( self.find( '.' + self.options.dimensinonAttributeLoaderContainerClassName ) );
			} else self.dimensinonAttributeLoader.show();
		};

		var oSC = function(data) {

			var data = $.parseJSON(data.result);
			var columns = data.tableTemplate.columnMapper.columns;
			columns.sort();

//			attribute single select dropdown
			let $dropdown = self.find(self.options.formElementsIdClassNames.dimensionAttribute);
			$dropdown.html('');

			$.each(columns, function(i,v){
				$('<option></option>',{
					text : v.label,
					value : v.id
				}).appendTo($dropdown);
			});
			
			if(self.options.selectedRowConstraintType === self.options.myConstraintType) {
				let tableData = self.options.dataModelDetails.dataTable.getSelectedRowData();
				$dropdown.val(tableData.fieldId);
			}
			
			self.getCodelistFieldsForDataModel();

			self.isValid();
		};

		var oEC = function(jqXHR, textStatus, errorThrown) {
			self.options.dataModel.showMessage(jqXHR.responseText, "error");
		};

		var oCC = function(){
			self.dimensinonAttributeLoader.hide();
		};

		window.ajaxCalls.post(url, data, bSC, oSC, oEC, oCC);
	},
	
	fillFormWithValues : function() {
		let data = this.options.dataModelDetails.dataTable.getSelectedRowData();
		let $dropDown = this.find(this.options.formElementsIdClassNames.dimensionAttribute);
		if( data.fieldId !== $dropDown.val() ) return;
		let values = [];
		$.each($dropDown.find('option'), function() {
			values.push($(this).val());
		});
		
		$dropDown.val(data.fieldId);
		
		let $displayFieldDropdown = this.find(this.options.formElementsIdClassNames.displayField);
		$displayFieldDropdown.val(data.displayField);
		let $persistFieldDropdown = this.find(this.options.formElementsIdClassNames.persistField);
		$persistFieldDropdown.val(data.persistField);
	},
	
	find : function(selector) {
		return this.element.find(selector);
	},
	
	getCodelistFieldsForDataModel : function() {
		var self = this;
		
		var url = "getCodelistFieldsForDataModel";
		
		var data = {
				id : dataModelDetails.dataModelID,
				fieldId : self.find(self.options.formElementsIdClassNames.dimensionAttribute).val()
		};
		
		var bSC = function() {
			self.options.dataModelDetails.clearMessage();
			if(self.diplayAndPersistFieldLoaders === null) {
				self.diplayAndPersistFieldLoaders = self.options.config.getInlineSpinner();
				self.diplayAndPersistFieldLoaders.appendTo( self.find( '.' + self.options.diplayAndPersistFieldLoaderContainerClassName ) );
			} else self.diplayAndPersistFieldLoaders.show();
		};
		
		var oSC = function(data) {
			var data = $.parseJSON(data.result);
			
			self.find(self.options.formElementsIdClassNames.displayField).html('');
			self.find(self.options.formElementsIdClassNames.persistField).html('');
			
			$.each(data.fields, function(i,value) {
				var $option = $('<option></option>', {
					text : value,
					value : value
				}).appendTo(self.find(self.options.formElementsIdClassNames.displayField));
				
				$option.clone().appendTo(self.find(self.options.formElementsIdClassNames.persistField));
//				$option.clone().appendTo($('#regional-data-collection-data-model-constaints-add-tuple-constraint-dimension-attribute-first-tuple-dropdown'));
			});
			
			self.options.dataModelDetails.codelistId = data.codelistId;
			self.options.dataModelDetails.codelistLabel = data.codelistLabel;
			self.find(self.options.formElementsIdClassNames.clLabel).text(data.codelistLabel);
			
			if(self.options.selectedRowConstraintType === self.options.myConstraintType)
				self.fillFormWithValues();

			self.options.validator.element( self.element.find( self.options.formElementsIdClassNames.displayField ) );
            self.options.validator.element( self.element.find( self.options.formElementsIdClassNames.persistField ) );

            self.options.setButtonVisibility( 'save-button', self.isValid() );
		};
		
		var oEC = function(jqXHR, exception) {
			self.options.dataModelDetails.errorHandling(jqXHR, exception);
//			Find a way to hide the modal
//			$('#regional-data-collection-data-model-details-add-modal').modal('hide');
		};
		
		var oCC = function() {
			self.find( '.' + self.options.diplayAndPersistFieldLoaderContainerClassName ).html('');
			self.diplayAndPersistFieldLoaders = null;
		}
		
		self.options.ajaxCalls.post(url, data, bSC, oSC, oEC, oCC);
	},
	
	getData : function() {
		var data = {};
		data.fieldId = this.find(this.options.formElementsIdClassNames.dimensionAttribute + ' option:selected').val().trim();
		data.field = this.find(this.options.formElementsIdClassNames.dimensionAttribute + ' option:selected').text().trim();
		data.codelistId = this.options.dataModelDetails.codelistId;
		data.codelistLabel = this.options.dataModelDetails.codelistLabel;
		data.codelist = this.options.dataModelDetails.codelistLabel;
		data.displayField = this.find(this.options.formElementsIdClassNames.displayField).val();
		data.persistField = this.find(this.options.formElementsIdClassNames.persistField).val();
		
		return data;
	},
	
	initUIBindings : function() {
		var self = this;
		
		setTimeout(function() {
			self.fillDimensionAttributesDropdown();
		}, 300);
		
		this.find(self.options.formElementsIdClassNames.dimensionAttribute).on('change', function() {
//			var constraintTypeOptionValue = self.options.parentEditorElement.find('#regional-data-collection-data-model-constaints-add-constraint-type').val();
			self.getCodelistFieldsForDataModel();
		});
	},
	
	initValidation : function() {
		var self = this;

        this.find('[name="' + this.options.formElementsIdClassNames.dimensionAttribute.substring(1) + '"]').rules('add', {
            required : true
        });

		this.find('[name="' + this.options.formElementsIdClassNames.displayField.substring(1) + '"]').rules('add', {
            required : true
        });

		this.find('[name="' + this.options.formElementsIdClassNames.persistField.substring(1) + '"]').rules('add', {
            required : true
        });
	},

	isValid : function() {
	    return this.options.validator.checkForm();
	}
});