$.widget('rdb.EditEntityConstraintNoDuplicates', $.rdb.BaseWidget, {
	options : {
		ajaxCalls : null,
		callback : null,
		config : null,
		constraintType : null,
		myConstraintType : 'entityNoDuplicates',
		dataModelDetails : null,
		entityColumnsLoaderContainerClassName : 'regional-data-collection-data-model-constaints-entity-columns-loader-container',
		formElementsIdClassName : {
			dimensionAttributeMultiselectDropdown : '#regional-data-collection-data-model-constaints-edit-entity-constraint-dimension-attribute'
		},
		setButtonVisibility : null,
		selectedRowConstraintType : null,
		url : null,
		validator : null
	},

	_create : function() {
		var self = this;
		if( typeof DEBUGWIDGETS !== 'undefined' && DEBUGWIDGETS === true )
		    console.log('EditEntityConstraintNoDuplicates');
		this.options.url = 'modules/data-model/edit-data-model-details-editors/edit-data-model-details-sub-editors/entity-constraints-editors/no-duplicate-constraints-editor/no-duplicate-constraints-editor.jsp';
		this.options.callback = function() {
			self.initUIBindings();
			self.initValidation();
		};
		
		this._super();
	},
	
	_destroy : function() {
	    this.element.find('[name="regional-data-collection-data-model-constaints-edit-entity-constraint-dimension-attribute"]').rules('remove');
		this.element.html('');
	},
	
	entityColumnsLoader : null,
	
	fillDimensionAttributesDropdown : function() {
		var self = this;
		var url = 'getColumnsOfDataModel';

		var data = {};
		data["id"] = this.options.dataModelDetails.getdataModelID();

		var bSC = function(){
			if(self.entityColumnsLoader === null) {
				self.entityColumnsLoader = self.options.config.getInlineSpinner();
				self.entityColumnsLoader.appendTo( self.find( '.' + self.options.entityColumnsLoaderContainerClassName ) );
			} else self.entityColumnsLoader.show();
		};

		var oSC = function(data) {

			var data = $.parseJSON(data.result);
			var columns = data.tableTemplate.columnMapper.columns;
			columns.sort();

//			datatype multi select dropdown
			self.find(self.options.formElementsIdClassName.dimensionAttributeMultiselectDropdown).html('');

			$.each(columns, function(i,v){

				$('<option></option>',{
					text : v.label,
					value : v.id
				}).appendTo(self.find(self.options.formElementsIdClassName.dimensionAttributeMultiselectDropdown));
			});

			self.find(self.options.formElementsIdClassName.dimensionAttributeMultiselectDropdown).multiSelect('deselect_all');
			self.find(self.options.formElementsIdClassName.dimensionAttributeMultiselectDropdown).multiSelect('refresh');
			
			if(self.options.selectedRowConstraintType === self.options.myConstraintType)
				self.fillFormWithValues();

			self.initValidationOnChange();

            self.options.setButtonVisibility( 'save-button', self.isValid() );
		};

		var oEC = function(jqXHR, textStatus, errorThrown) {
			self.options.dataModel.showMessage(jqXHR.responseText, "error");
		};

		var oCC = function(){
			self.entityColumnsLoader.hide();
		};

		this.options.ajaxCalls.post(url, data, bSC, oSC, oEC, oCC);
	},
	
	fillFormWithValues : function() {
	    var self = this;
		let data = this.options.dataModelDetails.dataTable.getSelectedRowData();
		let $dropDown = this.find(this.options.formElementsIdClassName.dimensionAttributeMultiselectDropdown);
		let values = [];
		$.each($dropDown.find('option'), function() {
			values.push($(this).val());
		});
		
		var fieldVals = [];
		data.fields.map(function(obj) {
			fieldVals.push(obj.fieldId);
		});
		$dropDown.multiSelect('select', fieldVals);

        if( self.options.dataModelDetails.activeDataCollectionperiod ) {
            self.turnFormElementsReadonly();
            $dropDown.multiSelect('refresh');
        }
	},
	
	find : function(selector) {
		return this.element.find(selector);
	},
	
	getData : function() {
		var data = {};
		
		data.fields = [];
		var $dropdownOptions = this.find(this.options.formElementsIdClassName.dimensionAttributeMultiselectDropdown +' option:selected');
		$.each($dropdownOptions, function(index, value) {
			data.fields.push({
					fieldId : $(this).val(),
					fieldName : $(this).text()
			});
		});
		
		return data;
	},
	
	initUIBindings : function() {
		this.fillDimensionAttributesDropdown();
	},
	
	initValidation : function() {
		var self = this;
        this.element.find('[name="regional-data-collection-data-model-constaints-edit-entity-constraint-dimension-attribute"]').rules('add', {
            required : true
        });
	},

	initValidationOnChange : function() {
	    var self = this;
	    this.element.find('[name="regional-data-collection-data-model-constaints-edit-entity-constraint-dimension-attribute"]').on('change', function() {
            var valid = self.options.validator.element('#'+$(this).attr('id'));
            if(valid) {
                $(this).closest('.control-group').removeClass('error').find('label.error').remove();
            } else {
                self.options.validator.showErrors({
                  "regional-data-collection-data-model-constaints-edit-entity-constraint-dimension-attribute": "This field is required"
                });
            }
            self.options.setButtonVisibility('save-button', self.isValid());
        });
	},

	isValid : function() {
	    return this.options.validator.checkForm();
	}
});