$.widget('rdb.ModalWidget', $.rdb.BaseWidget, {
	options : {
		ajaxCalls : null,
		config : null,
		isModal : true,
		modalBodyClassName : ' .modal-body',
		modalBodyElement : null,
		modalButtons : [],
		modalCss : null,
		modalClassName : 'regional-data-collection-data-collection-base-modal',
		modalFooterClassName : ' .modal-footer',
		modalHeaderClassName : ' .modal-header h4',
		modalHeaderText : null,
		modalWidgetOptions : null
	},
	
	_create : function() {
		var self = this;
		this.ajaxCalls = this.options.ajaxCalls;
		this.config = this.options.config;
		this.options.url = 'modules/modal-widget/modal-widget.jsp';
		
		this.modalWidget = null;
		
		this.options.callback = function() {
			self.setModalCSS();
			
			self.element.find( '.' + self.options.modalClassName + self.options.modalHeaderClassName).text(self.options.modalHeaderText);

			$.each(self.options.modalButtons, function(index, value) {
		
				$('<button></button>', {
					text : value.label,
					class : 'btn portlet-button ' + value.className,
					disabled : (typeof value.disabled !== 'undefined' && value.disabled === true) ? true : false,
					'data-dismiss' : (typeof value.dismissModal !== 'undefined' && value.dismissModal === true) ? 'modal' : ''
				})
				.click(value.handler)
				.prependTo( '.' + self.options.modalClassName + self.options.modalFooterClassName);
			});
			
			self.element.find( '.' + self.options.modalClassName ).modal('show');
			
			self.initUIBindings();
			
			self.options.modalBodyElement = self.element.find( '.' + self.options.modalClassName + self.options.modalBodyClassName );
			self.modalWidget = self.options.modalBodyElement[self.options.widgetName](self.options.modalWidgetOptions);
		};
		
		this._super();
	},
	_destroy : function() {
		this.element.html('');
		this._super();
	},
	
	getData : function() {
		var self = this;
		var data = {};
		
		$.each(this.getModalBody().data(), function(index, value) {
			if(typeof self.getModalBody().data(index).getData !== 'undefined') {
				Object.assign( data, self.getModalBody().data(index).getData() );
			}
		});
		
		return data;
	},
	
	getModalBody : function() {
		return this.options.modalBodyElement;
	},
	
	hide : function() {
		this.element.find('.'+this.options.modalClassName).modal('hide');
	},
	
	initUIBindings : function() {
		var self = this;
		$( '.' + self.options.modalClassName).on('hidden', function() {
			self.destroy();
			self._destroy();
		});
	},
	
	isValid : function() {
		return;
		var self = this;
		var valid = false;
		
		$.each(this.getModalBody().data(), function(index, value) {
			if(typeof self.getModalBody().data(index).isValid !== 'undefined') {
				valid = self.getModalBody().data(index).isValid();
			}
		});
		
		return valid;
	},
	
	setModalCSS : function() {
		if(this.options.modalCss !== null) {
			for(var property in this.options.modalCss) {
				this.element.find('.'+this.options.modalClassName).css(property, this.options.modalCss[property]);
			}
		}
	},
	
	setModalWidgetOption: function(optionName, value){
		var self = this;
		self.modalWidget[self.options.widgetName]('option', optionName, value);
	},
	
	setButtonVisibility: function(className, visible){
		this.element.find('.'+ className).attr('disabled', !visible);
	},
});