/*
 * Decompiled with CFR 0.152.
 */
package gr.cite.bluebridge.analytics.model;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class Consumption {
    private List<Monthly> monthly;
    private List<Daily> daily;

    public Map<Integer, Integer> getFeedNeedPerMonth() {
        TreeMap<Integer, Integer> feedNeedPerMonth = new TreeMap<Integer, Integer>();
        HashMap<Integer, Integer> years = new HashMap<Integer, Integer>();
        for (Daily dailyConsumption : this.daily) {
            String[] date = dailyConsumption.getDay().split("/");
            int year = Integer.parseInt(date[2]);
            if (!years.containsKey(year)) {
                years.put(year, 12 * years.size());
            }
            int month = Integer.parseInt(date[1]) + (Integer)years.get(year);
            int feedNeed = 0;
            if (feedNeedPerMonth.containsKey(month)) {
                feedNeed = (Integer)feedNeedPerMonth.get(month);
            }
            feedNeed = (int)((double)feedNeed + dailyConsumption.getFood());
            feedNeedPerMonth.put(month, feedNeed);
        }
        return feedNeedPerMonth;
    }

    public Map<Integer, Double> getFeedNeedPerMonth1() {
        TreeMap<Integer, Double> feedNeedPerMonth = new TreeMap<Integer, Double>();
        HashMap<Integer, Integer> years = new HashMap<Integer, Integer>();
        for (Monthly monthlyConsumption : this.monthly) {
            String[] date = monthlyConsumption.getMonth().split("/");
            int year = Integer.parseInt(date[1]);
            if (!years.containsKey(year)) {
                years.put(year, 12 * years.size());
            }
            int month = Integer.parseInt(date[0]) + (Integer)years.get(year);
            feedNeedPerMonth.put(month, monthlyConsumption.getFood());
        }
        return feedNeedPerMonth;
    }

    public int getTotalBiomassPerGeneration() {
        return this.daily.get(this.daily.size() - 1).getBm();
    }

    public List<Monthly> getMonthly() {
        return this.monthly;
    }

    public void setMonthly(List<Monthly> monthly) {
        this.monthly = monthly;
    }

    public List<Daily> getDaily() {
        return this.daily;
    }

    public void setDaily(List<Daily> daily) {
        this.daily = daily;
    }

    public static class Daily {
        private String day;
        private int bm;
        private int bmdead;
        private double fcre;
        private double fcrb;
        private double food;
        private double mortality;

        public double getMortality() {
            return this.mortality;
        }

        public void setMortality(double mortality) {
            this.mortality = mortality;
        }

        public String getDay() {
            return this.day;
        }

        public void setDay(String day) {
            this.day = day;
        }

        public int getBm() {
            return this.bm;
        }

        public void setBm(int bm) {
            this.bm = bm;
        }

        public double getFcre() {
            return this.fcre;
        }

        public void setFcre(double fcre) {
            this.fcre = fcre;
        }

        public double getFcrb() {
            return this.fcrb;
        }

        public void setFcrb(double fcrb) {
            this.fcrb = fcrb;
        }

        public double getFood() {
            return this.food;
        }

        public void setFood(double food) {
            this.food = food;
        }

        public int getBmdead() {
            return this.bmdead;
        }

        public void setBmdead(int bmdead) {
            this.bmdead = bmdead;
        }
    }

    public static class Monthly {
        private String month;
        private double food;

        public String getMonth() {
            return this.month;
        }

        public void setMonth(String month) {
            this.month = month;
        }

        public double getFood() {
            return this.food;
        }

        public void setFood(double food) {
            this.food = food;
        }
    }
}

