/*
 * Decompiled with CFR 0.152.
 */
package gr.cite.bluebridge.analytics.endpoint;

import gr.cite.bluebridge.analytics.endpoint.DatabaseCredentials;
import gr.cite.bluebridge.analytics.endpoint.DatabaseProfile;
import gr.cite.bluebridge.analytics.endpoint.exceptions.DatabaseDiscoveryException;
import java.security.Key;
import java.util.ArrayList;
import java.util.List;
import org.gcube.common.encryption.StringEncrypter;
import org.gcube.common.resources.gcore.ServiceEndpoint;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.resources.discovery.client.api.DiscoveryClient;
import org.gcube.resources.discovery.client.queries.api.Query;
import org.gcube.resources.discovery.client.queries.impl.XQuery;
import org.gcube.resources.discovery.icclient.ICFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class DatabaseDiscovery {
    private static Logger logger = LoggerFactory.getLogger(DatabaseDiscovery.class);

    public static DatabaseCredentials fetchDatabaseCredentials(String scope, DatabaseProfile databaseProfile) throws Exception {
        ScopeProvider.instance.set(scope);
        List databaseCredentialsList = DatabaseDiscovery.discoverDatabaseEndpoints((DatabaseProfile)databaseProfile);
        if (databaseCredentialsList.isEmpty()) {
            throw new DatabaseDiscoveryException("Failed to discover any /" + databaseProfile.getName() + " endpoint for scope " + scope);
        }
        DatabaseCredentials databaseCredentials = (DatabaseCredentials)databaseCredentialsList.get(0);
        String decryptedPass = StringEncrypter.getEncrypter().decrypt(databaseCredentials.getDbpass(), new Key[0]);
        databaseCredentials.setDbpass(decryptedPass);
        logger.debug("Managed to find " + databaseProfile.getName() + " database endpoint");
        return databaseCredentials;
    }

    public static List<DatabaseCredentials> discoverDatabaseEndpoints(DatabaseProfile databaseProfile) {
        XQuery query = ICFactory.queryFor(ServiceEndpoint.class);
        query.addCondition("$resource/Profile/Category/text() eq 'Database'").addCondition("$resource/Profile/Name/text() eq '" + databaseProfile.getName() + "'");
        DiscoveryClient client = ICFactory.clientFor(ServiceEndpoint.class);
        List serviceEndpoints = client.submit((Query)query);
        ArrayList<DatabaseCredentials> databaseCredentialsList = new ArrayList<DatabaseCredentials>();
        if (serviceEndpoints != null) {
            for (ServiceEndpoint sep : serviceEndpoints) {
                for (ServiceEndpoint.AccessPoint ap : sep.profile().accessPoints()) {
                    DatabaseCredentials databaseCredentials = new DatabaseCredentials();
                    databaseCredentials.setDbhost(ap.address());
                    databaseCredentials.setDbname(ap.name());
                    databaseCredentials.setDbuser(ap.username());
                    databaseCredentials.setDbpass(ap.password());
                    databaseCredentialsList.add(databaseCredentials);
                }
            }
        }
        return databaseCredentialsList;
    }
}

