/*
 * Decompiled with CFR 0.152.
 */
package gr.cite.bluebridge.workspace;

import com.liferay.portal.util.PortalUtil;
import gr.cite.bluebridge.analytics.web.PortletUtils;
import gr.cite.bluebridge.analytics.web.WorkspaceUtils;
import gr.cite.bluebridge.workspace.exceptions.CustomException;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import javax.portlet.PortletRequest;
import javax.portlet.ResourceRequest;
import javax.portlet.ResourceResponse;
import javax.servlet.http.HttpServletRequest;
import org.gcube.common.homelibrary.home.HomeLibrary;
import org.gcube.common.homelibrary.home.workspace.Workspace;
import org.gcube.common.homelibrary.home.workspace.WorkspaceFolder;
import org.gcube.common.homelibrary.home.workspace.WorkspaceItem;
import org.gcube.common.homelibrary.home.workspace.WorkspaceSharedFolder;
import org.gcube.common.homelibrary.home.workspace.folder.FolderItem;
import org.gcube.common.homelibrary.home.workspace.folder.items.ExternalFile;
import org.gcube.common.homelibrary.util.WorkspaceUtil;
import org.gcube.common.portal.PortalContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.portlet.bind.annotation.ResourceMapping;

@Controller
@RequestMapping(value={"VIEW"})
public class WorkspaceController {
    private static Logger logger = LoggerFactory.getLogger(WorkspaceController.class);

    @ResourceMapping(value="getWorkspace")
    public void getWorkspace(ResourceRequest request, ResourceResponse response) {
        PortalContext pContext = PortalContext.getConfiguration();
        HttpServletRequest httpServletRequest = PortalUtil.getHttpServletRequest((PortletRequest)request);
        String scope = pContext.getCurrentScope(httpServletRequest);
        String username = pContext.getCurrentUser(httpServletRequest).getUsername();
        try {
            Workspace ws = HomeLibrary.getHomeManagerFactory().getHomeManager().getHome().getWorkspace();
            WorkspaceSharedFolder vreFolder = ws.getVREFolderByScope(scope);
            WorkspaceFolder root = ws.getRoot();
            String name = vreFolder.getName();
            name = name.substring(name.lastIndexOf("-") + 1, name.length());
            HashMap<String, Object> vreNode = new HashMap<String, Object>();
            vreNode.put("text", "VRE " + name + " (Shared Folder) ");
            vreNode.put("type", "VRE/Folder");
            vreNode.put("children", true);
            vreNode.put("id", vreFolder.getId());
            vreNode.put("parent", "#");
            HashMap<String, Object> rootNode = new HashMap<String, Object>();
            rootNode.put("text", root.getName() + " of " + username);
            rootNode.put("type", "folder");
            rootNode.put("children", true);
            rootNode.put("id", root.getId());
            rootNode.put("parent", "#");
            ArrayList<HashMap<String, Object>> nodes = new ArrayList<HashMap<String, Object>>();
            nodes.add(vreNode);
            nodes.add(rootNode);
            PortletUtils.returnResponseAsJson((ResourceResponse)response, (Object)200, nodes);
        }
        catch (Exception e) {
            PortletUtils.returnResponseAsJson((ResourceResponse)response, (Object)500, (Object)"Could not load Workspace");
            logger.error("Could not load Workspace", (Throwable)e);
        }
    }

    @ResourceMapping(value="getFolders")
    public void getFolders(ResourceRequest request, ResourceResponse response, @RequestParam(value="folderId") String folderId) {
        try {
            Workspace ws = HomeLibrary.getHomeManagerFactory().getHomeManager().getHome().getWorkspace();
            ArrayList nodes = new ArrayList();
            List children = null;
            WorkspaceItem file = ws.getItem(folderId);
            if (file.isFolder()) {
                children = file.getChildren();
            }
            if (children != null) {
                for (WorkspaceItem item : children) {
                    HashMap<String, Object> node = new HashMap<String, Object>();
                    String name = item.getName();
                    item.getProperties().getPropertyValue("jcr:mimeType");
                    if (item.isFolder()) {
                        node.put("type", "folder");
                        node.put("children", true);
                    } else {
                        String mimeType = ((FolderItem)item).getMimeType();
                        if (mimeType.equals("application/json")) {
                            if (!item.getProperties().hasProperty("isEconomic")) {
                                String economics = WorkspaceUtils.streamToString((InputStream)((ExternalFile)item).getData());
                                HashMap<String, String> properties = new HashMap<String, String>();
                                if (WorkspaceUtils.isValidAnalysis((String)economics)) {
                                    properties.put("isEconomic", "true");
                                } else {
                                    properties.put("isEconomic", "false");
                                }
                                item.getProperties().addProperties(properties);
                            }
                            if (item.getProperties().getPropertyValue("isEconomic").equals("true")) {
                                mimeType = "analysis";
                            }
                        }
                        if (name.endsWith(".war")) {
                            mimeType = "war";
                        }
                        node.put("type", mimeType);
                    }
                    node.put("text", name);
                    node.put("id", item.getId());
                    node.put("parent", folderId);
                    nodes.add(node);
                }
            }
            PortletUtils.returnResponseAsJson((ResourceResponse)response, (Object)200, nodes);
        }
        catch (Exception e) {
            PortletUtils.returnResponseAsJson((ResourceResponse)response, (Object)500, (Object)"Could not load folders");
            logger.error("Could not load folders", (Throwable)e);
        }
    }

    @ResourceMapping(value="createFolder")
    public void createFolder(ResourceRequest request, ResourceResponse response, @RequestParam(value="folderName") String folderName, @RequestParam(value="folderDescription") String folderDescription, @RequestParam(value="destinationFolderId") String destinationFolderId) {
        try {
            WorkspaceUtils.isEmpty((String)folderName);
            Workspace ws = HomeLibrary.getHomeManagerFactory().getHomeManager().getHome().getWorkspace();
            WorkspaceFolder destinationFolder = (WorkspaceFolder)ws.getItem(destinationFolderId);
            if (ws.exists(folderName, destinationFolderId)) {
                folderName = WorkspaceUtil.getUniqueName((String)folderName, (WorkspaceFolder)destinationFolder);
            }
            WorkspaceFolder folder = ws.createFolder(folderName, folderDescription, destinationFolderId);
            logger.debug("Created folder " + folderName + " successfully!");
            HashMap<String, Object> node = new HashMap<String, Object>();
            node.put("id", folder.getId());
            node.put("text", folderName);
            node.put("parent", destinationFolderId);
            node.put("type", "folder");
            node.put("children", false);
            PortletUtils.returnResponseAsJson((ResourceResponse)response, (Object)200, node);
            logger.info("Created folder " + folderName + " successfully!");
        }
        catch (CustomException e) {
            logger.error(e.getMessage(), (Throwable)e);
            PortletUtils.returnResponseAsJson((ResourceResponse)response, (Object)e.getStatusCode(), (Object)e.getMessage());
        }
        catch (Exception e) {
            PortletUtils.returnResponseAsJson((ResourceResponse)response, (Object)500, (Object)("Could not create folder " + folderName));
            logger.error("Could not create folder " + folderName, (Throwable)e);
        }
    }

    @ResourceMapping(value="removeFile")
    public void removeFile(ResourceRequest request, ResourceResponse response, @RequestParam(value="fileId") String fileId) {
        try {
            Workspace ws = HomeLibrary.getHomeManagerFactory().getHomeManager().getHome().getWorkspace();
            ws.removeItem(fileId);
            PortletUtils.returnResponseAsJson((ResourceResponse)response, (Object)200, (Object)fileId);
            logger.info("Removed " + fileId + " successfully!");
        }
        catch (Exception e) {
            PortletUtils.returnResponseAsJson((ResourceResponse)response, (Object)500, (Object)"Could not remove file");
            logger.error("Could not remove file ", (Throwable)e);
        }
    }

    @ResourceMapping(value="renameFile")
    public void renameFile(ResourceRequest request, ResourceResponse response, @RequestParam(value="fileId") String fileId, @RequestParam(value="fileNewName") String fileNewName) {
        try {
            WorkspaceUtils.isEmpty((String)fileNewName);
            Workspace ws = HomeLibrary.getHomeManagerFactory().getHomeManager().getHome().getWorkspace();
            WorkspaceItem item = ws.getItem(fileId);
            WorkspaceFolder parent = item.getParent();
            WorkspaceUtils.fileExists((Workspace)ws, (String)fileNewName, (String)parent.getId());
            item.rename(fileNewName);
            PortletUtils.returnResponseAsJson((ResourceResponse)response, (Object)200, (Object)fileId);
        }
        catch (CustomException e) {
            logger.error(e.getMessage(), (Throwable)e);
            PortletUtils.returnResponseAsJson((ResourceResponse)response, (Object)e.getStatusCode(), (Object)e.getMessage());
        }
        catch (Exception e) {
            PortletUtils.returnResponseAsJson((ResourceResponse)response, (Object)500, (Object)"Could not rename file");
            logger.error("Could not remove file ", (Throwable)e);
        }
    }

    @ResourceMapping(value="saveAnalysis")
    public void saveAnalysis(ResourceRequest request, ResourceResponse response, @RequestParam(value="analysis") String analysis, @RequestParam(value="analysisName") String analysisName, @RequestParam(value="analysisDescription") String analysisDescription, @RequestParam(value="destinationFolderId") String destinationFolderId) {
        logger.debug("analysisName = " + analysisName);
        logger.debug("analysisDescription = " + analysisDescription);
        logger.debug("destinationFolderId = " + destinationFolderId);
        try {
            WorkspaceUtils.isEmpty((String)analysisName);
            Workspace ws = HomeLibrary.getHomeManagerFactory().getHomeManager().getHome().getWorkspace();
            String mimeType = "application/json";
            analysisName = analysisName + ".json";
            WorkspaceUtils.fileExists((Workspace)ws, (String)analysisName, (String)destinationFolderId);
            ByteArrayInputStream is = new ByteArrayInputStream(analysis.getBytes(StandardCharsets.UTF_8));
            ExternalFile item = ws.createExternalFile(analysisName, analysisDescription, mimeType, (InputStream)is, destinationFolderId);
            HashMap<String, String> properties = new HashMap<String, String>();
            properties.put("isEconomic", "true");
            item.getProperties().addProperties(properties);
            HashMap<String, Object> node = new HashMap<String, Object>();
            node.put("id", item.getId());
            node.put("text", analysisName);
            node.put("parent", destinationFolderId);
            node.put("type", "analysis");
            node.put("children", false);
            PortletUtils.returnResponseAsJson((ResourceResponse)response, (Object)200, node);
            logger.info("Created analysis " + analysisName + " successfully!");
        }
        catch (CustomException e) {
            logger.error(e.getMessage(), (Throwable)e);
            PortletUtils.returnResponseAsJson((ResourceResponse)response, (Object)e.getStatusCode(), (Object)e.getMessage());
        }
        catch (Exception e) {
            logger.error("Could not save analysis " + analysisName, (Throwable)e);
            PortletUtils.returnResponseAsJson((ResourceResponse)response, (Object)500, (Object)("Could not save analysis " + analysisName));
        }
    }

    @ResourceMapping(value="loadAnalysis")
    public void loadAnalysis(ResourceRequest request, ResourceResponse response, @RequestParam(value="analysisId") String analysisId) {
        logger.debug("analysisId = " + analysisId);
        try {
            Workspace ws = HomeLibrary.getHomeManagerFactory().getHomeManager().getHome().getWorkspace();
            ExternalFile economicsFile = (ExternalFile)ws.getItem(analysisId);
            String economics = WorkspaceUtils.streamToString((InputStream)economicsFile.getData());
            String date = new SimpleDateFormat("dd.MM.yy - hh.mm a").format(economicsFile.getCreationTime().getTime());
            int index = economics.lastIndexOf("}");
            economics = economics.substring(0, index) + ", \"date\" : \"" + date + "\" }";
            PortletUtils.returnResponse((ResourceResponse)response, (Object)200, (Object)economics);
            logger.info("Loaded analysis " + analysisId + " successfully!");
        }
        catch (Exception e) {
            logger.error("Could not retrieve analysis from Workspace ", (Throwable)e);
            PortletUtils.returnResponseAsJson((ResourceResponse)response, (Object)500, (Object)"Could not retrieve analysis from Workspace");
        }
    }

    @ResourceMapping(value="getInfo")
    public void getInfo(ResourceRequest request, ResourceResponse response, @RequestParam(value="fileId") String fileId) {
        logger.debug("fileId = " + fileId);
        try {
            Workspace ws = HomeLibrary.getHomeManagerFactory().getHomeManager().getHome().getWorkspace();
            WorkspaceItem item = ws.getItem(fileId);
            SimpleDateFormat formatter = new SimpleDateFormat("dd-MMM-yyyy HH:mm:ss a");
            LinkedHashMap<String, String> node = new LinkedHashMap<String, String>();
            node.put("Name", item.getName());
            node.put("Location", item.getPath());
            node.put("Type", (String)item.getType());
            node.put("Created", formatter.format(item.getCreationTime().getTime()));
            node.put("Last Updated", formatter.format(item.getLastModificationTime().getTime()));
            node.put("Description", item.getDescription());
            PortletUtils.returnResponseAsJson((ResourceResponse)response, (Object)200, node);
            logger.info("Info for " + fileId + " fetched successfully!");
        }
        catch (Exception e) {
            logger.error("Could not retrieve info ", (Throwable)e);
            PortletUtils.returnResponseAsJson((ResourceResponse)response, (Object)500, (Object)"Could not retrieve info");
        }
    }
}

