/*
 * Decompiled with CFR 0.152.
 */
package gr.cite.bluebridge.analytics.web;

import com.fasterxml.jackson.databind.ObjectMapper;
import gr.cite.bluebridge.analytics.model.Economics;
import gr.cite.bluebridge.workspace.exceptions.CustomException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.gcube.common.homelibrary.home.workspace.Workspace;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkspaceUtils {
    private static Logger logger = LoggerFactory.getLogger(WorkspaceUtils.class);

    public static boolean isValidAnalysis(String economics) {
        try {
            new ObjectMapper().readValue(economics, Economics.class);
        }
        catch (IOException e) {
            logger.debug("Unparsable Analysis", (Throwable)e);
            return false;
        }
        return true;
    }

    public static void isEmpty(String field) throws CustomException {
        if (field == null || field.length() < 1) {
            throw new CustomException(400, "Field is required and cannot be empty");
        }
    }

    public static void fileExists(Workspace ws, String fileName, String destinationFolderId) throws Exception {
        if (ws.exists(fileName, destinationFolderId)) {
            throw new CustomException(422, "File " + fileName + " already exists!");
        }
    }

    public static String streamToString(InputStream inputStream) throws IOException {
        int length;
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        while ((length = inputStream.read(buffer)) != -1) {
            result.write(buffer, 0, length);
        }
        return result.toString("UTF-8");
    }
}

