/*
 * Decompiled with CFR 0.152.
 */
package gr.cite.bluebridge.analytics.portlet;

import com.liferay.portal.util.PortalUtil;
import gr.cite.bluebridge.analytics.web.PortletUtils;
import gr.cite.bluebridge.analytics.web.SingletonHttpClient;
import gr.cite.bluebridge.endpoint.EndpointManager;
import gr.cite.bluebridge.endpoint.ServiceProfile;
import gr.cite.bluebridge.endpoint.exceptions.ServiceDiscoveryException;
import java.util.HashMap;
import java.util.List;
import javax.portlet.PortletRequest;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.ResourceRequest;
import javax.portlet.ResourceResponse;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.core.Response;
import org.gcube.common.portal.PortalContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.portlet.bind.annotation.RenderMapping;
import org.springframework.web.portlet.bind.annotation.ResourceMapping;

@Controller
@RequestMapping(value={"VIEW"})
public class PortletController {
    private static Logger logger = LoggerFactory.getLogger(PortletController.class);
    @Autowired
    private SingletonHttpClient singletonHttpClient;
    @Autowired
    private EndpointManager endpointManager;
    @Autowired
    private ServiceProfile simulFishGrowthDataAPI;
    @Autowired
    private ServiceProfile technoEconomicAnalysis;

    @RenderMapping
    public String viewHomePage(RenderRequest request, RenderResponse response) {
        return "index";
    }

    @ResourceMapping(value="performAnalysis")
    public void performAnalysis(ResourceRequest request, ResourceResponse response, @RequestParam(value="parameters") Object parameters) {
        PortalContext pContext = PortalContext.getConfiguration();
        HttpServletRequest httpServletRequest = PortalUtil.getHttpServletRequest((PortletRequest)request);
        String scope = pContext.getCurrentScope(httpServletRequest);
        String username = pContext.getCurrentUser(httpServletRequest).getUsername();
        String token = pContext.getCurrentUserToken(scope, username);
        logger.info("Performing analysis on scope \"" + scope + "\" with username \"" + username + "\"");
        try {
            List endpoints = this.endpointManager.getServiceEndpoints(scope, this.technoEconomicAnalysis);
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("scope", scope);
            headers.put("gcube-token", token);
            Integer status = null;
            Response clientResponse = null;
            for (String endpoint : endpoints) {
                String resource = endpoint + "performAnalysis";
                logger.info("Endpoint Url: " + endpoint);
                try {
                    clientResponse = this.singletonHttpClient.doPost(resource, headers, parameters);
                    status = clientResponse.getStatus();
                }
                catch (Exception e) {
                    this.endpointManager.removeServiceEndpoint(scope, this.technoEconomicAnalysis, endpoint);
                    logger.warn("Cannot reach endpoint : " + status, (Throwable)e);
                }
                if (status == null || status != 200) continue;
                break;
            }
            String result = (String)clientResponse.readEntity(String.class);
            if (status == 404 && result.contains("Tomcat")) {
                throw new Exception("Techno Economic Analysis service discovered but Not Found");
            }
            PortletUtils.returnResponse((ResourceResponse)response, (Object)status, (Object)result);
        }
        catch (ServiceDiscoveryException e) {
            PortletUtils.returnResponseAsJson((ResourceResponse)response, (Integer)404, (Object)"Could not begin analysis. Service is not up");
            logger.error("Analysis failed! Techno Economic Analysis Service could not be discovered", (Throwable)e);
        }
        catch (Exception e) {
            PortletUtils.returnResponseAsJson((ResourceResponse)response, (Integer)500, (Object)"Could not complete analysis.");
            logger.error("Analysis failed due to server internal error", (Throwable)e);
        }
    }

    @ResourceMapping(value="getProductionModels")
    public void getProductionModels(ResourceRequest request, ResourceResponse response) {
        PortalContext pContext = PortalContext.getConfiguration();
        HttpServletRequest httpServletRequest = PortalUtil.getHttpServletRequest((PortletRequest)request);
        String scope = pContext.getCurrentScope(httpServletRequest);
        String username = pContext.getCurrentUser(httpServletRequest).getUsername();
        String token = pContext.getCurrentUserToken(scope, username);
        logger.info("Requesting models on scope \"" + scope + "\" with username \"" + username + "\"");
        try {
            List endpoints = this.endpointManager.getServiceEndpoints(scope, this.simulFishGrowthDataAPI);
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("scope", scope);
            headers.put("gcube-token", token);
            Integer status = null;
            Response clientResponse = null;
            for (String endpoint : endpoints) {
                String resource = endpoint + "ModelerFull/all/" + scope.replaceAll("/", "_") + "?status=1";
                logger.info("Endpoint Url: " + endpoint);
                try {
                    clientResponse = this.singletonHttpClient.doGet(resource, headers);
                    status = clientResponse.getStatus();
                }
                catch (Exception e) {
                    status = this.singletonHttpClient.exceptionHandler(e);
                    this.endpointManager.removeServiceEndpoint(scope, this.simulFishGrowthDataAPI, endpoint);
                    logger.warn("Cannot reach endpoint : " + status, (Throwable)e);
                }
                if (status == null || status != 200) continue;
                break;
            }
            String result = (String)clientResponse.readEntity(String.class);
            if (status == 404 && result.contains("Tomcat")) {
                throw new Exception("SimulFishGrowthData discovered but Not Found");
            }
            PortletUtils.returnResponse((ResourceResponse)response, (Object)status, (Object)result);
        }
        catch (Exception e) {
            PortletUtils.returnResponseAsJson((ResourceResponse)response, (Integer)500, (Object)"Could not load Models. Models service is unreachable");
            logger.error("Could not load Models. Models service is unreachable", (Throwable)e);
        }
    }
}

