/*
 * Decompiled with CFR 0.152.
 */
package gr.cite.bluebridge.analytics.utils;

import gr.cite.bluebridge.analytics.utils.DatabaseCredentials;
import gr.cite.bluebridge.analytics.utils.ServiceProfile;
import java.security.Key;
import java.util.ArrayList;
import java.util.List;
import org.gcube.common.encryption.StringEncrypter;
import org.gcube.common.resources.gcore.ServiceEndpoint;
import org.gcube.resources.discovery.client.api.DiscoveryClient;
import org.gcube.resources.discovery.client.queries.api.Query;
import org.gcube.resources.discovery.client.queries.impl.XQuery;
import org.gcube.resources.discovery.icclient.ICFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class DatabaseDiscovery {
    public static DatabaseCredentials fetchDatabaseCredentials(String scope, ServiceProfile serviceProfile) throws Exception {
        List databaseCredentialsList = DatabaseDiscovery.discoverDatabaseEndpoints((String)scope, (ServiceProfile)serviceProfile);
        if (databaseCredentialsList.isEmpty()) {
            throw new Exception("Did not manage to discover any " + serviceProfile.getServiceClass() + "/" + serviceProfile.getServiceName() + " endpoint");
        }
        DatabaseCredentials databaseCredentials = (DatabaseCredentials)databaseCredentialsList.get(0);
        String decryptedPass = StringEncrypter.getEncrypter().decrypt(databaseCredentials.getDbpass(), new Key[0]);
        databaseCredentials.setDbpass(decryptedPass);
        System.out.println("Managed to find " + serviceProfile.getServiceName() + " database endpoint ");
        System.out.println("Database Credentials");
        System.out.println("name = " + databaseCredentials.getDbname());
        System.out.println("host = " + databaseCredentials.getDbhost());
        System.out.println("user = " + databaseCredentials.getDbuser());
        System.out.println("pass = " + databaseCredentials.getDbpass());
        return databaseCredentials;
    }

    public static List<DatabaseCredentials> discoverDatabaseEndpoints(String scope, ServiceProfile serviceProfile) {
        XQuery query = ICFactory.queryFor(ServiceEndpoint.class);
        query.addCondition("$resource/Profile/Category/text() eq 'Database'").addCondition("$resource/Profile/Name/text() eq '" + serviceProfile.getServiceName() + "'");
        DiscoveryClient client = ICFactory.clientFor(ServiceEndpoint.class);
        List serviceEndpoints = client.submit((Query)query);
        ArrayList<DatabaseCredentials> databaseCredentialsList = new ArrayList<DatabaseCredentials>();
        for (ServiceEndpoint sep : serviceEndpoints) {
            for (ServiceEndpoint.AccessPoint ap : sep.profile().accessPoints()) {
                DatabaseCredentials databaseCredentials = new DatabaseCredentials();
                databaseCredentials.setDbhost(ap.address());
                databaseCredentials.setDbname(ap.name());
                databaseCredentials.setDbuser(ap.username());
                databaseCredentials.setDbpass(ap.password());
                databaseCredentialsList.add(databaseCredentials);
            }
        }
        return databaseCredentialsList;
    }
}

