/*
 * Decompiled with CFR 0.152.
 */
package gr.cite.bluebridge.analytics.logic;

import gr.cite.bluebridge.analytics.model.Consumption;
import gr.cite.bluebridge.analytics.model.Economics;
import gr.cite.bluebridge.analytics.model.Fish;
import gr.cite.bluebridge.analytics.model.FryGeneration;
import gr.cite.bluebridge.analytics.model.ItemCost;
import gr.cite.bluebridge.analytics.model.Model;
import gr.cite.bluebridge.analytics.model.ModelInput;
import gr.cite.bluebridge.analytics.model.OA;
import gr.cite.bluebridge.analytics.model.ProductMix;
import gr.cite.bluebridge.analytics.model.ProductPrice;
import gr.cite.bluebridge.analytics.model.Revenue;
import gr.cite.bluebridge.analytics.model.Scenario;
import gr.cite.bluebridge.analytics.model.ShoppingCost;
import gr.cite.bluebridge.analytics.model.ShoppingList;
import gr.cite.bluebridge.analytics.model.Values;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

/*
 * Exception performing whole class analysis ignored.
 */
public class Evaluator {
    public static final int startYear = 2017;
    public static final int endYear = 2026;
    public static final int deduction = 5;
    public static final double irrGuess1 = 0.01;
    public static final double irrGuess2 = 0.0;
    public static final double PACKAGING_COST_PER_FISH = 0.22;
    public static final double WEIGHT_PER_FISH = 419.38;
    private Map<Integer, Integer> harvestedGenerationsPerYear = new HashMap();

    public static void main(String[] args) {
        ModelInput input = new ModelInput();
        Fish giltheadSeaBream = new Fish();
        giltheadSeaBream.setFish("giltheadSeaBream");
        giltheadSeaBream.setMixPercent(100.0);
        giltheadSeaBream.setInitialPrice(5.2);
        input.setOffShoreAquaFarm(true);
        input.getFishes().add(giltheadSeaBream);
        input.setFeedPrice(1.15);
        input.setFryPrice(0.2);
        input.setTaxRate(29.0);
        input.setDiscountRate(3.75);
        input.setMaturity(18);
        TreeMap<Integer, Double> inflationRate = new TreeMap<Integer, Double>();
        inflationRate.put(2018, 0.65);
        input.setCustomInflationRateOnYear(inflationRate);
        Consumption consumption = Consumption.getFixedData();
        input.setConsumption(consumption);
        HashMap<Integer, FryGeneration> generationsPerYear = new HashMap<Integer, FryGeneration>();
        generationsPerYear.put(1, new FryGeneration(750000, 2.17));
        generationsPerYear.put(4, new FryGeneration(750000, 2.17));
        generationsPerYear.put(7, new FryGeneration(750000, 2.17));
        generationsPerYear.put(10, new FryGeneration(750000, 2.17));
        input.setGenerationsPerYear(generationsPerYear);
        Economics economics = new Evaluator().calculate(input);
        Evaluator.printValues((Values)economics.getDepreciatedValues());
        Evaluator.printValues((Values)economics.getUndepreciatedValues());
    }

    public Economics calculate(ModelInput input) {
        Model model = new Model();
        model.InitYearEntries(2017, 2026, input.getFishes());
        this.setUpProductionParameters(model, input);
        this.setUpEOL(model);
        this.calculateShoppingList(model, input);
        this.calculateItemCost(model, input);
        this.calculateShoppingCost(model);
        this.calcuateDepreciatedShoppingCost(model);
        this.calculateOACost(model, input);
        this.calculateProductPrice(input, model);
        this.calculateProductMix(input, model);
        this.calculateRevenue(input, model);
        this.calculateUndepreciatedValues(input, model);
        this.calculateDepreciatedValues(input, model);
        return model.getEconomics();
    }

    public void setUpProductionParameters(Model model, ModelInput input) {
        model.getProductionParameters().setLargeCage(30);
        model.getProductionParameters().setSmallCage(20);
        model.getProductionParameters().setAnchorsSystem(3);
        model.getProductionParameters().setIsOffShoreAquaFarm(input.isOffShoreAquaFarm());
        model.getProductionParameters().setFeedNeedPerMonth(input.getFeedNeedPerMonth());
        model.getProductionParameters().setGenerationsPerYear(input.getGenerationsPerYear());
        model.getProductionParameters().setSupportEquipment(1);
        model.getProductionParameters().setPackagingPerFish(0.22);
        model.getProductionParameters().setConsumption(input.getConsumption());
    }

    public void setUpEOL(Model model) {
        model.getEOL().setCage(20);
        model.getEOL().setNets(8);
        model.getEOL().setAnchorsSystem(15);
        model.getEOL().setAutofeedingMachine(Integer.MAX_VALUE);
        model.getEOL().setSupportEquipment(20);
    }

    public void calculateShoppingList(Model model, ModelInput input) {
        Map feedNeedPerYear = this.calculateFeedNeedPerYear(model, input);
        Double fryNeedPerYear = this.calculateFryNeedPerYear(model);
        for (int year = 2017; year <= 2026; ++year) {
            ShoppingList.YearEntry yearEntry = (ShoppingList.YearEntry)model.getShoppingList().getYearEntries().get(year);
            if ((year - 2017) % model.getEOL().getCage() == 0) {
                yearEntry.setCage(model.getProductionParameters().getLargeCage() + model.getProductionParameters().getSmallCage());
            } else {
                yearEntry.setCage(0);
            }
            if ((year - 2017) % model.getEOL().getNets() == 0) {
                yearEntry.setNets(model.getProductionParameters().getLargeCage() + model.getProductionParameters().getSmallCage());
            } else {
                yearEntry.setNets(0);
            }
            if ((year - 2017) % model.getEOL().getAnchorsSystem() == 0) {
                yearEntry.setAnchorsSystem(model.getProductionParameters().getAnchorsSystem());
            } else {
                yearEntry.setAnchorsSystem(0);
            }
            if ((year - 2017) % model.getEOL().getAutofeedingMachine() == 0 && model.getProductionParameters().getIsOffShoreAquaFarm()) {
                yearEntry.setAutofeedingMachine(1);
            } else {
                yearEntry.setAutofeedingMachine(0);
            }
            if ((year - 2017) % model.getEOL().getSupportEquipment() == 0) {
                yearEntry.setSupportEquipment(model.getProductionParameters().getSupportEquipment());
            } else {
                yearEntry.setSupportEquipment(0);
            }
            yearEntry.setFeed((double)((Integer)feedNeedPerYear.get(year)).intValue());
            yearEntry.setFry(fryNeedPerYear.doubleValue());
        }
    }

    public void calculateItemCost(Model model, ModelInput input) {
        for (int year = 2017; year <= 2026; ++year) {
            ItemCost.YearEntry yearEntry = (ItemCost.YearEntry)model.getItemCost().getYearEntries().get(year);
            if (year == 2017) {
                yearEntry.setCage(6000.0);
                yearEntry.setNets(7200.0);
                yearEntry.setAnchorsSystem(76667.0);
                yearEntry.setAutofeedingMachine(1000000.0);
                yearEntry.setSupportEquipment(500000.0);
                yearEntry.setFeed(input.getFeedPrice());
                yearEntry.setFry(input.getFryPrice());
                continue;
            }
            ItemCost.YearEntry previousYearEntry = (ItemCost.YearEntry)model.getItemCost().getYearEntries().get(year - 1);
            double inflationRate = 1.0 + input.getInflationRateOnYear(year);
            yearEntry.setCage(previousYearEntry.getCage() * inflationRate);
            yearEntry.setNets(previousYearEntry.getNets() * inflationRate);
            yearEntry.setAnchorsSystem(previousYearEntry.getAnchorsSystem() * inflationRate);
            yearEntry.setAutofeedingMachine(previousYearEntry.getAutofeedingMachine() * inflationRate);
            yearEntry.setSupportEquipment(previousYearEntry.getSupportEquipment() * inflationRate);
            yearEntry.setFeed(previousYearEntry.getFeed() * inflationRate);
            yearEntry.setFry(previousYearEntry.getFry() * inflationRate);
        }
    }

    public void calculateShoppingCost(Model model) {
        for (int year = 2017; year <= 2026; ++year) {
            ShoppingCost.YearEntry yearEntry = (ShoppingCost.YearEntry)model.getShoppingCost().getYearEntries().get(year);
            ItemCost.YearEntry itemCostYearEntry = (ItemCost.YearEntry)model.getItemCost().getYearEntries().get(year);
            ShoppingList.YearEntry shoppingListYearEntry = (ShoppingList.YearEntry)model.getShoppingList().getYearEntries().get(year);
            yearEntry.setCage(itemCostYearEntry.getCage() * (double)shoppingListYearEntry.getCage());
            yearEntry.setNets(itemCostYearEntry.getNets() * (double)shoppingListYearEntry.getNets());
            yearEntry.setAnchorsSystem(itemCostYearEntry.getAnchorsSystem() * (double)shoppingListYearEntry.getAnchorsSystem());
            yearEntry.setAutofeedingMachine(itemCostYearEntry.getAutofeedingMachine() * (double)shoppingListYearEntry.getAutofeedingMachine());
            yearEntry.setSupportEquipment(itemCostYearEntry.getSupportEquipment() * (double)shoppingListYearEntry.getSupportEquipment());
            yearEntry.setFeed(itemCostYearEntry.getFeed() * shoppingListYearEntry.getFeed());
            yearEntry.setFry(itemCostYearEntry.getFry() * shoppingListYearEntry.getFry());
        }
    }

    public void calcuateDepreciatedShoppingCost(Model model) {
        for (int year = 2017; year <= 2026; ++year) {
            ShoppingCost.YearEntry shoppingCostYearEntry = (ShoppingCost.YearEntry)model.getShoppingCost().getYearEntries().get(year);
            for (int j = 0; j < 5; ++j) {
                if (year + j > 2026) continue;
                ShoppingCost.YearEntry depreciatedYearEntry = (ShoppingCost.YearEntry)model.getDepreciatedShoppingCost().getYearEntries().get(year + j);
                double cageCost = depreciatedYearEntry.getCage() + shoppingCostYearEntry.getCage() / 5.0;
                double netsCost = depreciatedYearEntry.getNets() + shoppingCostYearEntry.getNets() / 5.0;
                double anchorsSystemCost = depreciatedYearEntry.getAnchorsSystem() + shoppingCostYearEntry.getAnchorsSystem() / 5.0;
                double autofeedingMachineCost = depreciatedYearEntry.getAutofeedingMachine() + shoppingCostYearEntry.getAutofeedingMachine() / 5.0;
                double supportEquipmentCost = depreciatedYearEntry.getSupportEquipment() + shoppingCostYearEntry.getSupportEquipment() / 5.0;
                depreciatedYearEntry.setCage(cageCost);
                depreciatedYearEntry.setNets(netsCost);
                depreciatedYearEntry.setAnchorsSystem(anchorsSystemCost);
                depreciatedYearEntry.setAutofeedingMachine(autofeedingMachineCost);
                depreciatedYearEntry.setSupportEquipment(supportEquipmentCost);
            }
            ShoppingCost.YearEntry depreciatedYearEntry = (ShoppingCost.YearEntry)model.getDepreciatedShoppingCost().getYearEntries().get(year);
            depreciatedYearEntry.setFeed(shoppingCostYearEntry.getFeed());
            depreciatedYearEntry.setFry(shoppingCostYearEntry.getFry());
        }
    }

    public void calculateOACost(Model model, ModelInput input) {
        for (int year = 2017; year <= 2026; ++year) {
            OA.YearEntry yearEntry = (OA.YearEntry)model.getOA().getYearEntries().get(year);
            if (year == 2017) {
                yearEntry.setGeneralIndustrialExpenses(600000.0);
                yearEntry.setLicense(20000.0);
                continue;
            }
            OA.YearEntry previousYearEntry = (OA.YearEntry)model.getOA().getYearEntries().get(year - 1);
            double inflationRateThisYear = 1.0 + input.getInflationRateOnYear(year);
            double generalIndustrialExpenses = previousYearEntry.getGeneralIndustrialExpenses();
            yearEntry.setGeneralIndustrialExpenses(generalIndustrialExpenses * inflationRateThisYear);
        }
        this.calculateFishWeightPerYear(model);
        double packagingCostPerFish = model.getProductionParameters().getPackagingPerFish();
        for (int year = 2018; year <= 2026; ++year) {
            OA.YearEntry yearEntry = (OA.YearEntry)model.getOA().getYearEntries().get(year);
            double inflationRate = 1.0 + input.getInflationRateOnYear(year);
            long fishCount = ((Scenario.YearEntry)model.getScenario().getYearEntries().get(year)).getFishCount();
            double packagingCostThisYear = (packagingCostPerFish *= inflationRate) * (double)fishCount;
            yearEntry.setPackagingCost(packagingCostThisYear);
        }
    }

    public void calculateProductPrice(ModelInput input, Model model) {
        Map yearEntry;
        int year;
        for (year = 2017; year <= 2026; ++year) {
            yearEntry = (Map)model.getProductPrice().getYearEntries().get(year);
            for (Fish fish : input.getFishes()) {
                if (year == 2017) {
                    ((ProductPrice.YearEntry)yearEntry.get(fish)).setPrice(fish.getInitialPrice());
                    continue;
                }
                Map previousYearEntry = (Map)model.getProductPrice().getYearEntries().get(year - 1);
                double previousYearPrice = ((ProductPrice.YearEntry)previousYearEntry.get(fish)).getPrice();
                double fishPrice = previousYearPrice * (1.0 + input.getInflationRateOnYear(year));
                ((ProductPrice.YearEntry)yearEntry.get(fish)).setPrice(fishPrice);
            }
        }
        for (year = 2017; year <= 2026; ++year) {
            yearEntry = (Map)model.getProductPrice().getYearEntries().get(year);
            for (Fish fish : input.getFishes()) {
                ((ProductPrice.YearEntry)yearEntry.get(fish)).setPrice(((ProductPrice.YearEntry)yearEntry.get(fish)).getPrice());
            }
        }
    }

    public void calculateProductMix(ModelInput input, Model model) {
        for (int year = 2017; year <= 2026; ++year) {
            Map yearEntry = (Map)model.getProductMix().getYearEntries().get(year);
            for (Fish fish : input.getFishes()) {
                long kg = this.roundToLong(fish.getMixPercent() / 100.0 * ((Scenario.YearEntry)model.getScenario().getYearEntries().get(year)).getKG());
                ((ProductMix.YearEntry)yearEntry.get(fish)).setKG((double)kg);
            }
        }
    }

    public void calculateRevenue(ModelInput input, Model model) {
        for (int year = 2017; year <= 2026; ++year) {
            Map yearEntry = (Map)model.getRevenue().getYearEntries().get(year);
            Map productMixYearEntry = (Map)model.getProductMix().getYearEntries().get(year);
            Map productPriceYearEntry = (Map)model.getProductPrice().getYearEntries().get(year);
            for (Fish fish : input.getFishes()) {
                double revenue = ((ProductMix.YearEntry)productMixYearEntry.get(fish)).getKG() * ((ProductPrice.YearEntry)productPriceYearEntry.get(fish)).getPrice();
                ((Revenue.YearEntry)yearEntry.get(fish)).setRevenue(revenue);
            }
        }
    }

    public void calculateUndepreciatedValues(ModelInput input, Model model) {
        double previousIrr;
        for (int i = 2017; i <= 2026; ++i) {
            Values.YearEntry yearEntry = (Values.YearEntry)model.getEconomics().getUndepreciatedValues().getYearEntries().get(i);
            Values.YearEntry previousYearEntry = i == 2017 ? null : (Values.YearEntry)model.getEconomics().getUndepreciatedValues().getYearEntries().get(i - 1);
            OA.YearEntry oaYearEntry = (OA.YearEntry)model.getOA().getYearEntries().get(i);
            yearEntry.setOACost(-(oaYearEntry.getLicense() + oaYearEntry.getGeneralIndustrialExpenses() + oaYearEntry.getPackagingCost()));
            ShoppingCost.YearEntry shoppingCostYearEntry = (ShoppingCost.YearEntry)model.getShoppingCost().getYearEntries().get(i);
            yearEntry.setTotalShoppingCost(-(shoppingCostYearEntry.getCage() + shoppingCostYearEntry.getNets() + shoppingCostYearEntry.getAnchorsSystem() + shoppingCostYearEntry.getAutofeedingMachine() + shoppingCostYearEntry.getSupportEquipment() + shoppingCostYearEntry.getFeed() + shoppingCostYearEntry.getFry()));
            yearEntry.setExpenses(yearEntry.getOACost() + yearEntry.getTotalShoppingCost());
            Map revenueYearEntry = (Map)model.getRevenue().getYearEntries().get(i);
            double income = 0.0;
            for (Fish fish : input.getFishes()) {
                income += ((Revenue.YearEntry)revenueYearEntry.get(fish)).getRevenue();
            }
            yearEntry.setIncome(income);
            yearEntry.setPreTaxBalance(yearEntry.getExpenses() + yearEntry.getIncome());
            if (i == 2017) {
                yearEntry.setCummulativeCost(yearEntry.getOACost() + yearEntry.getTotalShoppingCost());
            } else {
                yearEntry.setCummulativeCost(previousYearEntry.getCummulativeCost() + yearEntry.getOACost() + yearEntry.getTotalShoppingCost());
            }
            yearEntry.setTax(yearEntry.getPreTaxBalance() > 0.0 ? -yearEntry.getPreTaxBalance() * input.getTaxRate() / 100.0 : 0.0);
            yearEntry.setAfterTaxBalance(yearEntry.getPreTaxBalance() + yearEntry.getTax());
            if (i == 2017) {
                yearEntry.setCummulativeGL(yearEntry.getPreTaxBalance());
            } else {
                yearEntry.setCummulativeGL(previousYearEntry.getCummulativeGL() + yearEntry.getPreTaxBalance());
            }
            if (i == 2017) {
                yearEntry.setAfterTaxCummulativeGL(yearEntry.getAfterTaxBalance());
            } else {
                yearEntry.setAfterTaxCummulativeGL(previousYearEntry.getAfterTaxCummulativeGL() + yearEntry.getAfterTaxBalance());
            }
            yearEntry.setNetProfitMargin((yearEntry.getIncome() + yearEntry.getExpenses()) / -yearEntry.getExpenses());
        }
        double npv = this.calculateNPV(model.getEconomics().getUndepreciatedValues(), input.getDiscountRate() / 100.0);
        model.getEconomics().getUndepreciatedValues().getTargetIndicators().setNPV(npv);
        double irr = 0.0;
        double guess1 = 0.01;
        double guess2 = 0.0;
        boolean firstIteration = true;
        do {
            boolean moreThanRangeGuess1Guess2;
            double distanceGuess2Irr;
            previousIrr = irr;
            irr = this.calculateIRR(model.getEconomics().getUndepreciatedValues(), guess1, guess2);
            if (firstIteration) {
                firstIteration = false;
                guess2 = irr;
                continue;
            }
            double distanceGuess1Irr = Math.abs(guess1 - irr);
            int winner = Double.compare(distanceGuess1Irr, distanceGuess2Irr = Math.abs(guess2 - irr)) < 0 ? 1 : 2;
            boolean lessThanRangeGuess1Guess2 = Double.compare(irr, guess1) < 0 && Double.compare(irr, guess2) < 0;
            boolean bl = moreThanRangeGuess1Guess2 = Double.compare(irr, guess1) > 0 && Double.compare(irr, guess2) > 0;
            if (lessThanRangeGuess1Guess2 || moreThanRangeGuess1Guess2) {
                if (winner == 1) {
                    guess2 = irr;
                    continue;
                }
                guess1 = irr;
                continue;
            }
            if (winner == 1) {
                guess2 /= 2.0;
                continue;
            }
            guess1 /= 2.0;
        } while (Math.abs(previousIrr - irr) > 9.0E-6);
        model.getEconomics().getUndepreciatedValues().getTargetIndicators().setIRR(this.roundWithPrecision(irr, 4));
    }

    public void calculateDepreciatedValues(ModelInput input, Model model) {
        double previousIrr;
        for (int i = 2017; i <= 2026; ++i) {
            Values.YearEntry yearEntry = (Values.YearEntry)model.getEconomics().getDepreciatedValues().getYearEntries().get(i);
            Values.YearEntry previousYearEntry = i == 2017 ? null : (Values.YearEntry)model.getEconomics().getDepreciatedValues().getYearEntries().get(i - 1);
            OA.YearEntry oaYearEntry = (OA.YearEntry)model.getOA().getYearEntries().get(i);
            yearEntry.setOACost(-(oaYearEntry.getLicense() + oaYearEntry.getGeneralIndustrialExpenses() + oaYearEntry.getPackagingCost()));
            ShoppingCost.YearEntry depreciatedShoppingCostYearEntry = (ShoppingCost.YearEntry)model.getDepreciatedShoppingCost().getYearEntries().get(i);
            yearEntry.setTotalShoppingCost(-(depreciatedShoppingCostYearEntry.getCage() + depreciatedShoppingCostYearEntry.getNets() + depreciatedShoppingCostYearEntry.getAnchorsSystem() + depreciatedShoppingCostYearEntry.getAutofeedingMachine() + depreciatedShoppingCostYearEntry.getSupportEquipment() + depreciatedShoppingCostYearEntry.getFeed() + depreciatedShoppingCostYearEntry.getFry()));
            yearEntry.setExpenses(yearEntry.getOACost() + yearEntry.getTotalShoppingCost());
            Map revenueYearEntry = (Map)model.getRevenue().getYearEntries().get(i);
            double income = 0.0;
            for (Fish fish : input.getFishes()) {
                income += ((Revenue.YearEntry)revenueYearEntry.get(fish)).getRevenue();
            }
            yearEntry.setIncome(income);
            yearEntry.setPreTaxBalance(yearEntry.getExpenses() + yearEntry.getIncome());
            if (i == 2017) {
                yearEntry.setCummulativeCost(yearEntry.getOACost() + yearEntry.getTotalShoppingCost());
            } else {
                yearEntry.setCummulativeCost(previousYearEntry.getCummulativeCost() + yearEntry.getOACost() + yearEntry.getTotalShoppingCost());
            }
            yearEntry.setTax(yearEntry.getPreTaxBalance() > 0.0 ? -yearEntry.getPreTaxBalance() * input.getTaxRate() / 100.0 : 0.0);
            yearEntry.setAfterTaxBalance(yearEntry.getPreTaxBalance() + yearEntry.getTax());
            if (i == 2017) {
                yearEntry.setCummulativeGL(yearEntry.getPreTaxBalance());
            } else {
                yearEntry.setCummulativeGL(previousYearEntry.getCummulativeGL() + yearEntry.getPreTaxBalance());
            }
            if (i == 2017) {
                yearEntry.setAfterTaxCummulativeGL(yearEntry.getAfterTaxBalance());
            } else {
                yearEntry.setAfterTaxCummulativeGL(previousYearEntry.getAfterTaxCummulativeGL() + yearEntry.getAfterTaxBalance());
            }
            yearEntry.setNetProfitMargin((yearEntry.getIncome() + yearEntry.getExpenses()) / -yearEntry.getExpenses());
        }
        double npv = this.calculateNPV(model.getEconomics().getDepreciatedValues(), input.getDiscountRate() / 100.0);
        model.getEconomics().getDepreciatedValues().getTargetIndicators().setNPV(npv);
        double irr = 0.0;
        double guess1 = 0.01;
        double guess2 = 0.0;
        boolean firstIteration = true;
        do {
            boolean moreThanRangeGuess1Guess2;
            double distanceGuess2Irr;
            previousIrr = irr;
            irr = this.calculateIRR(model.getEconomics().getDepreciatedValues(), guess1, guess2);
            if (firstIteration) {
                firstIteration = false;
                guess2 = irr;
                continue;
            }
            double distanceGuess1Irr = Math.abs(guess1 - irr);
            int winner = Double.compare(distanceGuess1Irr, distanceGuess2Irr = Math.abs(guess2 - irr)) < 0 ? 1 : 2;
            boolean lessThanRangeGuess1Guess2 = Double.compare(irr, guess1) < 0 && Double.compare(irr, guess2) < 0;
            boolean bl = moreThanRangeGuess1Guess2 = Double.compare(irr, guess1) > 0 && Double.compare(irr, guess2) > 0;
            if (lessThanRangeGuess1Guess2 || moreThanRangeGuess1Guess2) {
                if (winner == 1) {
                    guess2 = irr;
                    continue;
                }
                guess1 = irr;
                continue;
            }
            if (winner == 1) {
                guess2 /= 2.0;
                continue;
            }
            guess1 /= 2.0;
        } while (Math.abs(previousIrr - irr) > 9.0E-6);
        model.getEconomics().getDepreciatedValues().getTargetIndicators().setIRR(this.roundWithPrecision(irr, 4));
    }

    private double calculateIRR(Values values, double guess1, double guess2) {
        double npv1 = this.calculateNPV(values, guess1);
        double npv2 = this.calculateNPV(values, guess2);
        return guess1 + npv1 * (guess2 - guess1) / (npv1 - npv2);
    }

    private double calculateNPV(Values values, double rate) {
        double npv = ((Values.YearEntry)values.getYearEntries().get(2017)).getAfterTaxBalance();
        int pow = 1;
        for (int year = 2018; year <= 2026; ++year) {
            Values.YearEntry yearEntry = (Values.YearEntry)values.getYearEntries().get(year);
            double yearRate = 1.0 / Math.pow(1.0 + rate, pow);
            npv += yearEntry.getAfterTaxBalance() * yearRate;
            ++pow;
        }
        return npv;
    }

    private Map<Integer, Integer> calculateFeedNeedPerYear(Model model, ModelInput input) {
        HashMap<Integer, Integer> feedNeedPerYear = new HashMap<Integer, Integer>();
        Map feedNeedPerMonth = model.getProductionParameters().getFeedNeedPerMonth();
        Set generationsPerYear = model.getProductionParameters().getGenerationsPerYear().keySet();
        int monthsToMaturity = input.getMaturity();
        ArrayList<Integer> generationsAlive = new ArrayList<Integer>();
        for (int year = 2017; year <= 2026; ++year) {
            Iterator iterator = generationsPerYear.iterator();
            while (iterator.hasNext()) {
                int generationMonth = (Integer)iterator.next();
                generationsAlive.add(generationMonth + monthsToMaturity - 1);
            }
            int feedNeedThisYear = 0;
            int harvestedGenerationsThisYear = 0;
            ListIterator iterator2 = generationsAlive.listIterator();
            block2: while (iterator2.hasNext()) {
                int listIndex = iterator2.nextIndex();
                Integer fishGenerationMonth = (Integer)iterator2.next();
                for (int month = 1; month <= 12; ++month) {
                    if (fishGenerationMonth <= 0) continue;
                    if (monthsToMaturity + 1 - fishGenerationMonth > 0) {
                        feedNeedThisYear += ((Integer)feedNeedPerMonth.get(monthsToMaturity + 1 - fishGenerationMonth)).intValue();
                    }
                    Integer n = fishGenerationMonth;
                    Integer n2 = fishGenerationMonth = Integer.valueOf(fishGenerationMonth - 1);
                    if (fishGenerationMonth > 0) {
                        generationsAlive.set(listIndex, fishGenerationMonth);
                        continue;
                    }
                    ++harvestedGenerationsThisYear;
                    iterator2.remove();
                    continue block2;
                }
            }
            feedNeedPerYear.put(year, feedNeedThisYear);
            this.harvestedGenerationsPerYear.put(year, harvestedGenerationsThisYear);
        }
        return feedNeedPerYear;
    }

    private Double calculateFryNeedPerYear(Model model) {
        Map generationsPerYear = model.getProductionParameters().getGenerationsPerYear();
        double fryNeedPerYear = 0.0;
        for (Map.Entry entry : generationsPerYear.entrySet()) {
            FryGeneration fryGeneration = (FryGeneration)entry.getValue();
            fryNeedPerYear += (double)fryGeneration.getCount();
        }
        return fryNeedPerYear;
    }

    public void calculateFishWeightPerYear(Model model) {
        int totalBiomass = model.getProductionParameters().getConsumption().getTotalBiomassPerGeneration();
        for (int year = 2017; year <= 2026; ++year) {
            double totalFishWeight = (double)(totalBiomass * (Integer)this.harvestedGenerationsPerYear.get(year)) / 1000.0;
            long fishCount = Math.round((double)(totalBiomass * (Integer)this.harvestedGenerationsPerYear.get(year)) / 419.38);
            ((Scenario.YearEntry)model.getScenario().getYearEntries().get(year)).setKG(totalFishWeight);
            ((Scenario.YearEntry)model.getScenario().getYearEntries().get(year)).setFishCount(fishCount);
        }
    }

    public static void printValues(Values values) {
        Values.YearEntry yearEntry;
        int i;
        System.out.format("%26s", "Year");
        for (i = 2017; i <= 2026; ++i) {
            yearEntry = (Values.YearEntry)values.getYearEntries().get(i);
            System.out.format("%16d", yearEntry.getYear());
        }
        System.out.println();
        System.out.format("%26s", "OA Cost");
        for (i = 2017; i <= 2026; ++i) {
            yearEntry = (Values.YearEntry)values.getYearEntries().get(i);
            System.out.format("%16.2f", yearEntry.getOACost());
        }
        System.out.println();
        System.out.format("%26s", "Total Shopping Cost");
        for (i = 2017; i <= 2026; ++i) {
            yearEntry = (Values.YearEntry)values.getYearEntries().get(i);
            System.out.format("%16.2f", yearEntry.getTotalShoppingCost());
        }
        System.out.println();
        System.out.format("%26s", "Expenses");
        for (i = 2017; i <= 2026; ++i) {
            yearEntry = (Values.YearEntry)values.getYearEntries().get(i);
            System.out.format("%16.2f", yearEntry.getExpenses());
        }
        System.out.println();
        System.out.format("%26s", "Income");
        for (i = 2017; i <= 2026; ++i) {
            yearEntry = (Values.YearEntry)values.getYearEntries().get(i);
            System.out.format("%16.2f", yearEntry.getIncome());
        }
        System.out.println();
        System.out.format("%26s", "Pre Tax Balance");
        for (i = 2017; i <= 2026; ++i) {
            yearEntry = (Values.YearEntry)values.getYearEntries().get(i);
            System.out.format("%16.2f", yearEntry.getPreTaxBalance());
        }
        System.out.println();
        System.out.format("%26s", "Cummulative Cost");
        for (i = 2017; i <= 2026; ++i) {
            yearEntry = (Values.YearEntry)values.getYearEntries().get(i);
            System.out.format("%16.2f", yearEntry.getCummulativeCost());
        }
        System.out.println();
        System.out.format("%26s", "Tax");
        for (i = 2017; i <= 2026; ++i) {
            yearEntry = (Values.YearEntry)values.getYearEntries().get(i);
            System.out.format("%16.2f", yearEntry.getTax());
        }
        System.out.println();
        System.out.format("%26s", "After Tax Balance");
        for (i = 2017; i <= 2026; ++i) {
            yearEntry = (Values.YearEntry)values.getYearEntries().get(i);
            System.out.format("%16.2f", yearEntry.getAfterTaxBalance());
        }
        System.out.println();
        System.out.format("%26s", "Cummulative GL");
        for (i = 2017; i <= 2026; ++i) {
            yearEntry = (Values.YearEntry)values.getYearEntries().get(i);
            System.out.format("%16.2f", yearEntry.getCummulativeGL());
        }
        System.out.println();
        System.out.format("%26s", "After Tax Cummulative GL");
        for (i = 2017; i <= 2026; ++i) {
            yearEntry = (Values.YearEntry)values.getYearEntries().get(i);
            System.out.format("%16.2f", yearEntry.getAfterTaxCummulativeGL());
        }
        System.out.println();
        System.out.println("NPV: " + values.getTargetIndicators().getNPV());
        System.out.println("IRR: " + values.getTargetIndicators().getIRR());
    }

    private void printAll(Model model) {
        System.out.format("%90s", "Depreciated Shopping Cost");
        model.getDepreciatedShoppingCost().print(2017, 2026);
        System.out.println("\n");
        System.out.format("%90s", "Shopping Cost");
        model.getShoppingCost().print(2017, 2026);
        System.out.println("\n");
        System.out.format("%90s", "OA Cost");
        model.getOA().print(2017, 2026);
        System.out.println("\n");
        System.out.format("%90s", "Item Cost");
        model.getItemCost().print(2017, 2026);
        System.out.println("\n");
        System.out.format("%90s", "Product Price");
        model.getProductPrice().print(2017, 2026);
        System.out.println("\n");
        System.out.format("%90s", "Revenue");
        model.getRevenue().print(2017, 2026);
    }

    private double roundWithPrecision(double value, int roundPrecision) {
        int pow = 10;
        for (int i = 1; i < roundPrecision; ++i) {
            pow *= 10;
        }
        double tmp = value * (double)pow;
        return (double)((int)(tmp - (double)((int)tmp) >= 0.5 ? tmp + 1.0 : tmp)) / (double)pow;
    }

    private long roundToLong(double value) {
        return Math.round(value);
    }
}

