/*
 * Decompiled with CFR 0.152.
 */
package gr.cite.bluebridge.analytics.model;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import gr.cite.bluebridge.analytics.model.Consumption;
import gr.cite.bluebridge.analytics.model.Fish;
import gr.cite.bluebridge.analytics.model.FryGeneration;
import gr.cite.bluebridge.analytics.model.ModelInput;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class ModelInput {
    private double taxRate;
    private double feedPrice;
    private double fryPrice;
    private double sellingPrice;
    private double discountRate;
    private int maturity;
    private boolean isOffShoreAquaFarm;
    private Consumption consumption;
    private List<Fish> fishes = new ArrayList();
    private TreeMap<Integer, Double> inflationRate;
    private Map<Integer, FryGeneration> generationsPerYear;

    public int getMaturity() {
        return this.maturity;
    }

    public void setMaturity(int maturity) {
        this.maturity = maturity;
    }

    public double getDiscountRate() {
        return this.discountRate;
    }

    public void setDiscountRate(double discountRate) {
        this.discountRate = discountRate;
    }

    public TreeMap<Integer, Double> getInflationRate() {
        return this.inflationRate;
    }

    public void setInflationRate(Object inflationRate) {
        ObjectMapper mapper = new ObjectMapper();
        1 typeRef = new /* Unavailable Anonymous Inner Class!! */;
        try {
            this.inflationRate = (TreeMap)mapper.readValue((String)inflationRate, (TypeReference)typeRef);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public List<Fish> getFishes() {
        return this.fishes;
    }

    public void setFishes(List<Fish> fishes) {
        this.fishes = fishes;
    }

    public double getTaxRate() {
        return this.taxRate;
    }

    public void setTaxRate(double taxRate) {
        this.taxRate = taxRate;
    }

    public double getFeedPrice() {
        return this.feedPrice;
    }

    public void setFeedPrice(double feedPrice) {
        this.feedPrice = feedPrice;
    }

    public double getFryPrice() {
        return this.fryPrice;
    }

    public void setFryPrice(double fryPrice) {
        this.fryPrice = fryPrice;
    }

    public double getSellingPrice() {
        return this.sellingPrice;
    }

    public void setSellingPrice(double sellingPrice) {
        this.sellingPrice = sellingPrice;
    }

    public boolean isOffShoreAquaFarm() {
        return this.isOffShoreAquaFarm;
    }

    public void setOffShoreAquaFarm(boolean isOffShoreAquaFarm) {
        this.isOffShoreAquaFarm = isOffShoreAquaFarm;
    }

    public Consumption getConsumption() {
        return this.consumption;
    }

    public void setConsumption(Consumption consumption) {
        this.consumption = consumption;
    }

    public Map<Integer, Integer> getFeedNeedPerMonth() {
        return this.consumption.getFeedNeedPerMonth();
    }

    public Map<Integer, FryGeneration> getGenerationsPerYear() {
        return this.generationsPerYear;
    }

    public void setGenerationsPerYear(Map<Integer, FryGeneration> generationsPerYear) {
        this.generationsPerYear = generationsPerYear;
    }

    public Double getInflationRateOnYear(int year) {
        return this.inflationRate.containsKey(year) ? this.roundWithPrecision((Double)this.inflationRate.get(year) / 100.0, 4) : this.roundWithPrecision((Double)this.inflationRate.floorEntry(year).getValue() / 100.0, 4);
    }

    public void setCustomInflationRateOnYear(TreeMap<Integer, Double> map) {
        this.inflationRate = map;
    }

    private double roundWithPrecision(double value, int roundPrecision) {
        int pow = 10;
        for (int i = 1; i < roundPrecision; ++i) {
            pow *= 10;
        }
        double tmp = value * (double)pow;
        return (double)((int)(tmp - (double)((int)tmp) >= 0.5 ? tmp + 1.0 : tmp)) / (double)pow;
    }
}

