/*
 * Decompiled with CFR 0.152.
 */
package gr.cite.commons.util.datarepository.elements;

import gr.cite.commons.util.datarepository.elements.FolderInfo;
import gr.cite.commons.util.datarepository.elements.RepositoryFile;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSeeAlso;
import javax.xml.bind.annotation.XmlTransient;

@XmlRootElement
@XmlSeeAlso(value={FolderInfo.class})
public class RepositoryRegistry {
    private long totalSize = 0L;
    private Long lastSweep = null;
    private Long lastSweepSizeReduction = null;
    private final String fileRepositoryPath;
    private List<FolderInfo> folderInfo = new ArrayList<FolderInfo>();
    @XmlTransient
    private Map<String, FolderInfo> dictionary = new HashMap<String, FolderInfo>();
    @XmlTransient
    private Map<String, FolderInfo> folderLookup = new HashMap<String, FolderInfo>();

    private RepositoryRegistry() {
        this.fileRepositoryPath = null;
    }

    public RepositoryRegistry(String fileRepositoryPath) {
        this.fileRepositoryPath = fileRepositoryPath;
    }

    @XmlElementWrapper(name="folders")
    @XmlElement(name="folder")
    public List<FolderInfo> getFolderInfo() {
        return this.folderInfo;
    }

    public void setFolderInfo(List<FolderInfo> folderInfo) {
        this.folderInfo = folderInfo;
        this.dictionary = new HashMap<String, FolderInfo>();
        for (FolderInfo f : folderInfo) {
            this.folderLookup.put(f.getId(), f);
            for (RepositoryFile file : f.getFiles()) {
                this.dictionary.put(file.getId(), f);
            }
        }
    }

    public long getTotalSize() {
        return this.totalSize;
    }

    @XmlElement
    public void setTotalSize(long totalSize) {
        this.totalSize = totalSize;
    }

    public Long getLastSweep() {
        return this.lastSweep;
    }

    @XmlElement(required=false)
    public void setLastSweep(long lastSweep) {
        this.lastSweep = lastSweep;
    }

    public Long getLastSweepSizeReduction() {
        return this.lastSweepSizeReduction;
    }

    @XmlElement(required=false)
    public void setLastSweepSizeReduction(long lastSweepSizeReduction) {
        this.lastSweepSizeReduction = lastSweepSizeReduction;
    }

    public void addFolder(String id, URI uri) throws Exception {
        if (this.folderLookup.containsKey(id)) {
            throw new Exception("Folder " + id + " already exists");
        }
        FolderInfo f = new FolderInfo();
        f.setId(id);
        f.setUri(uri);
        this.folderInfo.add(f);
        this.folderLookup.put(id, f);
    }

    public void removeFolderIfEmpty(String id) throws Exception {
        FolderInfo f = this.folderLookup.get(id);
        if (f == null) {
            throw new Exception("Folder " + id + " does not exist");
        }
        if (!f.getFiles().isEmpty()) {
            throw new Exception("Folder " + id + " is not empty");
        }
        this.folderInfo.remove(f);
        this.folderLookup.remove(id);
    }

    public void removeFolder(String id) throws Exception {
        FolderInfo f = this.folderLookup.get(id);
        if (f == null) {
            throw new Exception("Folder " + id + " does not exist");
        }
        this.folderInfo.remove(f);
        this.folderLookup.remove(id);
        for (RepositoryFile file : f.getFiles()) {
            this.totalSize -= file.getSize();
        }
    }

    public List<String> listIds() throws Exception {
        ArrayList<String> list = new ArrayList<String>();
        for (String key : this.dictionary.keySet()) {
            FolderInfo value = this.dictionary.get(key);
            list.add(key);
        }
        return list;
    }

    public void addFile(RepositoryFile file, String folderId) throws Exception {
        FolderInfo f = this.folderLookup.get(folderId);
        if (f == null) {
            throw new Exception("Folder " + folderId + " does not exist");
        }
        if (this.dictionary.containsKey(file.getId())) {
            throw new Exception("File " + file.getId() + " already exists");
        }
        this.dictionary.put(file.getId(), f);
        f.addFile(file);
        this.totalSize += file.getSize();
    }

    public void removeFile(String id, String folderId) throws Exception {
        FolderInfo f = this.folderLookup.get(folderId);
        if (f == null) {
            throw new Exception("Folder " + folderId + " does not exist");
        }
        if (!this.dictionary.containsKey(id)) {
            throw new Exception("File " + id + "does not exist");
        }
        this.dictionary.remove(id);
        this.totalSize -= f.getFile(id).getSize();
        f.removeFile(id);
    }

    public String lookup(String fileId) throws Exception {
        FolderInfo f = this.dictionary.get(fileId);
        if (f == null) {
            return null;
        }
        return f.getId();
    }

    public FolderInfo lookupFolder(String folderId) throws Exception {
        return this.folderLookup.get(folderId);
    }

    public void createLookups() {
        this.dictionary = new HashMap<String, FolderInfo>();
        for (FolderInfo f : this.folderInfo) {
            f.createLookups();
            this.folderLookup.put(f.getId(), f);
            for (RepositoryFile file : f.getFiles()) {
                this.dictionary.put(file.getId(), f);
            }
        }
    }
}

