/*
 * Decompiled with CFR 0.152.
 */
package gr.cite.gaap.datatransferobjects;

import gr.cite.geoanalytics.dataaccess.entities.principal.Principal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrincipalMessenger {
    private static Logger logger = LoggerFactory.getLogger(PrincipalMessenger.class);
    private String systemName = null;
    private String fullName = null;
    private String initials = null;
    private String eMail = null;
    private String credential = null;
    private long expirationDate = 0L;
    private short isActive = 0;
    private String rights = null;
    private String notificationId = null;
    private String creator = null;
    private String tenant = null;
    private String originalCustomer = null;

    public PrincipalMessenger(Principal principal) {
        logger.trace("Initializing PrincipalMessenger...");
        this.systemName = principal.getName();
        this.fullName = principal.getPrincipalData().getFullName();
        this.initials = principal.getPrincipalData().getInitials();
        this.eMail = principal.getPrincipalData().getEmail();
        this.expirationDate = principal.getPrincipalData().getExpirationDate().getTime();
        this.isActive = principal.getIsActive().code();
        this.creator = principal.getCreator().getName();
        if (principal.getTenant() != null) {
            this.tenant = principal.getTenant().getName();
        }
        logger.trace("Initialized PrincipalMessenger");
    }

    public short getIsActive() {
        return this.isActive;
    }

    public void setIsActive(short isActive) {
        this.isActive = isActive;
    }

    public PrincipalMessenger() {
    }

    public String getSystemName() {
        return this.systemName;
    }

    public void setSystemName(String systemName) {
        this.systemName = systemName;
    }

    public String getFullName() {
        return this.fullName;
    }

    public void setFullName(String fullName) {
        this.fullName = fullName;
    }

    public String getInitials() {
        return this.initials;
    }

    public void setInitials(String initials) {
        this.initials = initials;
    }

    public String geteMail() {
        return this.eMail;
    }

    public void seteMail(String eMail) {
        this.eMail = eMail;
    }

    public String getCredential() {
        return this.credential;
    }

    public void setCredential(String credential) {
        this.credential = credential;
    }

    public long getExpirationDate() {
        return this.expirationDate;
    }

    public void setExpirationDate(long expirationDate) {
        this.expirationDate = expirationDate;
    }

    public String getRights() {
        return this.rights;
    }

    public void setRights(String rights) {
        this.rights = rights;
    }

    public String getNotificationId() {
        return this.notificationId;
    }

    public void setNotificationId(String notificationId) {
        this.notificationId = notificationId;
    }

    public String getCreator() {
        return this.creator;
    }

    public void setCreator(String creator) {
        this.creator = creator;
    }

    public String getTenant() {
        return this.tenant;
    }

    public void setTenant(String customer) {
        this.tenant = customer;
    }

    public String getOriginalCustomer() {
        return this.originalCustomer;
    }

    public void setOriginalCustomer(String originalCustomer) {
        this.originalCustomer = originalCustomer;
    }
}

