/*
 * Decompiled with CFR 0.152.
 */
package gr.cite.gaap.datatransferobjects;

import gr.cite.geoanalytics.dataaccess.entities.geocode.Geocode;
import gr.cite.geoanalytics.dataaccess.entities.sysconfig.xml.mapping.SystemMappingConfig;
import java.io.StringWriter;
import java.io.Writer;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GeocodeMessenger {
    private static Logger logger = LoggerFactory.getLogger(GeocodeMessenger.class);
    private String id = null;
    private String name = null;
    private Integer order = null;
    private String parentTaxonomy = null;
    private String parentTerm = null;
    private String taxonomy = null;
    private String classTaxonomy = null;
    private String classTerm = null;
    private String configuration = null;
    private boolean active = false;
    private String mappedValue = null;
    private String originalName = null;
    private String originalTaxonomyName = null;

    public GeocodeMessenger() {
        logger.trace("Initialized default contructor for GeocodeMessenger");
    }

    public GeocodeMessenger(Geocode t) throws Exception {
        logger.trace("Initializing GeocodeMessenger...");
        this.id = t.getId().toString();
        this.name = t.getName();
        this.order = t.getOrder();
        if (t.getParent() != null) {
            this.parentTaxonomy = t.getParent().getGeocodeSystem().getName();
        }
        if (t.getParent() != null) {
            this.parentTerm = t.getParent().getName();
        }
        this.taxonomy = t.getGeocodeSystem().getName();
        if (t.getGeocodeClass() != null) {
            this.classTaxonomy = t.getGeocodeClass().getGeocodeSystem().getName();
        }
        if (t.getGeocodeClass() != null) {
            this.classTerm = t.getGeocodeClass().getName();
        }
        this.active = t.getIsActive();
        logger.trace("Initialized GeocodeMessenger");
    }

    public GeocodeMessenger(Geocode t, SystemMappingConfig config) throws Exception {
        this(t);
        logger.trace("Initializing GeocodeMessenger...");
        if (config != null) {
            JAXBContext ctx = JAXBContext.newInstance((Class[])new Class[]{SystemMappingConfig.class});
            Marshaller um = ctx.createMarshaller();
            StringWriter sw = new StringWriter();
            um.marshal((Object)config, (Writer)sw);
            this.configuration = sw.toString();
        }
        logger.trace("Initialized GeocodeMessenger");
    }

    public GeocodeMessenger(Geocode t, SystemMappingConfig config, String mappedValue) throws Exception {
        this(t, config);
        logger.trace("Initializing GeocodeMessenger...");
        this.mappedValue = mappedValue;
        logger.trace("Initialized GeocodeMessenger");
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Integer getOrder() {
        return this.order;
    }

    public void setOrder(Integer order) {
        this.order = order;
    }

    public String getParentTaxonomy() {
        return this.parentTaxonomy;
    }

    public void setParentTaxonomy(String parentTaxonomy) {
        this.parentTaxonomy = parentTaxonomy;
    }

    public String getParentTerm() {
        return this.parentTerm;
    }

    public void setParentTerm(String parentTerm) {
        this.parentTerm = parentTerm;
    }

    public String getTaxonomy() {
        return this.taxonomy;
    }

    public void setTaxonomy(String taxonomy) {
        this.taxonomy = taxonomy;
    }

    public String getClassTaxonomy() {
        return this.classTaxonomy;
    }

    public void setClassTaxonomy(String classTaxonomy) {
        this.classTaxonomy = classTaxonomy;
    }

    public String getClassTerm() {
        return this.classTerm;
    }

    public void setClassTerm(String classTerm) {
        this.classTerm = classTerm;
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public String getOriginalName() {
        return this.originalName;
    }

    public void setOriginalName(String originalName) {
        this.originalName = originalName;
    }

    public String getOriginalTaxonomyName() {
        return this.originalTaxonomyName;
    }

    public void setOriginalTaxonomyName(String originalTaxonomyName) {
        this.originalTaxonomyName = originalTaxonomyName;
    }

    public String getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(String configuration) {
        this.configuration = configuration;
    }

    public String getMappedValue() {
        return this.mappedValue;
    }

    public void setMappedVale(String mappedValue) {
        this.mappedValue = mappedValue;
    }
}

