/*
 * Decompiled with CFR 0.152.
 */
package gr.cite.gaap.datatransferobjects.request;

import gr.cite.geoanalytics.util.http.CustomException;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.util.Assert;

public class GeoNetworkMetadataDTO {
    private static Logger logger = LoggerFactory.getLogger(GeoNetworkMetadataDTO.class);
    private String title;
    private String description;
    private String purpose;
    private String limitation;
    private List<String> keywords;
    private Role author = new Role();
    private Role distributor = new Role();
    private Role provider = new Role();

    public GeoNetworkMetadataDTO() {
        logger.trace("Initialized default contructor for ImportMetadata");
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getDescription() {
        return this.description;
    }

    public void setAbstractField(String abstractField) {
        this.description = abstractField;
    }

    public String getPurpose() {
        return this.purpose;
    }

    public void setPurpose(String purpose) {
        this.purpose = purpose;
    }

    public String getLimitation() {
        return this.limitation;
    }

    public void setLimitation(String limitation) {
        this.limitation = limitation;
    }

    public Role getAuthor() {
        return this.author;
    }

    public void setAuthor(Role author) {
        this.author = author;
    }

    public Role getDistributor() {
        return this.distributor;
    }

    public void setDistributor(Role distributor) {
        this.distributor = distributor;
    }

    public Role getProvider() {
        return this.provider;
    }

    public void setProvider(Role provider) {
        this.provider = provider;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public List<String> getKeywords() {
        return this.keywords;
    }

    public void setKeywords(List<String> keywords) {
        this.keywords = keywords;
    }

    public void validate() throws Exception {
        try {
            Assert.hasLength((String)this.title, (String)"Layer name cannot be empty");
            Assert.hasLength((String)this.description, (String)"Layer description cannot be empty");
            Assert.hasLength((String)this.purpose, (String)"Layer purpose cannot be empty");
            Assert.hasLength((String)this.limitation, (String)"Layer limitation cannot be empty");
            Assert.notNull((Object)this.author, (String)"Author metadata cannot be empty");
            Assert.notNull((Object)this.distributor, (String)"Distributor metadata cannot be empty");
            Assert.notNull((Object)this.provider, (String)"Provider metadata cannot be empty");
            Assert.notEmpty(this.keywords, (String)"Layer keywords cannot be empty");
            this.author.validateOrganisationName("Author");
            this.distributor.validate("Distributor");
            this.provider.validate("Provider");
        }
        catch (IllegalArgumentException e) {
            throw new CustomException(HttpStatus.BAD_REQUEST, e.getMessage());
        }
    }

    public String toString() {
        return "GeoNetworkMetadataDTO [title=" + this.title + ", description=" + this.description + ", purpose=" + this.purpose + ", keywords=" + this.keywords + ", limitation=" + this.limitation + ", Author " + this.author + " Distributor " + this.distributor + " Provider " + this.provider + "]";
    }

    public static class Role {
        private String organisationName;
        private String individualName;
        private String onlineResource;

        public String getOrganisationName() {
            return this.organisationName;
        }

        public void setOrganisationName(String organisationName) {
            this.organisationName = organisationName;
        }

        public String getIndividualName() {
            return this.individualName;
        }

        public void setIndividualName(String individualName) {
            this.individualName = individualName;
        }

        public String getOnlineResource() {
            return this.onlineResource;
        }

        public void setOnlineResource(String onlineResource) {
            this.onlineResource = onlineResource;
        }

        public void validate(String errorMessagePrefix) throws Exception {
            try {
                Assert.hasLength((String)this.organisationName, (String)(errorMessagePrefix + " Organization name cannot be empty"));
                Assert.hasLength((String)this.individualName, (String)(errorMessagePrefix + " Individual name cannot be empty"));
                Assert.hasLength((String)this.onlineResource, (String)(errorMessagePrefix + " URL cannot be empty"));
            }
            catch (IllegalArgumentException e) {
                throw new CustomException(HttpStatus.BAD_REQUEST, e.getMessage());
            }
        }

        public void validateOrganisationName(String errorMessagePrefix) throws Exception {
            try {
                Assert.hasLength((String)this.organisationName, (String)(errorMessagePrefix + " Organization name cannot be empty"));
            }
            catch (IllegalArgumentException e) {
                throw new CustomException(HttpStatus.BAD_REQUEST, e.getMessage());
            }
        }

        public String toString() {
            return "Role [organisationName=" + this.organisationName + ", individualName=" + this.individualName + ", onlineResource=" + this.onlineResource + "]";
        }
    }
}

