/*
 * Decompiled with CFR 0.152.
 */
package gr.cite.geoanalytics.dataaccess.geoserverbridge.metadata.utils;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReadMetadataProperties {
    private static Logger log = LoggerFactory.getLogger(ReadMetadataProperties.class);
    private static ReadMetadataProperties instance = null;
    private static Properties properties;
    private static InputStream input;

    private ReadMetadataProperties() {
    }

    public static ReadMetadataProperties getInstance() {
        if (instance == null) {
            properties = new Properties();
            try {
                input = Thread.currentThread().getContextClassLoader().getResourceAsStream("metadataResources.properties");
                properties.load(input);
            }
            catch (IOException ex) {
                log.error("Problem while getting stream from file 'metadataResources.properties': " + ex);
            }
            finally {
                if (input != null) {
                    try {
                        input.close();
                    }
                    catch (IOException e) {
                        log.error("Problem while trying to close stream: " + e);
                    }
                }
            }
            instance = new ReadMetadataProperties();
        }
        return instance;
    }

    public Properties getProperties() {
        return properties;
    }
}

