/*
 * Decompiled with CFR 0.152.
 */
package gr.cite.geoanalytics.dataaccess.entities.geocode.dao;

import gr.cite.geoanalytics.dataaccess.dao.JpaDao;
import gr.cite.geoanalytics.dataaccess.entities.geocode.Geocode;
import gr.cite.geoanalytics.dataaccess.entities.geocode.GeocodeSystem;
import gr.cite.geoanalytics.dataaccess.entities.geocode.TaxonomyTermLink;
import gr.cite.geoanalytics.dataaccess.entities.geocode.dao.GeocodeDao;
import gr.cite.geoanalytics.dataaccess.entities.shape.Shape;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import javax.persistence.Query;
import javax.persistence.TypedQuery;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Repository;

@Repository
public class GeocodeDaoImpl
extends JpaDao<Geocode, UUID>
implements GeocodeDao {
    private static Logger log = LoggerFactory.getLogger(GeocodeDaoImpl.class);

    @Override
    public List<Geocode> findByName(String name) {
        List result = null;
        TypedQuery query = this.entityManager.createQuery("from Geocode t where t.name = :name", Geocode.class);
        query.setParameter("name", (Object)name);
        result = query.getResultList();
        log.debug("Geocode by name: " + name);
        log.debug((result != null ? result.size() : 0) + " results");
        if (log.isDebugEnabled() && result != null) {
            for (Geocode t : result) {
                log.debug("Geocode (" + t.getName() + ")");
            }
        }
        return result;
    }

    @Override
    public List<Geocode> findByGeocodeSystem(GeocodeSystem geocodeSystem) {
        List result = null;
        TypedQuery query = this.entityManager.createQuery("from Geocode g where g.geocodeSystem = :gcs", Geocode.class);
        query.setParameter("gcs", (Object)geocodeSystem);
        result = query.getResultList();
        log.debug((result != null ? result.size() : 0) + " results");
        if (log.isDebugEnabled() && result != null) {
            for (Geocode tt : result) {
                log.debug("Geocode (" + tt.getName() + ")");
            }
        }
        return result;
    }

    @Override
    public List<Geocode> findByNameAndGeocodeSystem(String name, GeocodeSystem t) {
        List result = null;
        TypedQuery query = this.entityManager.createQuery("from Geocode t where t.name = :name and t.geocodeSystem = :tax", Geocode.class);
        query.setParameter("name", (Object)name);
        query.setParameter("tax", (Object)t);
        result = query.getResultList();
        log.debug("Geocodes by name: " + name);
        log.debug((result != null ? result.size() : 0) + " results");
        if (log.isDebugEnabled() && result != null) {
            for (Geocode tt : result) {
                log.debug("Geocode (" + tt.getName() + ")");
            }
        }
        return result;
    }

    @Override
    public List<Geocode> findAutoCreatedWithParent(GeocodeSystem t) {
        List result = null;
        TypedQuery query = this.entityManager.createQuery("from Geocode t where t.extraData= :eData", Geocode.class);
        query.setParameter("eData", (Object)("auto " + t.getName()));
        result = query.getResultList();
        log.debug("Auto created terms with parent taxonomy: " + t.getName());
        log.debug((result != null ? result.size() : 0) + " results");
        if (log.isDebugEnabled() && result != null) {
            for (Geocode tt : result) {
                log.debug("Geocode (" + tt.getName() + ")");
            }
        }
        return result;
    }

    @Override
    public List<String> listNames() {
        List result = null;
        result = this.entityManager.createQuery("select t.name from Geocode t", String.class).getResultList();
        if (log.isDebugEnabled()) {
            log.debug("List geocode names");
            log.debug((result != null ? result.size() : 0) + " results");
        }
        return result;
    }

    @Override
    public List<String> listNamesOfActive() {
        List result = null;
        result = this.entityManager.createQuery("select t.name from Geocode t where t.isActive=1", String.class).getResultList();
        if (log.isDebugEnabled()) {
            log.debug("List geocode names");
            log.debug((result != null ? result.size() : 0) + " results");
        }
        return result;
    }

    @Override
    public List<Geocode> getClassSiblings(Geocode t) {
        List result = null;
        TypedQuery query = this.entityManager.createQuery("select t from Geocode t where t.id != :id and t.geocodeClass = :cl", Geocode.class);
        query.setParameter("id", (Object)t.getId());
        query.setParameter("cl", (Object)t.getGeocodeClass());
        result = query.getResultList();
        if (log.isDebugEnabled()) {
            log.debug("Get geocode class siblings (" + t.getName() + ")");
            log.debug((result != null ? result.size() : 0) + " results");
        }
        return result;
    }

    @Override
    public List<Geocode> getSiblings(Geocode t) {
        List result = null;
        TypedQuery query = this.entityManager.createQuery("select t from Geocode t where t.id != :id and t.parent = :tt order by t.order asc", Geocode.class);
        query.setParameter("id", (Object)t.getId());
        query.setParameter("tt", (Object)t.getParent());
        result = query.getResultList();
        if (log.isDebugEnabled()) {
            log.debug("Get geocode siblings (" + t.getName() + ")");
            log.debug((result != null ? result.size() : 0) + " results");
        }
        return result;
    }

    @Override
    public List<Geocode> getChildren(Geocode t) {
        List result = null;
        TypedQuery query = this.entityManager.createQuery("select t from Geocode t where t.parent = :tt order by t.order asc", Geocode.class);
        query.setParameter("tt", (Object)t);
        result = query.getResultList();
        if (log.isDebugEnabled()) {
            log.debug("Get geocode descendants (" + t.getName() + ")");
            log.debug((result != null ? result.size() : 0) + " results");
        }
        return result;
    }

    @Override
    public List<Geocode> getClassDescendants(Geocode t) {
        List result = null;
        TypedQuery query = this.entityManager.createQuery("select t from Geocode t where t.geocodeClass = :tt", Geocode.class);
        query.setParameter("tt", (Object)t);
        result = query.getResultList();
        if (log.isDebugEnabled()) {
            log.debug("Get geocode descendants (" + t.getName() + ")");
            log.debug((result != null ? result.size() : 0) + " results");
        }
        return result;
    }

    @Override
    public List<Geocode> getLinked(Geocode t) {
        List result = null;
        TypedQuery query = this.entityManager.createQuery("select l.sourceTerm from TaxonomyTermLink l where l.destinationTerm = :tt", Geocode.class);
        query.setParameter("tt", (Object)t);
        result = query.getResultList();
        query = this.entityManager.createQuery("select l.destTerm from TaxonomyTermLink l where l.sourceTerm = :tt", Geocode.class);
        query.setParameter("tt", (Object)t);
        result.addAll(query.getResultList());
        if (log.isDebugEnabled()) {
            log.debug("Get linked geocodes (" + t.getName() + ")");
            log.debug((result != null ? result.size() : 0) + " results");
        }
        return result;
    }

    @Override
    public List<Geocode> getLinkedTerms(GeocodeSystem sourceGeocodeSystem, Geocode destTerm, TaxonomyTermLink.Verb verb) {
        TypedQuery query = this.entityManager.createQuery("select distinct stt from TaxonomyTermLink ttl, Geocode stt, Geocode dtt where stt.geocodeSystem = :t and ttl.sourceTerm = stt and ttl.destinationTerm = :tt and ttl.verb = :v", Geocode.class);
        query.setParameter("t", (Object)sourceGeocodeSystem);
        query.setParameter("tt", (Object)destTerm);
        query.setParameter("v", (Object)verb.verbCode());
        return query.getResultList();
    }

    @Override
    public List<Geocode> getLinkedTerms(Geocode destTerm, TaxonomyTermLink.Verb verb) {
        TypedQuery query = this.entityManager.createQuery("select distinct stt from TaxonomyTermLink ttl, Geocode dtt where ttl.destinationTerm = :tt and ttl.verb = :v", Geocode.class);
        query.setParameter("tt", (Object)destTerm);
        query.setParameter("v", (Object)verb.verbCode());
        return query.getResultList();
    }

    @Override
    public List<Geocode> getActiveLinkedTerms(GeocodeSystem sourceGeocodeSystem, Geocode destTerm, TaxonomyTermLink.Verb verb) {
        TypedQuery query = this.entityManager.createQuery("select distinct stt from TaxonomyTermLink ttl, Geocode stt, Geocode dtt where stt.isActive = 1 and stt.geocodeSystem = :t and ttl.sourceTerm = stt and ttl.destinationTerm = :tt and dtt.isActive = 1 and ttl.verb = :v", Geocode.class);
        query.setParameter("t", (Object)sourceGeocodeSystem);
        query.setParameter("tt", (Object)destTerm);
        query.setParameter("v", (Object)verb.verbCode());
        return query.getResultList();
    }

    @Override
    public List<Geocode> getActiveLinkedTerms(Geocode destTerm, TaxonomyTermLink.Verb verb) {
        TypedQuery query = this.entityManager.createQuery("select distinct stt from TaxonomyTermLink ttl, Geocode stt, Geocode dtt where stt.isActive = 1 and ttl.sourceTerm = stt and ttl.destinationTerm = :tt and dtt.isActive = 1 and ttl.verb = :v", Geocode.class);
        query.setParameter("tt", (Object)destTerm);
        query.setParameter("v", (Object)verb.verbCode());
        return query.getResultList();
    }

    @Override
    public List<Geocode> getGeocodesByShapes(Collection<Shape> shapes) {
        StringBuilder queryB = new StringBuilder("");
        queryB.append("FROM Geocode gc WHERE gc.shape IN :shapes");
        TypedQuery query = this.entityManager.createQuery(queryB.toString(), Geocode.class);
        query.setParameter("shapes", shapes);
        return query.getResultList();
    }

    @Override
    public List<Shape> getShapes(Geocode t) throws Exception {
        TypedQuery query = this.entityManager.createQuery("select tts.shape from GeocodeShape tts where tts.geocode = :t", Shape.class);
        query.setParameter("t", (Object)t);
        List res = query.getResultList();
        return res;
    }

    @Override
    public Shape getShape(Geocode t) throws Exception {
        List<Shape> res = this.getShapes(t);
        if (res == null || res.isEmpty()) {
            return null;
        }
        if (res.size() != 1) {
            throw new Exception("Non-unique geocode shape");
        }
        return res.get(0);
    }

    @Override
    public List<Geocode> findByNameAndTaxonomies(String geocodeName, List<GeocodeSystem> taxonomies) {
        List result = null;
        TypedQuery query = this.entityManager.createQuery("from Geocode t where t.name = :geocodeName and t.geocodeSystem in (:taxonomies)", Geocode.class);
        query.setParameter("geocodeName", (Object)geocodeName);
        query.setParameter("taxonomies", taxonomies);
        result = query.getResultList();
        log.debug("Taxonomies that we searched in:");
        log.debug("Geocode we searched by: " + geocodeName);
        log.debug((result != null ? result.size() : 0) + " results");
        if (log.isDebugEnabled() && result != null) {
            for (Geocode tt : result) {
                log.debug("Geocode (" + tt.getName() + ")");
            }
        }
        return result;
    }

    @Override
    public List<Geocode> findAllTermsByTaxonomies(List<GeocodeSystem> taxonomies) {
        List result = null;
        TypedQuery query = this.entityManager.createQuery("from Geocode t where t.geocodeSystem in (:taxonomies)", Geocode.class);
        query.setParameter("taxonomies", taxonomies);
        result = query.getResultList();
        return result;
    }

    @Override
    public boolean isGeocodeSystemLoaded(Geocode tt) {
        return this.isFieldLoaded(tt, "geocodeSystem");
    }

    @Override
    public boolean isParentLoaded(Geocode tt) {
        return this.isFieldLoaded(tt, "parent");
    }

    @Override
    public boolean isGeocodeClassLoaded(Geocode tt) {
        return this.isFieldLoaded(tt, "geocodeClass");
    }

    @Override
    public boolean isCreatorLoaded(Geocode tt) {
        return this.isFieldLoaded(tt, "creator");
    }

    @Override
    public boolean isDataLoaded(Geocode tt) {
        return this.isFieldLoaded(tt, "extraData");
    }

    @Override
    public void deleteById(Geocode tt) {
        Query query = this.entityManager.createQuery("delete Geocode tt where tt.id = :tt_id");
        query.setParameter("tt_id", (Object)tt.getId());
        query.executeUpdate();
    }

    @Override
    public Geocode loadDetails(Geocode t) {
        t.getCreator().getName();
        if (t.getParent() != null) {
            t.getParent().getId();
        }
        t.getGeocodeSystem().getId();
        return t;
    }
}

