/*
 * Decompiled with CFR 0.152.
 */
package gr.cite.geoanalytics.dataaccess.entities.shape.dao;

import gr.cite.geoanalytics.dataaccess.dao.Dao;
import gr.cite.geoanalytics.dataaccess.entities.document.Document;
import gr.cite.geoanalytics.dataaccess.entities.geocode.GeocodeSystem;
import gr.cite.geoanalytics.dataaccess.entities.shape.Shape;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.ws.rs.core.StreamingOutput;
import org.hibernate.ScrollableResults;

public interface ShapeDao
extends Dao<Shape, UUID> {
    public List<Shape> findShapesByClass(short var1);

    public List<Shape> searchShapesByName(String var1);

    public List<Shape> searchShapes(List<String> var1);

    public List<Shape> searchShapesWithin(List<String> var1, Shape var2);

    public List<Shape> searchShapesWithinByAttributes(Map<String, Shape.Attribute> var1, Shape var2);

    public boolean existShapesOfLayer(UUID var1);

    public UUID findLayerIDOfShape(Shape var1) throws Exception;

    public List<Document> findDocumentsOfShape(Shape var1);

    public Document findDocumentOfShape(Shape var1, GeocodeSystem var2) throws Exception;

    public List<Shape> findShapesOfLayerSimple(UUID var1);

    public List<Shape> findShapesOfLayer(UUID var1);

    public ScrollableResults findShapesOfLayerScrollable(UUID var1);

    public StreamingOutput findShapesOfLayerStream(UUID var1);

    public Set<String> getAttributeValuesOfShapesByLayer(UUID var1, Shape.Attribute var2);

    public void deleteShapesOfLayer(UUID var1);

    public void deleteByShapeID(UUID var1);

    public boolean equalsGeom(Shape var1, Shape var2) throws Exception;

    public boolean disjoint(Shape var1, Shape var2) throws Exception;

    public boolean intersects(Shape var1, Shape var2) throws Exception;

    public boolean touches(Shape var1, Shape var2) throws Exception;

    public boolean crosses(Shape var1, Shape var2) throws Exception;

    public boolean within(Shape var1, Shape var2) throws Exception;

    public boolean covers(Shape var1, Shape var2) throws Exception;

    public boolean contains(Shape var1, Shape var2) throws Exception;

    public boolean overlaps(Shape var1, Shape var2) throws Exception;

    public boolean relate(Shape var1, Shape var2) throws Exception;

    public double distance(Shape var1, Shape var2) throws Exception;

    public double area(Shape var1) throws Exception;

    public long countShapesOfLayer(UUID var1) throws Exception;

    public List<Shape> findEqualsGeom(Shape var1) throws Exception;

    public List<Shape> findDisjoint(Shape var1) throws Exception;

    public List<Shape> findIntersects(Shape var1) throws Exception;

    public List<Shape> findTouches(Shape var1) throws Exception;

    public List<Shape> findCrosses(Shape var1) throws Exception;

    public List<Shape> findWithin(Shape var1) throws Exception;

    public List<Shape> findCovers(Shape var1) throws Exception;

    public List<Shape> findContains(Shape var1);

    public List<Shape> findOverlaps(Shape var1) throws Exception;

    public List<Shape> findRelate(Shape var1) throws Exception;

    public List<Shape> findDistanceEqual(Shape var1, double var2) throws Exception;

    public List<Shape> findDistanceLess(Shape var1, double var2) throws Exception;

    public List<Shape> findDistanceLessOrEqual(Shape var1, double var2) throws Exception;

    public List<Shape> findDistanceGreater(Shape var1, double var2) throws Exception;

    public List<Shape> findDistanceGreaterOrEqual(Shape var1, double var2) throws Exception;

    public Shape envelope(Shape var1) throws Exception;

    public Shape boundary(Shape var1) throws Exception;

    public Shape buffer(Shape var1, float var2) throws Exception;

    public Shape convexHull(Shape var1) throws Exception;

    public Shape intersection(Shape var1, Shape var2) throws Exception;

    public Shape union(Shape var1, Shape var2) throws Exception;

    public Shape difference(Shape var1, Shape var2) throws Exception;

    public Shape symDifference(Shape var1, Shape var2) throws Exception;

    public Shape transform(Shape var1, int var2) throws Exception;

    public Shape extent(Shape var1) throws Exception;

    public long countShapes(UUID var1);

    public List<String> getAllLayerIDs();
}

