/*
 * Decompiled with CFR 0.152.
 */
package gr.cite.geoanalytics.dataaccess.entities.project.dao;

import gr.cite.geoanalytics.dataaccess.dao.JpaDao;
import gr.cite.geoanalytics.dataaccess.entities.geocode.GeocodeSystem;
import gr.cite.geoanalytics.dataaccess.entities.layer.Layer;
import gr.cite.geoanalytics.dataaccess.entities.project.Project;
import gr.cite.geoanalytics.dataaccess.entities.project.ProjectLayer;
import gr.cite.geoanalytics.dataaccess.entities.project.dao.ProjectLayerDao;
import gr.cite.geoanalytics.dataaccess.entities.tenant.Tenant;
import java.util.List;
import java.util.UUID;
import javax.persistence.NoResultException;
import javax.persistence.Query;
import javax.persistence.TypedQuery;
import org.springframework.stereotype.Repository;

@Repository
public class ProjectLayerDaoImpl
extends JpaDao<ProjectLayer, UUID>
implements ProjectLayerDao {
    @Override
    public ProjectLayer find(Project p, Layer l) {
        TypedQuery query = this.entityManager.createQuery("from ProjectLayer pl where pl.layer = :l and pl.project = :p", ProjectLayer.class);
        query.setParameter("l", (Object)l);
        query.setParameter("p", (Object)p);
        try {
            return (ProjectLayer)query.getSingleResult();
        }
        catch (NoResultException e) {
            return null;
        }
    }

    @Override
    public List<Layer> findByProject(Project p) {
        TypedQuery query = this.entityManager.createQuery("select pl.layer from ProjectLayer pl where pl.project = :p", Layer.class);
        query.setParameter("p", (Object)p);
        return query.getResultList();
    }

    @Override
    public List<GeocodeSystem> findByTenant(Tenant tenant) {
        TypedQuery query = this.entityManager.createQuery("select t2 from GeocodeSystem t2 where t2.id in (select distinct t.id from ProjectLayer pt join pt.term tt join tt.taxonomy t join pt.project p join p.creator u where u.tenant = :tenant)", GeocodeSystem.class);
        query.setParameter("tenant", (Object)tenant);
        return query.getResultList();
    }

    @Override
    public Layer findByProjectAndGeocodeSystem(Project p, GeocodeSystem t) {
        TypedQuery query = this.entityManager.createQuery("select pl.layer from ProjectLayer pl, Layer l where pl.project = :p and pl.layer = l and l.taxonomy = :t", Layer.class);
        query.setParameter("p", (Object)p);
        query.setParameter("t", (Object)t);
        try {
            return (Layer)query.getSingleResult();
        }
        catch (NoResultException e) {
            return null;
        }
    }

    @Override
    public List<Project> findByLayer(Layer l) {
        TypedQuery query = this.entityManager.createQuery("select pl.project from ProjectLayer pl where pl.layer = :l", Project.class);
        query.setParameter("l", (Object)l);
        return query.getResultList();
    }

    @Override
    public void deleteByProject(Project p) {
        Query query = this.entityManager.createQuery("delete ProjectLayer pt where pt.project = :p");
        query.setParameter("p", (Object)p);
        query.executeUpdate();
    }

    @Override
    public void deleteByLayer(Layer l) {
        Query query = this.entityManager.createQuery("delete ProjectLayer pl where pl.layer = :l");
        query.setParameter("l", (Object)l);
        query.executeUpdate();
    }

    @Override
    public ProjectLayer loadDetails(ProjectLayer pl) {
        pl.getCreator().getName();
        pl.getProject().getId();
        pl.getLayer().getId();
        return pl;
    }
}

