/*
 * Decompiled with CFR 0.152.
 */
package gr.cite.geoanalytics.dataaccess.entities.security.principal.dao;

import gr.cite.geoanalytics.dataaccess.dao.JpaDao;
import gr.cite.geoanalytics.dataaccess.entities.principal.Principal;
import gr.cite.geoanalytics.dataaccess.entities.principal.PrincipalProject;
import gr.cite.geoanalytics.dataaccess.entities.project.Project;
import gr.cite.geoanalytics.dataaccess.entities.security.principal.dao.PrincipalProjectDao;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import javax.persistence.Query;
import javax.persistence.TypedQuery;
import org.hibernate.Hibernate;
import org.springframework.stereotype.Repository;

@Repository
public class PrincipalProjectDaoImpl
extends JpaDao<PrincipalProject, UUID>
implements PrincipalProjectDao {
    @Override
    public PrincipalProject loadDetails(PrincipalProject t) {
        return null;
    }

    @Override
    public void deleteByProjectId(UUID id) {
        Query query = this.entityManager.createQuery("delete PrincipalProject pp where pp.project.id = :id");
        query.setParameter("id", (Object)id);
        query.executeUpdate();
    }

    @Override
    public void deleteByPrincipalAndProjectId(Principal principal, UUID id) {
        Query query = this.entityManager.createQuery("DELETE PrincipalProject pp WHERE pp.project.id = :id AND pp.participant = :participant");
        query.setParameter("id", (Object)id);
        query.setParameter("participant", (Object)principal);
        query.executeUpdate();
    }

    @Override
    public void deleteByPrincipalProjectIDs(Collection<UUID> principalProjectUUIDs) {
        Query query = this.entityManager.createQuery("delete PrincipalProject pp where pp.participant.id IN :principalProjectUUIDs");
        query.setParameter("principalProjectUUIDs", principalProjectUUIDs);
        query.executeUpdate();
    }

    @Override
    public List<Project> selectProjectByParticipantInGroup(Principal participant) {
        List<Object> result = new ArrayList<Project>();
        StringBuilder queryB = new StringBuilder("SELECT pp.project FROM PrincipalProject pp inner join pp.participant.groupsPrincipal gp");
        queryB.append(" WHERE gp.member=:participant");
        try {
            TypedQuery query = this.entityManager.createQuery(queryB.toString(), Project.class);
            query.setParameter("participant", (Object)participant);
            result = query.getResultList();
            this.initializePrincipalProject(result);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    @Override
    public List<Project> selectProjectByParticipant(Principal participant) {
        List<Object> result = new ArrayList<Project>();
        StringBuilder queryB = new StringBuilder("SELECT pp.project FROM PrincipalProject pp");
        queryB.append(" WHERE pp.participant=:participant");
        try {
            TypedQuery query = this.entityManager.createQuery(queryB.toString(), Project.class);
            query.setParameter("participant", (Object)participant);
            result = query.getResultList();
            this.initializePrincipalProject(result);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public void initializePrincipalProject(List<Project> projects) {
        for (Project project : projects) {
            Hibernate.initialize((Object)project.getPrincipalProject());
        }
    }

    @Override
    public PrincipalProject getByPrincipalAndProjectId(Principal principal, UUID projectId) {
        PrincipalProject result = new PrincipalProject();
        StringBuilder queryB = new StringBuilder("FROM PrincipalProject pp");
        queryB.append(" WHERE pp.participant=:participant");
        queryB.append(" AND pp.project.id = :projectId");
        try {
            TypedQuery query = this.entityManager.createQuery(queryB.toString(), PrincipalProject.class);
            query.setParameter("participant", (Object)principal);
            query.setParameter("projectId", (Object)projectId);
            result = (PrincipalProject)query.getSingleResult();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    @Override
    public List<PrincipalProject> getByPrincipalUUIDsAndProjectId(List<UUID> principalIDs, UUID projectID) {
        List<Object> ppList = new ArrayList<PrincipalProject>();
        if (principalIDs.isEmpty()) {
            return ppList;
        }
        StringBuilder queryStr = new StringBuilder("FROM PrincipalProject pp");
        queryStr.append(" WHERE pp.participant.id IN :principalIDs");
        queryStr.append(" AND pp.project.id = :projectID");
        TypedQuery query = this.entityManager.createQuery(queryStr.toString(), PrincipalProject.class);
        query.setParameter("principalIDs", principalIDs);
        query.setParameter("projectID", (Object)projectID);
        try {
            ppList = query.getResultList();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ppList;
    }
}

