/*
 * Decompiled with CFR 0.152.
 */
package gr.cite.geoanalytics.dataaccess.entities.document.dao;

import gr.cite.geoanalytics.dataaccess.dao.Dao;
import gr.cite.geoanalytics.dataaccess.entities.document.Document;
import gr.cite.geoanalytics.dataaccess.entities.geocode.GeocodeSystem;
import gr.cite.geoanalytics.dataaccess.entities.principal.Principal;
import gr.cite.geoanalytics.dataaccess.entities.project.Project;
import gr.cite.geoanalytics.dataaccess.entities.shape.Shape;
import gr.cite.geoanalytics.dataaccess.entities.tenant.Tenant;
import gr.cite.geoanalytics.dataaccess.entities.workflow.WorkflowTask;
import java.util.List;
import java.util.UUID;

public interface DocumentDao
extends Dao<Document, UUID> {
    public long totalSize();

    public List<Document> findByCreator(Principal var1);

    public List<Document> findByCustomer(Tenant var1);

    public List<Document> findByCreatorAndCustomer(Principal var1, Tenant var2);

    public Project findProjectOfDocument(Document var1) throws Exception;

    public List<WorkflowTask> findWorkflowTasksOfDocument(Project var1, Document var2) throws Exception;

    public long countWorkflowTasksOfDocument(Project var1, Document var2) throws Exception;

    public List<UUID> listDocuments();

    public List<Document> getDocumentsOfProject(Project var1);

    public List<Document> getDocumentsOfShape(Shape var1);

    public Document getDocumentOfShape(Shape var1, GeocodeSystem var2);

    public List<Document> getDocumentsOfWorkflowTask(WorkflowTask var1);

    public List<Document> searchDocuments(List<String> var1);

    public List<Document> searchDocumentsOfProject(List<String> var1, Project var2);

    public List<Document> searchDocumentsOfCreator(List<String> var1, Principal var2);
}

