package gr.cite.geoanalytics.dataaccess.entities.project.dao;

import java.util.List;
import java.util.UUID;

import gr.cite.geoanalytics.dataaccess.dao.Dao;
import gr.cite.geoanalytics.dataaccess.entities.geocode.GeocodeSystem;
import gr.cite.geoanalytics.dataaccess.entities.layer.Layer;
import gr.cite.geoanalytics.dataaccess.entities.project.Project;
import gr.cite.geoanalytics.dataaccess.entities.project.ProjectLayer;
import gr.cite.geoanalytics.dataaccess.entities.tenant.Tenant;

public interface ProjectLayerDao extends Dao<ProjectLayer, UUID>
{
	public ProjectLayer find(Project p, Layer layer);
	public List<Layer> findByProject(Project p);
	public List<GeocodeSystem> findByTenant(Tenant c);
	public Layer findByProjectAndGeocodeSystem(Project p, GeocodeSystem t);
	public List<Project> findByLayer(Layer layer);
	public void deleteByProject(Project p);
	public void deleteByLayer(Layer l);
}
