/*
 * Decompiled with CFR 0.152.
 */
package gr.cite.geoanalytics.dataaccess.entities.shape;

import com.vividsolutions.jts.geom.Geometry;
import gr.cite.geoanalytics.dataaccess.entities.Entity;
import gr.cite.geoanalytics.dataaccess.entities.Identifiable;
import gr.cite.geoanalytics.dataaccess.entities.Stampable;
import gr.cite.geoanalytics.dataaccess.entities.principal.Principal;
import gr.cite.geoanalytics.dataaccess.entities.shape.ShapeImport;
import gr.cite.geoanalytics.dataaccess.exception.SRSException;
import java.util.Date;
import java.util.UUID;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import org.hibernate.annotations.Type;

@javax.persistence.Entity
@Table(name="\"Shape\"")
public class Shape
implements Entity,
Identifiable,
Stampable {
    @Id
    @Type(type="org.hibernate.type.PostgresUUIDType")
    @Column(name="\"SHP_ID\"", nullable=false)
    private UUID id = null;
    @Column(name="\"SHP_Code\"", length=20, nullable=true)
    private String code = null;
    @Column(name="\"SHP_Name\"", length=100)
    private String name = null;
    @Column(name="\"SHP_Class\"", nullable=false)
    private int shapeClass = -1;
    @Type(type="org.hibernate.spatial.GeometryType")
    @Column(name="\"SHP_Geography\"", nullable=false, columnDefinition="Geography")
    private Geometry geography = null;
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="\"SHP_CreationDate\"", nullable=false)
    private Date creationDate = null;
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="\"SHP_LastUpdate\"", nullable=false)
    private Date lastUpdate = null;
    @ManyToOne
    @JoinColumn(name="\"SHP_Creator\"", nullable=false)
    private Principal creator = null;
    @Type(type="gr.cite.geoanalytics.dataaccess.typedefinition.XMLType")
    @Basic(fetch=FetchType.LAZY)
    @Column(name="\"SHP_ExtraData\"", columnDefinition="xml")
    private String extraData;
    @ManyToOne(fetch=FetchType.EAGER)
    @JoinColumn(name="\"SHP_ShapeImport\"")
    private ShapeImport shapeImport = null;

    @Override
    public UUID getId() {
        return this.id;
    }

    @Override
    public void setId(UUID id) {
        this.id = id;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getShapeClass() {
        return this.shapeClass;
    }

    public void setShapeClass(int shapeClass) {
        this.shapeClass = shapeClass;
    }

    public Geometry getGeography() {
        return this.geography;
    }

    public void setGeography(Geometry geography) throws Exception {
        this.geography = geography;
        if (this.geography.getSRID() == 8307) {
            this.geography.setSRID(4326);
        }
        if (this.geography.getSRID() != 4326) {
            throw new SRSException("", Integer.toString(geography.getSRID()), null);
        }
    }

    @Override
    public Date getCreationDate() {
        return this.creationDate;
    }

    @Override
    public void setCreationDate(Date creationDate) {
        this.creationDate = creationDate;
    }

    @Override
    public Date getLastUpdate() {
        return this.lastUpdate;
    }

    @Override
    public void setLastUpdate(Date lastUpdate) {
        this.lastUpdate = lastUpdate;
    }

    public Principal getCreator() {
        return this.creator;
    }

    public void setCreator(Principal creator) {
        this.creator = creator;
    }

    public String getExtraData() {
        return this.extraData;
    }

    public void setExtraData(String extraData) {
        this.extraData = extraData;
    }

    public ShapeImport getShapeImport() {
        return this.shapeImport;
    }

    public void setShapeImport(ShapeImport shapeImport) {
        this.shapeImport = shapeImport;
    }

    public String toString() {
        return "Shape(id=" + this.getId() + " name=" + this.getName() + " code=" + this.getCode() + " class=" + this.getClass() + " geography=" + this.getGeography() + " creation=" + this.getCreationDate() + " lastUpdate=" + this.getLastUpdate() + " creator=" + (this.creator != null ? this.creator.getId() : null) + " extraData=" + this.getExtraData() + " shapeImport=" + (this.shapeImport != null ? this.shapeImport : null);
    }

    public boolean equals(Object obj) {
        boolean eq;
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Shape)) {
            return false;
        }
        Shape other = (Shape)obj;
        boolean bl = eq = this.getId().equals(other.getId()) && this.getExtraData().equals(other.getExtraData()) && this.getGeography().equals(other.getGeography());
        return this.getName() != null ? eq && this.getName().equals(other.getName()) : eq;
    }

    public int hashCode() {
        int result = 17;
        result += 37 * result + this.id.hashCode();
        if (this.getName() != null) {
            result += 37 * result + this.name.hashCode();
        }
        result += 37 * result + this.geography.hashCode();
        if (this.extraData != null) {
            result += 37 * result + this.extraData.hashCode();
        }
        return result;
    }

    public static class Attribute {
        private String name = null;
        private String type = null;
        private String taxonomy = null;
        private String value = null;

        public Attribute(String name, String type, String taxonomy, String value) {
            this.name = name;
            this.type = type;
            this.taxonomy = taxonomy;
            this.value = value;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }

        public String getTaxonomy() {
            return this.taxonomy;
        }

        public void setTaxonomy(String taxonomy) {
            this.taxonomy = taxonomy;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }
    }
}

