/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.jaiext.utilities;

import com.sun.media.imageioimpl.common.PackageUtil;
import java.awt.Rectangle;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferUShort;
import java.awt.image.MultiPixelPackedSampleModel;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.text.ChoiceFormat;
import javax.media.jai.PixelAccessor;
import javax.media.jai.UnpackedImageData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImageUtilities {
    private static final boolean mediaLibAvailable;

    public static boolean isMediaLibAvailable() {
        return mediaLibAvailable;
    }

    public static boolean isCLibAvailable() {
        return PackageUtil.isCodecLibAvailable();
    }

    public static double rool(Class type, double value, int amount) throws IllegalArgumentException {
        if (Double.class.equals((Object)type)) {
            if (amount < 0) {
                do {
                    value = ImageUtilities.previous(value);
                } while (++amount != 0);
            } else if (amount != 0) {
                do {
                    value = ImageUtilities.next(value);
                } while (--amount != 0);
            }
            return value;
        }
        if (Float.class.equals((Object)type)) {
            float vf = (float)value;
            if (amount < 0) {
                do {
                    vf = ImageUtilities.next(vf, false);
                } while (++amount != 0);
            } else if (amount != 0) {
                do {
                    vf = ImageUtilities.next(vf, true);
                } while (--amount != 0);
            }
            return vf;
        }
        if (ImageUtilities.isInteger(type)) {
            return value + (double)amount;
        }
        throw new IllegalArgumentException("Unsupported DataType: " + type);
    }

    @Deprecated
    public static boolean isInteger(Class<?> type) {
        return type != null && Long.class.equals(type) || Integer.class.equals(type) || Short.class.equals(type) || Byte.class.equals(type);
    }

    public static double next(double f) {
        return ChoiceFormat.nextDouble(f);
    }

    public static double previous(double f) {
        return ChoiceFormat.previousDouble(f);
    }

    private static float next(float f, boolean positive) {
        int SIGN = Integer.MIN_VALUE;
        int POSITIVEINFINITY = 2139095040;
        if (Float.isNaN(f)) {
            return f;
        }
        if (f == 0.0f) {
            float smallestPositiveFloat = Float.intBitsToFloat(1);
            return positive ? smallestPositiveFloat : -smallestPositiveFloat;
        }
        int bits = Float.floatToIntBits(f);
        int magnitude = bits & Integer.MAX_VALUE;
        if (bits > 0 == positive) {
            if (magnitude != 2139095040) {
                ++magnitude;
            }
        } else {
            --magnitude;
        }
        int signbit = bits & Integer.MIN_VALUE;
        return Float.intBitsToFloat(magnitude | signbit);
    }

    public static void fillBackground(WritableRaster raster, Rectangle rect, double[] backgroundValues) {
        block44: {
            PixelAccessor accessor;
            block43: {
                rect = rect.intersection(raster.getBounds());
                SampleModel sm = raster.getSampleModel();
                accessor = new PixelAccessor(sm, null);
                if (!ImageUtilities.isBinary(sm)) break block43;
                byte value = (byte)((int)backgroundValues[0] & 1);
                if (value == 0) {
                    return;
                }
                int rectX = rect.x;
                int rectY = rect.y;
                int rectWidth = rect.width;
                int rectHeight = rect.height;
                int dx = rectX - raster.getSampleModelTranslateX();
                int dy = rectY - raster.getSampleModelTranslateY();
                DataBuffer dataBuffer = raster.getDataBuffer();
                MultiPixelPackedSampleModel mpp = (MultiPixelPackedSampleModel)sm;
                int lineStride = mpp.getScanlineStride();
                int eltOffset = dataBuffer.getOffset() + mpp.getOffset(dx, dy);
                int bitOffset = mpp.getBitOffset(dx);
                switch (sm.getDataType()) {
                    case 0: {
                        byte[] data = ((DataBufferByte)dataBuffer).getData();
                        int bits = bitOffset & 7;
                        int otherBits = bits == 0 ? 0 : 8 - bits;
                        byte mask = (byte)(255 >> bits);
                        int lineLength = (rectWidth - otherBits) / 8;
                        int bits1 = rectWidth - otherBits & 7;
                        byte mask1 = (byte)(255 << 8 - bits1);
                        if (lineLength == 0) {
                            mask = (byte)(mask & mask1);
                            bits1 = 0;
                        }
                        for (int y = 0; y < rectHeight; ++y) {
                            int start = eltOffset;
                            int end = start + lineLength;
                            if (bits != 0) {
                                int n = start++;
                                data[n] = (byte)(data[n] | mask);
                            }
                            while (start < end) {
                                data[start++] = -1;
                            }
                            if (bits1 != 0) {
                                int n = start;
                                data[n] = (byte)(data[n] | mask1);
                            }
                            eltOffset += lineStride;
                        }
                        break block44;
                    }
                    case 1: {
                        short[] data = ((DataBufferUShort)dataBuffer).getData();
                        int bits = bitOffset & 0xF;
                        int otherBits = bits == 0 ? 0 : 16 - bits;
                        short mask = (short)(65535 >> bits);
                        int lineLength = (rectWidth - otherBits) / 16;
                        int bits1 = rectWidth - otherBits & 0xF;
                        short mask1 = (short)(65535 << 16 - bits1);
                        if (lineLength == 0) {
                            mask = (short)(mask & mask1);
                            bits1 = 0;
                        }
                        for (int y = 0; y < rectHeight; ++y) {
                            int start = eltOffset;
                            int end = start + lineLength;
                            if (bits != 0) {
                                int n = start++;
                                data[n] = (short)(data[n] | mask);
                            }
                            while (start < end) {
                                data[start++] = -1;
                            }
                            if (bits1 != 0) {
                                int n = start++;
                                data[n] = (short)(data[n] | mask1);
                            }
                            eltOffset += lineStride;
                        }
                        break block44;
                    }
                    case 3: {
                        int[] data = ((DataBufferInt)dataBuffer).getData();
                        int bits = bitOffset & 0x1F;
                        int otherBits = bits == 0 ? 0 : 32 - bits;
                        int mask = -1 >> bits;
                        int lineLength = (rectWidth - otherBits) / 32;
                        int bits1 = rectWidth - otherBits & 0x1F;
                        int mask1 = -1 << 32 - bits1;
                        if (lineLength == 0) {
                            mask &= mask1;
                            bits1 = 0;
                        }
                        for (int y = 0; y < rectHeight; ++y) {
                            int start = eltOffset;
                            int end = start + lineLength;
                            if (bits != 0) {
                                int n = start++;
                                data[n] = data[n] | mask;
                            }
                            while (start < end) {
                                data[start++] = -1;
                            }
                            if (bits1 != 0) {
                                int n = start++;
                                data[n] = data[n] | mask1;
                            }
                            eltOffset += lineStride;
                        }
                        break block44;
                    }
                }
                break block44;
            }
            int srcSampleType = accessor.sampleType == -1 ? 0 : accessor.sampleType;
            UnpackedImageData uid = accessor.getPixels(raster, rect, srcSampleType, false);
            rect = uid.rect;
            int lineStride = uid.lineStride;
            int pixelStride = uid.pixelStride;
            switch (uid.type) {
                case 0: {
                    byte[][] bdata = uid.getByteData();
                    for (int b = 0; b < accessor.numBands; ++b) {
                        byte value = (byte)backgroundValues[b];
                        byte[] bd = bdata[b];
                        int lastLine = uid.bandOffsets[b] + rect.height * lineStride;
                        for (int lo = uid.bandOffsets[b]; lo < lastLine; lo += lineStride) {
                            int lastPixel = lo + rect.width * pixelStride;
                            for (int po = lo; po < lastPixel; po += pixelStride) {
                                bd[po] = value;
                            }
                        }
                    }
                    break;
                }
                case 1: 
                case 2: {
                    short[][] sdata = uid.getShortData();
                    for (int b = 0; b < accessor.numBands; ++b) {
                        short value = (short)backgroundValues[b];
                        short[] sd = sdata[b];
                        int lastLine = uid.bandOffsets[b] + rect.height * lineStride;
                        for (int lo = uid.bandOffsets[b]; lo < lastLine; lo += lineStride) {
                            int lastPixel = lo + rect.width * pixelStride;
                            for (int po = lo; po < lastPixel; po += pixelStride) {
                                sd[po] = value;
                            }
                        }
                    }
                    break;
                }
                case 3: {
                    int[][] idata = uid.getIntData();
                    for (int b = 0; b < accessor.numBands; ++b) {
                        int value = (int)backgroundValues[b];
                        int[] id = idata[b];
                        int lastLine = uid.bandOffsets[b] + rect.height * lineStride;
                        for (int lo = uid.bandOffsets[b]; lo < lastLine; lo += lineStride) {
                            int lastPixel = lo + rect.width * pixelStride;
                            for (int po = lo; po < lastPixel; po += pixelStride) {
                                id[po] = value;
                            }
                        }
                    }
                    break;
                }
                case 4: {
                    float[][] fdata = uid.getFloatData();
                    for (int b = 0; b < accessor.numBands; ++b) {
                        float value = (float)backgroundValues[b];
                        float[] fd = fdata[b];
                        int lastLine = uid.bandOffsets[b] + rect.height * lineStride;
                        for (int lo = uid.bandOffsets[b]; lo < lastLine; lo += lineStride) {
                            int lastPixel = lo + rect.width * pixelStride;
                            for (int po = lo; po < lastPixel; po += pixelStride) {
                                fd[po] = value;
                            }
                        }
                    }
                    break;
                }
                case 5: {
                    double[][] ddata = uid.getDoubleData();
                    for (int b = 0; b < accessor.numBands; ++b) {
                        double value = backgroundValues[b];
                        double[] dd = ddata[b];
                        int lastLine = uid.bandOffsets[b] + rect.height * lineStride;
                        for (int lo = uid.bandOffsets[b]; lo < lastLine; lo += lineStride) {
                            int lastPixel = lo + rect.width * pixelStride;
                            for (int po = lo; po < lastPixel; po += pixelStride) {
                                dd[po] = value;
                            }
                        }
                    }
                    break;
                }
            }
        }
    }

    public static boolean isBinary(SampleModel sm) {
        return sm instanceof MultiPixelPackedSampleModel && ((MultiPixelPackedSampleModel)sm).getPixelBitStride() == 1 && sm.getNumBands() == 1;
    }

    static {
        boolean mediaLib = false;
        Class<?> mediaLibImage2 = null;
        try {
            mediaLibImage2 = Class.forName("com.sun.medialib.mlib.Image");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        boolean bl = mediaLib = mediaLibImage2 != null;
        if (mediaLib) {
            try {
                boolean bl2 = mediaLib = !Boolean.getBoolean("com.sun.media.jai.disableMediaLib");
                if (mediaLib) {
                    final Class<?> mImage = mediaLibImage2;
                    mediaLib = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

                        @Override
                        public Boolean run() {
                            try {
                                Class[] params = new Class[]{};
                                Method method = mImage.getDeclaredMethod("isAvailable", params);
                                Object[] paramsObj = new Object[]{};
                                Object o = mImage.newInstance();
                                return (Boolean)method.invoke(o, paramsObj);
                            }
                            catch (Throwable e) {
                                return false;
                            }
                        }
                    });
                }
            }
            catch (Throwable e) {
                mediaLib = false;
            }
        }
        mediaLibAvailable = mediaLib;
    }
}

