/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.jaiext.utilities.shape;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import it.geosolutions.jaiext.utilities.shape.AbstractLiteIterator;
import it.geosolutions.jaiext.utilities.shape.EmptyIterator;
import it.geosolutions.jaiext.utilities.shape.LineIterator;
import it.geosolutions.jaiext.utilities.shape.PointIterator;
import it.geosolutions.jaiext.utilities.shape.PolygonIterator;
import java.awt.geom.AffineTransform;
import java.awt.geom.PathIterator;

public final class GeomCollectionIterator
extends AbstractLiteIterator {
    private AffineTransform at;
    private GeometryCollection gc;
    private int currentGeom;
    private PathIterator currentIterator;
    private boolean done = false;

    public GeomCollectionIterator() {
    }

    public void init(GeometryCollection gc, AffineTransform at) {
        this.gc = gc;
        this.at = at == null ? new AffineTransform() : at;
        this.currentGeom = 0;
        this.done = false;
        this.currentIterator = gc.isEmpty() ? EmptyIterator.INSTANCE : this.getIterator(gc.getGeometryN(0));
    }

    public GeomCollectionIterator(GeometryCollection gc, AffineTransform at) {
        this.init(gc, at);
    }

    private AbstractLiteIterator getIterator(Geometry g) {
        AbstractLiteIterator pi = null;
        if (g.isEmpty()) {
            return EmptyIterator.INSTANCE;
        }
        if (g instanceof Polygon) {
            Polygon p = (Polygon)g;
            pi = new PolygonIterator(p, this.at);
        } else if (g instanceof GeometryCollection) {
            GeometryCollection gc = (GeometryCollection)g;
            pi = new GeomCollectionIterator(gc, this.at);
        } else if (g instanceof LineString || g instanceof LinearRing) {
            LineString ls = (LineString)g;
            pi = new LineIterator(ls, this.at);
        } else if (g instanceof Point) {
            Point p = (Point)g;
            pi = new PointIterator(p, this.at);
        }
        return pi;
    }

    public int currentSegment(double[] coords) {
        return this.currentIterator.currentSegment(coords);
    }

    public int currentSegment(float[] coords) {
        return this.currentIterator.currentSegment(coords);
    }

    public int getWindingRule() {
        return 1;
    }

    public boolean isDone() {
        return this.done;
    }

    public void next() {
        if (!this.currentIterator.isDone()) {
            this.currentIterator.next();
        }
        while (this.currentIterator.isDone() && !this.done) {
            if (this.currentGeom < this.gc.getNumGeometries() - 1) {
                ++this.currentGeom;
                this.currentIterator = this.getIterator(this.gc.getGeometryN(this.currentGeom));
                continue;
            }
            this.done = true;
        }
    }
}

