/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xsd.ecore;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.URI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NameMangler {
    protected static final List<String> DOMAINS = Arrays.asList("COM", "com", "ORG", "org");
    protected static final int UNCHANGED_CASE = 0;
    protected static final int UPPER_CASE = 1;
    protected static final int LOWER_CASE = 2;

    public String uncapName(String name) {
        if (name.length() == 0) {
            return name;
        }
        String lowerName = name.toLowerCase();
        int i = 0;
        while (i < name.length()) {
            if (name.charAt(i) == lowerName.charAt(i)) break;
            ++i;
        }
        if (i > 1 && i < name.length() && !Character.isDigit(name.charAt(i))) {
            --i;
        }
        return String.valueOf(name.substring(0, i).toLowerCase()) + name.substring(i);
    }

    public String qualifiedPackageName(String namespace) {
        List<String> parsedName;
        URI uri = URI.createURI(namespace);
        if (uri.isHierarchical()) {
            String host = uri.host();
            if (host != null && host.startsWith("www.")) {
                host = host.substring(4);
            }
            parsedName = this.parseName(host, '.');
            Collections.reverse(parsedName);
            if (!parsedName.isEmpty()) {
                parsedName.set(0, parsedName.get(0).toLowerCase());
            }
            parsedName.addAll(this.parseName(uri.trimFileExtension().path(), '/'));
        } else {
            String opaquePart = uri.opaquePart();
            int index = opaquePart.indexOf(":");
            if (index != -1 && "urn".equalsIgnoreCase(uri.scheme())) {
                parsedName = this.parseName(opaquePart.substring(0, index), '-');
                if (parsedName.size() > 0 && DOMAINS.contains(parsedName.get(parsedName.size() - 1))) {
                    Collections.reverse(parsedName);
                    parsedName.set(0, parsedName.get(0).toLowerCase());
                }
                parsedName.addAll(this.parseName(opaquePart.substring(index + 1), '/'));
            } else {
                parsedName = this.parseName(opaquePart, '/');
            }
        }
        StringBuffer qualifiedPackageName = new StringBuffer();
        for (String packageName : parsedName) {
            if (packageName.length() <= 0) continue;
            if (qualifiedPackageName.length() > 0) {
                qualifiedPackageName.append('.');
            }
            qualifiedPackageName.append(this.validName(packageName, false));
        }
        return qualifiedPackageName.toString();
    }

    protected String validName(String name, boolean isUpperCase) {
        return this.validName(name, isUpperCase, "_");
    }

    protected String validName(String name, boolean isUpperCase, String prefix) {
        return this.validName(name, isUpperCase ? 1 : 2, prefix);
    }

    protected String validName(String name, int casing, String prefix) {
        List<String> parsedName = this.parseName(name, '_');
        StringBuffer result = new StringBuffer();
        for (String nameComponent : parsedName) {
            if (nameComponent.length() <= 0) continue;
            if (result.length() > 0 || casing == 1) {
                result.append(Character.toUpperCase(nameComponent.charAt(0)));
                result.append(nameComponent.substring(1));
                continue;
            }
            result.append(nameComponent);
        }
        return result.length() == 0 ? prefix : (Character.isJavaIdentifierStart(result.charAt(0)) ? (casing == 2 ? this.uncapName(result.toString()) : result.toString()) : String.valueOf(prefix) + result);
    }

    protected List<String> parseName(String sourceName, char separator) {
        ArrayList<String> result = new ArrayList<String>();
        if (sourceName != null) {
            StringBuffer currentWord = new StringBuffer();
            boolean lastIsLower = false;
            int index = 0;
            int length = sourceName.length();
            while (index < length) {
                char curChar = sourceName.charAt(index);
                if (!Character.isJavaIdentifierPart(curChar)) {
                    curChar = separator;
                }
                if (Character.isUpperCase(curChar) || !lastIsLower && Character.isDigit(curChar) || curChar == separator) {
                    if (lastIsLower && currentWord.length() > 1 || curChar == separator && currentWord.length() > 0) {
                        result.add(currentWord.toString());
                        currentWord = new StringBuffer();
                    }
                    lastIsLower = false;
                } else {
                    int currentWordLength;
                    if (!lastIsLower && (currentWordLength = currentWord.length()) > 1) {
                        char lastChar = currentWord.charAt(--currentWordLength);
                        currentWord.setLength(currentWordLength);
                        result.add(currentWord.toString());
                        currentWord = new StringBuffer();
                        currentWord.append(lastChar);
                    }
                    lastIsLower = true;
                }
                if (curChar != separator) {
                    currentWord.append(curChar);
                }
                ++index;
            }
            result.add(currentWord.toString());
        }
        return result;
    }
}

