/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gml3.bindings;

import java.util.Collections;
import java.util.HashMap;
import javax.xml.namespace.QName;
import org.geotools.feature.FeatureImpl;
import org.geotools.feature.NameImpl;
import org.geotools.gml3.GML;
import org.geotools.gml3.XSDIdRegistry;
import org.geotools.gml3.bindings.GML3EncodingUtils;
import org.geotools.util.Converters;
import org.geotools.xlink.XLINK;
import org.geotools.xml.AbstractComplexBinding;
import org.geotools.xml.ElementInstance;
import org.geotools.xml.Node;
import org.opengis.feature.ComplexAttribute;
import org.opengis.feature.Feature;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.type.Name;
import org.opengis.filter.identity.FeatureId;
import org.opengis.filter.identity.Identifier;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;

public class FeaturePropertyTypeBinding
extends AbstractComplexBinding {
    private XSDIdRegistry idSet;

    public FeaturePropertyTypeBinding(XSDIdRegistry idSet) {
        this.idSet = idSet;
    }

    @Override
    public QName getTarget() {
        return GML.FeaturePropertyType;
    }

    @Override
    public Class getType() {
        return Feature.class;
    }

    @Override
    public Object parse(ElementInstance instance, Node node, Object value) throws Exception {
        return node.getChildValue(Feature.class);
    }

    @Override
    public Object getProperty(Object object, QName name) throws Exception {
        if (GML._Feature.equals(name)) {
            if (object instanceof SimpleFeature) {
                return object;
            }
            if (object instanceof FeatureImpl) {
                ComplexAttribute complex = (ComplexAttribute)object;
                Identifier ident = complex.getIdentifier();
                if (ident == null) {
                    return object;
                }
                String id = ident instanceof FeatureId ? ((FeatureId)ident).getRid() : Converters.convert(ident.getID(), String.class);
                if (this.idSet.idExists(id)) {
                    return null;
                }
                return object;
            }
            if (object instanceof ComplexAttribute) {
                return ((ComplexAttribute)object).getProperties().iterator().next();
            }
        }
        return null;
    }

    @Override
    public Element encode(Object object, Document document, Element value) throws Exception {
        if (object instanceof ComplexAttribute) {
            ComplexAttribute complex = (ComplexAttribute)object;
            this.checkXlinkHref(complex);
            GML3EncodingUtils.encodeClientProperties(complex, value);
            GML3EncodingUtils.encodeSimpleContent(complex, document, value);
        }
        return value;
    }

    private void checkXlinkHref(ComplexAttribute att) {
        Identifier ident = att.getIdentifier();
        if (ident == null) {
            return;
        }
        String id = ident instanceof FeatureId ? ((FeatureId)ident).getRid() : Converters.convert(ident.getID(), String.class);
        if (this.idSet.idExists(id)) {
            Object clientProperties = att.getUserData().get(Attributes.class);
            HashMap<Name, String> map = null;
            if (clientProperties == null) {
                map = new HashMap<Name, String>();
                att.getUserData().put(Attributes.class, map);
            } else {
                map = (HashMap<Name, String>)clientProperties;
            }
            map.put(FeaturePropertyTypeBinding.toTypeName(XLINK.HREF), "#" + id.toString());
            att.setValue(Collections.emptyList());
        }
    }

    private static Name toTypeName(QName name) {
        if ("".equals(name.getNamespaceURI())) {
            return new NameImpl(name.getLocalPart());
        }
        return new NameImpl(name.getNamespaceURI(), name.getLocalPart());
    }
}

