/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.renderer.composite;

import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import org.geotools.renderer.composite.RgbaAccessor;

class IntegerBgrAccessor
implements RgbaAccessor {
    Raster raster;
    int[] pixels;
    boolean hasAlpha;

    public IntegerBgrAccessor(Raster raster, boolean hasAlpha) {
        this.raster = raster;
        this.pixels = new int[raster.getWidth()];
        this.hasAlpha = hasAlpha;
    }

    @Override
    public void readRow(int y) {
        this.raster.getDataElements(0, y, this.raster.getWidth(), 1, this.pixels);
    }

    @Override
    public void getColor(int x, int[] rgba) {
        int pixel = this.pixels[x];
        rgba[0] = pixel & 0xFF;
        rgba[1] = pixel >> 8 & 0xFF;
        rgba[2] = pixel >> 16 & 0xFF;
        rgba[3] = this.hasAlpha ? pixel >> 24 & 0xFF : 255;
    }

    @Override
    public void setColor(int x, int r, int g, int b, int a) {
        int pixel;
        if (!this.hasAlpha) {
            a = 255;
        }
        this.pixels[x] = pixel = a << 24 | r << 16 | g << 8 | b & 0xFF;
    }

    @Override
    public void writeRow(int y, WritableRaster destination) {
        destination.setDataElements(0, y, this.raster.getWidth(), 1, this.pixels);
    }
}

