/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.sld.bindings;

import javax.xml.namespace.QName;
import org.geotools.sld.bindings.SLD;
import org.geotools.styling.Fill;
import org.geotools.styling.Mark;
import org.geotools.styling.Stroke;
import org.geotools.styling.StyleFactory;
import org.geotools.xml.AbstractComplexBinding;
import org.geotools.xml.ElementInstance;
import org.geotools.xml.Node;
import org.opengis.filter.FilterFactory;
import org.picocontainer.MutablePicoContainer;

public class SLDMarkBinding
extends AbstractComplexBinding {
    protected FilterFactory filterFactory;
    protected StyleFactory styleFactory;

    public SLDMarkBinding(StyleFactory styleFactory, FilterFactory filterFactory) {
        this.styleFactory = styleFactory;
        this.filterFactory = filterFactory;
    }

    @Override
    public QName getTarget() {
        return SLD.MARK;
    }

    @Override
    public int getExecutionMode() {
        return 0;
    }

    @Override
    public Class getType() {
        return Mark.class;
    }

    @Override
    public void initialize(ElementInstance instance, Node node, MutablePicoContainer context) {
    }

    @Override
    public Object parse(ElementInstance instance, Node node, Object value) throws Exception {
        String wkName = (String)node.getChildValue("WellKnownName");
        Stroke stroke = (Stroke)node.getChildValue("Stroke");
        Fill fill = (Fill)node.getChildValue("Fill");
        Mark mark = this.styleFactory.createMark();
        if (wkName != null) {
            mark.setWellKnownName(this.filterFactory.literal(wkName));
        }
        mark.setStroke(stroke);
        mark.setFill(fill);
        return mark;
    }
}

