/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.swing.control;

import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

class IntegerDocument
extends PlainDocument {
    private int value;
    private boolean allowNegative;

    public IntegerDocument() {
        this(true);
    }

    public IntegerDocument(boolean allowNegative) {
        this.allowNegative = allowNegative;
    }

    public int getValue() {
        return this.value;
    }

    public boolean getAllowsNegative() {
        return this.allowNegative;
    }

    @Override
    public void insertString(int offset, String text, AttributeSet attributes) throws BadLocationException {
        if (text != null) {
            String newText;
            if (this.getLength() == 0) {
                newText = text;
            } else {
                StringBuilder sb = new StringBuilder(this.getText(0, this.getLength()));
                sb.insert(offset, text);
                newText = sb.toString();
            }
            this.value = this.allowNegative && offset == 0 && newText.equals("-") ? 0 : this.checkInput(newText, offset);
            super.insertString(offset, text, attributes);
        }
    }

    @Override
    public void remove(int offset, int length) throws BadLocationException {
        int curLen = this.getLength();
        String currentContent = this.getText(0, curLen);
        String newText = currentContent.substring(0, offset) + currentContent.substring(length + offset, curLen);
        this.value = this.allowNegative && offset == 0 && newText.equals("-") ? 0 : this.checkInput(newText, offset);
        super.remove(offset, length);
    }

    public int checkInput(String proposedText, int offset) throws BadLocationException {
        int newValue = 0;
        if (proposedText != null && proposedText.length() > 0) {
            try {
                newValue = Integer.parseInt(proposedText);
            }
            catch (NumberFormatException ex) {
                throw new BadLocationException(proposedText, offset);
            }
        }
        return newValue;
    }
}

