/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.wfs;

import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.geotools.feature.NameImpl;
import org.geotools.feature.type.FeatureTypeFactoryImpl;
import org.geotools.gml3.v3_2.GML;
import org.geotools.xs.XS;
import org.opengis.feature.Attribute;
import org.opengis.feature.Feature;
import org.opengis.feature.FeatureFactory;
import org.opengis.feature.Property;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.AttributeType;
import org.opengis.feature.type.FeatureTypeFactory;
import org.opengis.feature.type.Schema;
import org.opengis.filter.expression.PropertyName;

public class PropertyValueCollection
extends AbstractCollection<Attribute> {
    static FeatureTypeFactory typeFactory = new FeatureTypeFactoryImpl();
    static FeatureFactory factory = CommonFactoryFinder.getFeatureFactory(null);
    FeatureCollection delegate;
    AttributeDescriptor descriptor;
    List<Schema> typeMappingProfiles = new ArrayList<Schema>();
    PropertyName propertyName;

    public PropertyValueCollection(FeatureCollection delegate, AttributeDescriptor descriptor, PropertyName propName) {
        this.delegate = delegate;
        this.descriptor = descriptor;
        this.typeMappingProfiles.add(XS.getInstance().getTypeMappingProfile());
        this.typeMappingProfiles.add(GML.getInstance().getTypeMappingProfile());
        this.propertyName = propName;
    }

    @Override
    public int size() {
        return this.delegate.size();
    }

    @Override
    public Iterator iterator() {
        return new PropertyValueIterator(this.delegate.features());
    }

    class PropertyValueIterator
    implements Iterator {
        FeatureIterator it;
        Feature next;
        Queue values = new LinkedList();

        PropertyValueIterator(FeatureIterator it) {
            this.it = it;
        }

        @Override
        public boolean hasNext() {
            if (this.it == null) {
                return false;
            }
            if (this.values.isEmpty()) {
                Object value = null;
                while (this.it.hasNext()) {
                    Object f = this.it.next();
                    value = PropertyValueCollection.this.propertyName.evaluate(f);
                    if (value == null || value instanceof Collection && ((Collection)value).isEmpty()) continue;
                    this.next = f;
                    break;
                }
                if (value != null) {
                    if (value instanceof Collection) {
                        this.values.addAll((Collection)value);
                    } else {
                        this.values.add(value);
                    }
                }
            }
            if (!this.values.isEmpty()) {
                return true;
            }
            this.it.close();
            this.it = null;
            return false;
        }

        public Object next() {
            Object value = this.values.remove();
            AttributeType xmlType = this.findType(PropertyValueCollection.this.descriptor.getType().getBinding());
            if (xmlType == null) {
                throw new RuntimeException("Unable to map attribute " + PropertyValueCollection.this.descriptor.getName() + " to xml type");
            }
            NameImpl name = new NameImpl(this.next.getType().getName().getNamespaceURI(), PropertyValueCollection.this.descriptor.getLocalName());
            AttributeDescriptor newDescriptor = typeFactory.createAttributeDescriptor(xmlType, name, PropertyValueCollection.this.descriptor.getMinOccurs(), PropertyValueCollection.this.descriptor.getMaxOccurs(), PropertyValueCollection.this.descriptor.isNillable(), PropertyValueCollection.this.descriptor.getDefaultValue());
            if (this.next instanceof SimpleFeature) {
                return factory.createAttribute(value, newDescriptor, null);
            }
            return factory.createComplexAttribute(Collections.singletonList((Property)value), newDescriptor, null);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        AttributeType findType(Class binding) {
            for (Schema schema : PropertyValueCollection.this.typeMappingProfiles) {
                for (Map.Entry e : schema.entrySet()) {
                    AttributeType at = (AttributeType)e.getValue();
                    if (at.getBinding() == null || !at.getBinding().equals(binding)) continue;
                    return at;
                }
                for (AttributeType at : schema.values()) {
                    if (!binding.isAssignableFrom(at.getBinding())) continue;
                    return at;
                }
            }
            return null;
        }
    }
}

