/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.wfs.v2_0.bindings;

import com.vividsolutions.jts.geom.Geometry;
import javax.xml.namespace.QName;
import net.opengis.wfs20.PropertyType;
import net.opengis.wfs20.Wfs20Factory;
import org.geotools.gml2.GML;
import org.geotools.gml2.GMLConfiguration;
import org.geotools.wfs.v2_0.WFS;
import org.geotools.xml.AbstractComplexEMFBinding;
import org.geotools.xml.ElementInstance;
import org.geotools.xml.Encoder;
import org.geotools.xml.EncoderDelegate;
import org.geotools.xml.Node;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.ContentHandler;
import org.xml.sax.helpers.AttributesImpl;

public class PropertyTypeBinding
extends AbstractComplexEMFBinding {
    public PropertyTypeBinding(Wfs20Factory factory) {
        super(factory);
    }

    @Override
    public QName getTarget() {
        return WFS.PropertyType;
    }

    @Override
    public Class<?> getType() {
        return PropertyType.class;
    }

    @Override
    public Element encode(Object object, Document document, Element value) throws Exception {
        return value;
    }

    @Override
    public Object parse(ElementInstance instance, Node node, Object value) throws Exception {
        return super.parse(instance, node, value);
    }

    @Override
    public Object getProperty(final Object object, QName name) throws Exception {
        if (WFS.Value.equals(name)) {
            return new EncoderDelegate(){

                @Override
                public void encode(ContentHandler output) throws Exception {
                    Object value = ((PropertyType)object).getValue();
                    output.startElement("http://www.opengis.net/wfs/2.0", WFS.Value.getLocalPart(), "wfs:" + WFS.Value.getLocalPart(), new AttributesImpl());
                    if (value instanceof Geometry) {
                        Encoder encoder = new Encoder(new GMLConfiguration());
                        encoder.setInline(true);
                        encoder.encode(value, GML._Geometry, output);
                    } else {
                        String s = value.toString();
                        output.characters(s.toCharArray(), 0, s.length());
                    }
                    output.endElement("http://www.opengis.net/wfs/2.0", WFS.Value.getLocalPart(), "wfs:" + WFS.Value.getLocalPart());
                }
            };
        }
        return super.getProperty(object, name);
    }
}

