/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.xml.resolver;

import java.math.BigInteger;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.MessageDigest;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Logger;
import org.geotools.util.logging.Logging;
import org.geotools.xml.resolver.SchemaCache;
import org.geotools.xml.resolver.SchemaCatalog;

public class SchemaResolver {
    private static final Logger LOGGER = Logging.getLogger(SchemaResolver.class.getPackage().getName());
    private SchemaCatalog catalog;
    private boolean classpath = true;
    private SchemaCache cache;
    private Map<String, String> resolvedLocationToOriginalLocationMap = new ConcurrentHashMap<String, String>();

    public SchemaResolver(SchemaCatalog catalog, boolean classpath, SchemaCache cache) {
        this.catalog = catalog;
        this.classpath = classpath;
        this.cache = cache;
    }

    public SchemaResolver(SchemaCatalog catalog, SchemaCache cache) {
        this(catalog, true, cache);
    }

    public SchemaResolver() {
        this(null, null);
    }

    public SchemaResolver(SchemaCatalog catalog) {
        this(catalog, null);
    }

    public SchemaResolver(SchemaCache cache) {
        this(null, cache);
    }

    public String resolve(String location, String context) {
        URI locationUri;
        try {
            locationUri = new URI(location);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
        if (!locationUri.isAbsolute()) {
            URI contextUri;
            if (context == null) {
                throw new RuntimeException("Could not determine absolute schema location for " + location + " because context schema location is unknown");
            }
            String originalContext = this.resolvedLocationToOriginalLocationMap.get(context);
            if (originalContext == null) {
                originalContext = context;
            }
            try {
                contextUri = new URI(originalContext);
            }
            catch (URISyntaxException e) {
                throw new RuntimeException(e);
            }
            locationUri = contextUri.resolve(locationUri);
        }
        return this.resolve(locationUri.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String resolve(String location) {
        String resolvedLocation = null;
        if (location.startsWith("file:") || location.startsWith("jar:file:")) {
            resolvedLocation = location;
        }
        if (resolvedLocation == null && this.catalog != null) {
            resolvedLocation = this.catalog.resolveLocation(location);
        }
        if (resolvedLocation == null && this.classpath) {
            resolvedLocation = SchemaResolver.resolveClasspathLocation(location);
        }
        if (resolvedLocation == null && this.cache != null) {
            resolvedLocation = this.cache.resolveLocation(location);
        }
        if (resolvedLocation == null) {
            throw new RuntimeException(String.format("Failed to resolve %s", location));
        }
        SchemaResolver schemaResolver = this;
        synchronized (schemaResolver) {
            if (!this.resolvedLocationToOriginalLocationMap.containsKey(resolvedLocation)) {
                this.resolvedLocationToOriginalLocationMap.put(resolvedLocation, location);
            }
        }
        LOGGER.fine(String.format("Resolved %s -> %s", location, resolvedLocation));
        return resolvedLocation;
    }

    public static String getSimpleHttpResourcePath(String location) {
        return SchemaResolver.getSimpleHttpResourcePath(location, false);
    }

    public static String getSimpleHttpResourcePath(String location, boolean keepQuery) {
        URI locationUri;
        try {
            locationUri = new URI(location);
        }
        catch (URISyntaxException e) {
            return null;
        }
        return SchemaResolver.getSimpleHttpResourcePath(locationUri, keepQuery);
    }

    public static String getSimpleHttpResourcePath(URI location) {
        return SchemaResolver.getSimpleHttpResourcePath(location, false);
    }

    public static String getSimpleHttpResourcePath(URI location, boolean keepQuery) {
        String scheme = location.getScheme();
        if (scheme == null || !scheme.equals("http") && !scheme.equals("https")) {
            return null;
        }
        String host = location.getHost();
        String path = location.getPath();
        String[] hostParts = host.split("\\.");
        StringBuilder builder = new StringBuilder();
        for (int i = hostParts.length - 1; i >= 0; --i) {
            builder.append("/");
            builder.append(hostParts[i]);
        }
        builder.append(path);
        String query = location.getQuery();
        if (keepQuery && query != null) {
            builder.append(".");
            builder.append(SchemaResolver.stringToMD5String(query));
            builder.append(".xsd");
        }
        return builder.toString();
    }

    public static URL getClasspathResourceUrl(String location) {
        String path = SchemaResolver.getSimpleHttpResourcePath(location);
        if (path == null) {
            return null;
        }
        return SchemaResolver.class.getResource(path);
    }

    public static String resolveClasspathLocation(String location) {
        URL url = SchemaResolver.getClasspathResourceUrl(location);
        if (url == null) {
            return null;
        }
        return SchemaResolver.getClasspathResourceUrl(location).toExternalForm();
    }

    private static String stringToMD5String(String message) {
        byte[] bytesOfMessage = null;
        MessageDigest md = null;
        try {
            bytesOfMessage = message.getBytes("UTF-8");
            md = MessageDigest.getInstance("MD5");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return String.format("%032x", new BigInteger(1, md.digest(bytesOfMessage)));
    }
}

