/*
 * Decompiled with CFR 0.152.
 */
package gr.cite.regional.data.collection.addin.authentication.application.controllers;

import gr.cite.regional.data.collection.addin.authentication.application.controllers.BaseController;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.MultivaluedHashMap;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@CrossOrigin
@RequestMapping(value={"/authentications"})
public class AuthenticationController
extends BaseController {
    static final String AUTHENTICATION_ENDPOINT = "authentications";
    private static final Logger logger = LogManager.getLogger(AuthenticationController.class);
    private String redirectUri;
    private String clientId;
    private String clientSecret;
    private WebTarget target;

    @Autowired
    public AuthenticationController(String hostname, String redirectUri, String clientId, String clientSecret) {
        this.redirectUri = redirectUri;
        this.clientId = clientId;
        this.clientSecret = clientSecret;
        this.target = ClientBuilder.newClient().target(hostname);
    }

    @RequestMapping(value={""}, method={RequestMethod.POST}, produces={"application/json"})
    public ResponseEntity<Object> authenticate(@RequestParam(value="code", required=true) String code) {
        MultivaluedHashMap formData = new MultivaluedHashMap();
        formData.add((Object)"grant_type", (Object)"authorization_code");
        formData.add((Object)"code", (Object)code);
        formData.add((Object)"redirect_uri", (Object)this.redirectUri);
        formData.add((Object)"client_id", (Object)this.clientId);
        formData.add((Object)"client_secret", (Object)this.clientSecret);
        Response response = this.target.request().header("gcube-token", (Object)this.clientSecret).post(Entity.form((MultivaluedMap)formData));
        logger.info("Authentication service responded with status: " + response.getStatus() + " - code: [" + code + "]");
        if (response.getStatus() < 200 && response.getStatus() >= 300) {
            logger.info("Error message is: " + (String)response.readEntity(String.class));
        }
        return ResponseEntity.status((int)response.getStatus()).body(response.readEntity(String.class));
    }
}

