/*
 * Decompiled with CFR 0.152.
 */
package gr.cite.regional.data.collection.dataaccess.daos;

import gr.cite.regional.data.collection.dataaccess.daos.Dao;
import gr.cite.regional.data.collection.dataaccess.entities.Entity;
import java.io.Serializable;
import java.lang.reflect.ParameterizedType;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.PersistenceUnitUtil;
import org.springframework.stereotype.Repository;

@Repository
public abstract class JpaDao<T extends Entity, PK extends Serializable>
implements Dao<T, PK> {
    protected Class<T> entityClass;
    @PersistenceContext
    protected EntityManager entityManager;
    protected PersistenceUnitUtil persistenceUnitUtil;

    public JpaDao() {
        ParameterizedType genericSuperclass = (ParameterizedType)this.getClass().getGenericSuperclass();
        this.entityClass = (Class)genericSuperclass.getActualTypeArguments()[0];
    }

    @PostConstruct
    private void initPersistenceUnitUtil() {
        this.persistenceUnitUtil = this.entityManager.getEntityManagerFactory().getPersistenceUnitUtil();
    }

    @Override
    public T create(T t) {
        this.entityManager.persist(t);
        return t;
    }

    @Override
    public T read(PK id) {
        return (T)((Entity)this.entityManager.find(this.entityClass, id));
    }

    @Override
    public T update(T t) {
        return (T)((Entity)this.entityManager.merge(t));
    }

    @Override
    public void delete(T t) {
        t = (Entity)this.entityManager.merge(t);
        this.entityManager.remove(t);
    }

    @Override
    public List<T> getAll() {
        return this.entityManager.createQuery("from " + this.entityClass.getSimpleName(), this.entityClass).getResultList();
    }

    @Override
    public long count() {
        return ((Number)this.entityManager.createQuery("select count(e) from " + this.entityClass.getSimpleName() + " e").getSingleResult()).longValue();
    }

    @Override
    public boolean isLoaded(T t) {
        return this.persistenceUnitUtil.isLoaded(t);
    }

    protected boolean isFieldLoaded(T t, String fieldName) {
        return this.persistenceUnitUtil.isLoaded(t, fieldName);
    }
}

