/*
 * Decompiled with CFR 0.152.
 */
package gr.cite.regional.data.collection.dataaccess.types;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Objects;
import gr.cite.regional.data.collection.dataaccess.types.JsonHelper;
import java.io.IOException;
import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.HibernateException;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.internal.util.ReflectHelper;
import org.hibernate.usertype.ParameterizedType;
import org.hibernate.usertype.UserType;
import org.postgresql.util.PGobject;

public class JsonUserType
implements UserType,
ParameterizedType,
Serializable {
    private static final ObjectMapper MAPPER = new ObjectMapper();
    private static final String CLASS_TYPE = "classType";
    private static final String TYPE = "type";
    private static final int[] SQL_TYPES = new int[]{2000};
    private Class<?> classType;
    private int sqlType = 2000;

    public void setParameterValues(Properties params) {
        String classTypeName = params.getProperty(CLASS_TYPE);
        try {
            this.classType = ReflectHelper.classForName((String)classTypeName, this.getClass());
        }
        catch (ClassNotFoundException cnfe) {
            throw new HibernateException("classType not found", (Throwable)cnfe);
        }
        String type = params.getProperty(TYPE);
        if (type != null) {
            this.sqlType = Integer.decode(type);
        }
    }

    public Object assemble(Serializable cached, Object owner) throws HibernateException {
        return this.deepCopy(cached);
    }

    public Object deepCopy(Object value) throws HibernateException {
        if (value != null) {
            try {
                return MAPPER.readValue(MAPPER.writeValueAsString(value), this.classType);
            }
            catch (IOException e) {
                throw new HibernateException("unable to deep copy object", (Throwable)e);
            }
        }
        return null;
    }

    public Serializable disassemble(Object value) throws HibernateException {
        try {
            return MAPPER.writeValueAsString(value);
        }
        catch (JsonProcessingException e) {
            throw new HibernateException("unable to disassemble object", (Throwable)e);
        }
    }

    public boolean equals(Object x, Object y) throws HibernateException {
        return Objects.equal((Object)x, (Object)y);
    }

    public int hashCode(Object x) throws HibernateException {
        return Objects.hashCode((Object[])new Object[]{x});
    }

    public boolean isMutable() {
        return true;
    }

    public Object nullSafeGet(ResultSet rs, String[] names, SharedSessionContractImplementor session, Object owner) throws HibernateException, SQLException {
        String json = rs.getString(names[0]);
        if (json != null && !rs.wasNull() && StringUtils.isNotBlank((CharSequence)json)) {
            return JsonHelper.fromJson(json, this.classType);
        }
        return null;
    }

    public void nullSafeSet(PreparedStatement st, Object value, int index, SharedSessionContractImplementor session) throws HibernateException, SQLException {
        if (value == null) {
            st.setNull(index, 0);
        } else if (this.classType.isInstance(value)) {
            String json = JsonHelper.toJson(value);
            PGobject pGobject = new PGobject();
            pGobject.setType("json");
            pGobject.setValue(json);
            st.setObject(index, (Object)pGobject, 1111);
        }
    }

    public Object replace(Object original, Object target, Object owner) throws HibernateException {
        return this.deepCopy(original);
    }

    public Class<?> returnedClass() {
        return this.classType;
    }

    public int[] sqlTypes() {
        return SQL_TYPES;
    }
}

