/*
 * Decompiled with CFR 0.152.
 */
package gr.cite.regional.data.collection.dataaccess.types;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(JsonHelper.class);
    private static final ObjectMapper MAPPER = new ObjectMapper();

    private JsonHelper() {
    }

    public static String toJson(Object object) {
        try {
            return MAPPER.writeValueAsString(object);
        }
        catch (JsonProcessingException e) {
            LOGGER.error("toJson: could not convert object to json string", (Throwable)e);
            return null;
        }
    }

    public static <T> T fromJson(String jsonString, Class<T> clazz) {
        try {
            return (T)MAPPER.readValue(jsonString, clazz);
        }
        catch (IOException e) {
            LOGGER.error("fromJson: could not convert json string to object", (Throwable)e);
            return null;
        }
    }

    static {
        MAPPER.setVisibility(PropertyAccessor.ALL, JsonAutoDetect.Visibility.NONE);
        MAPPER.setVisibility(PropertyAccessor.FIELD, JsonAutoDetect.Visibility.ANY);
    }
}

