/*
 * Decompiled with CFR 0.152.
 */
package gr.cite.regional.data.collection.application.controllers;

import com.fasterxml.jackson.databind.ObjectMapper;
import gr.cite.regional.data.collection.dataccess.exceptions.ServiceException;
import java.util.NoSuchElementException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.ExceptionHandler;

@Component
public class BaseController {
    private static final Logger logger = LogManager.getLogger(BaseController.class);
    static final ObjectMapper objectMapper = new ObjectMapper();

    @ExceptionHandler(value={ServiceException.class})
    public final ResponseEntity<String> handleServiceLayerException(ServiceException e) {
        logger.error(e.getMessage(), (Throwable)e);
        return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)e.getMessage());
    }

    @ExceptionHandler(value={NoSuchElementException.class})
    public final ResponseEntity<String> handleNoSuchElementException(NoSuchElementException e) {
        logger.info(e.getMessage(), (Throwable)e);
        return ResponseEntity.status((HttpStatus)HttpStatus.NOT_FOUND).body((Object)e.getMessage());
    }

    @ExceptionHandler(value={IllegalArgumentException.class})
    public final ResponseEntity<String> handleIllegalArgumentException(IllegalArgumentException e) {
        logger.error(e.getMessage(), (Throwable)e);
        return ResponseEntity.status((HttpStatus)HttpStatus.BAD_REQUEST).body((Object)e.getMessage());
    }

    @ExceptionHandler(value={Exception.class})
    public final ResponseEntity<String> handleGenericException(Exception e) {
        logger.error(e.getMessage(), (Throwable)e);
        return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)e.getMessage());
    }
}

