/*
 * Decompiled with CFR 0.152.
 */
package gr.cite.regional.data.collection.application.controllers;

import gr.cite.regional.data.collection.application.controllers.BaseController;
import gr.cite.regional.data.collection.application.core.EntityDtoMapper;
import gr.cite.regional.data.collection.application.dtos.DataModelDto;
import gr.cite.regional.data.collection.application.dtos.Dto;
import gr.cite.regional.data.collection.application.dtos.FieldDetails;
import gr.cite.regional.data.collection.dataaccess.constraints.ConstraintDefinition;
import gr.cite.regional.data.collection.dataaccess.constraints.ConstraintsWrapper;
import gr.cite.regional.data.collection.dataaccess.dsd.DataModelDefinition;
import gr.cite.regional.data.collection.dataaccess.dsd.DsdField;
import gr.cite.regional.data.collection.dataaccess.dsd.DsdProcessing;
import gr.cite.regional.data.collection.dataaccess.dsd.DsdTemplate;
import gr.cite.regional.data.collection.dataaccess.dsd.Field;
import gr.cite.regional.data.collection.dataaccess.entities.Constraint;
import gr.cite.regional.data.collection.dataaccess.entities.DataModel;
import gr.cite.regional.data.collection.dataaccess.entities.Entity;
import gr.cite.regional.data.collection.dataaccess.entities.Properties;
import gr.cite.regional.data.collection.dataaccess.services.ConstraintsService;
import gr.cite.regional.data.collection.dataaccess.services.DataModelService;
import gr.cite.regional.data.collection.dataccess.exceptions.ServiceException;
import java.io.IOException;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.util.UriComponentsBuilder;

@Controller
@CrossOrigin
@RequestMapping(value={"/dataModels"})
public class DataModelController
extends BaseController {
    private static final Logger logger = LogManager.getLogger(DataModelController.class);
    static final String DATA_MODEL_ENDPOINT = "dataModels";
    private String hostname;
    private EntityDtoMapper entityDtoMapper;
    private DataModelService dataModelService;
    private ConstraintsService constraintsService;
    private DsdProcessing dsdProcessing;

    @Autowired
    public DataModelController(DataModelService dataModelService, DsdProcessing dsdProcessing, String hostname, EntityDtoMapper entityDtoMapper, ConstraintsService constraintsService) {
        this.dataModelService = dataModelService;
        this.dsdProcessing = dsdProcessing;
        this.hostname = hostname;
        this.entityDtoMapper = entityDtoMapper;
        this.constraintsService = constraintsService;
    }

    @RequestMapping(value={""}, method={RequestMethod.POST}, consumes={"application/json"}, produces={"application/json"})
    public ResponseEntity<String> addDataModel(@RequestBody DataModelDto dataModelDto) throws ServiceException {
        DataModel insertedDataModel = this.dataModelService.addDataModel((DataModel)this.entityDtoMapper.dtoToEntity((Dto)dataModelDto, DataModel.class));
        List constraintsDefinitions = new ArrayList();
        try {
            constraintsDefinitions = this.dsdProcessing.extractInherentConstraints(insertedDataModel.getDefinition());
        }
        catch (Exception e) {
            logger.warn(e.getMessage(), (Throwable)e);
        }
        List constraints = constraintsDefinitions.stream().map(constraintDefinition -> {
            Constraint constraint = new Constraint();
            constraint.setConstraintType(constraintDefinition.getConstraintType());
            constraint.setConstraint(constraintDefinition);
            constraint.setDataModel(insertedDataModel);
            return constraint;
        }).collect(Collectors.toList());
        if (!constraints.isEmpty()) {
            this.constraintsService.addConstraints(constraints);
        }
        return ResponseEntity.ok((Object)("Data Model " + insertedDataModel.getLabel() + " [" + insertedDataModel.getId() + "] successfully created"));
    }

    @RequestMapping(value={"/{id}"}, method={RequestMethod.POST}, consumes={"application/json"}, produces={"application/json"})
    public ResponseEntity<DataModelDto> updateDataModel(@PathVariable(value="id") Integer id, @RequestBody DataModelDto dataModelDto) {
        dataModelDto.setId(id);
        DataModel dataModel = (DataModel)this.entityDtoMapper.dtoToEntity((Dto)dataModelDto, DataModel.class);
        dataModel = this.dataModelService.updateDataModel(dataModel);
        return ResponseEntity.ok((Object)this.entityDtoMapper.entityToDto((Entity)dataModel, DataModelDto.class));
    }

    @RequestMapping(value={"/{id}/properties"}, method={RequestMethod.GET}, produces={"application/json"})
    public ResponseEntity<Properties> getDataModelProperties(@PathVariable(value="id") Integer dataModelId) {
        DataModel dataModel = this.dataModelService.getDataModel(dataModelId);
        return ResponseEntity.ok((Object)dataModel.getProperties());
    }

    @RequestMapping(value={"/{id}"}, method={RequestMethod.DELETE}, consumes={"application/json"})
    public ResponseEntity deleteDataModel(@PathVariable(value="id") Integer id) throws ServiceException {
        logger.debug("Delete data model");
        this.dataModelService.deleteDataModel(id);
        return ResponseEntity.noContent().build();
    }

    @RequestMapping(method={RequestMethod.GET}, produces={"application/json"})
    public ResponseEntity<List<DataModelDto>> getAllDataModels(HttpServletRequest request) throws ServiceException {
        logger.debug("Get all data models");
        String scope = request.getHeader("gcube-user-scope");
        List dataModels = this.dataModelService.getAllDataModels();
        List dataModelDtos = dataModels.stream().filter(dm -> dm.getDomain().getLabel().equals(scope)).map(dm -> {
            DataModelDto dmDto = (DataModelDto)this.entityDtoMapper.entityToDto((Entity)dm, DataModelDto.class);
            try {
                dmDto.setActiveDataCollectionPeriod(this.dataModelService.isDataCollectionPeriodActiveByDataModelId(dm.getId()));
            }
            catch (ServiceException e) {
                logger.debug("Something went wrong while retrieving data models");
            }
            return dmDto;
        }).collect(Collectors.toList());
        return ResponseEntity.ok(dataModelDtos);
    }

    @RequestMapping(value={"/{id}"}, method={RequestMethod.GET}, produces={"application/json"})
    public ResponseEntity<DataModelDto> getDataModel(@PathVariable(value="id") Integer id) {
        logger.debug("Get data model by id: " + id);
        DataModel dataModel = this.dataModelService.getDataModel(id);
        return ResponseEntity.ok((Object)this.entityDtoMapper.entityToDto((Entity)dataModel, DataModelDto.class));
    }

    @RequestMapping(value={"/{id}/definition"}, method={RequestMethod.GET}, produces={"application/json"})
    public ResponseEntity<DsdTemplate> getDataModelDefinition(@PathVariable(value="id") Integer id) {
        logger.debug("Get data model definition by id: " + id);
        DataModel dataModel = this.dataModelService.getDataModel(id);
        DsdTemplate dsdTemplate = this.dsdProcessing.getDefinition(dataModel.getDefinition());
        return ResponseEntity.ok((Object)dsdTemplate);
    }

    @RequestMapping(value={"/{id}/definition/excel"}, method={RequestMethod.GET}, produces={"application/json"})
    public ResponseEntity<DataModelDefinition> getDataModelDefinitionForExcel(@PathVariable(value="id") Integer id) throws ServiceException {
        logger.debug("Get data model definition by id: " + id);
        DataModel dataModel = this.dataModelService.getDataModel(id);
        DataModelDefinition definition = this.dsdProcessing.getDefinitionForExcelAddIn(dataModel.getDefinition());
        definition.getFields().forEach(field -> {
            if (dataModel.getProperties() != null && dataModel.getProperties().getStaticFields().contains(field.getLabel())) {
                field.setStaticField(true);
            }
        });
        HashMap constraints = new HashMap();
        this.constraintsService.getConstraintsByDataModelId(id).stream().map(Constraint::getConstraint).forEach(constraintDefinition -> {
            if (constraintDefinition.getConstraintType().startsWith("attribute")) {
                constraints.computeIfAbsent("attribute", k -> new ArrayList());
                ((List)constraints.get("attribute")).add(constraintDefinition);
            } else if (constraintDefinition.getConstraintType().startsWith("entity")) {
                constraints.computeIfAbsent("entity", k -> new ArrayList());
                ((List)constraints.get("entity")).add(constraintDefinition);
            }
        });
        definition.setConstraints(constraints);
        return ResponseEntity.ok((Object)definition);
    }

    @RequestMapping(value={"/{id}/definition/{fieldId}"}, method={RequestMethod.GET}, produces={"application/json"})
    public ResponseEntity<FieldDetails> getDataModelDefinitionForAdmin(@PathVariable(value="id") Integer id, @PathVariable(value="fieldId") String fieldId) throws ServiceException {
        DataModel dataModel = this.dataModelService.getDataModel(id);
        DataModelDefinition definition = this.dsdProcessing.getDefinitionForExcelAddIn(dataModel.getDefinition());
        Field field = definition.getFields().stream().filter(f -> f.getId().equals(fieldId)).findFirst().orElseThrow(() -> new NoSuchElementException("No field with id [" + fieldId + "] in definition"));
        FieldDetails fieldDetails = new FieldDetails();
        fieldDetails.setCodelistId(field.getCodelist().getId());
        fieldDetails.setCodelistLabel(field.getCodelist().getLabel());
        fieldDetails.setFields(field.getCodelist().getFields());
        return ResponseEntity.ok((Object)fieldDetails);
    }

    @RequestMapping(value={"/{id}/definition/fields"}, method={RequestMethod.GET}, produces={"application/json"})
    public ResponseEntity<List<DsdField>> getDataModelDefinitionFields(@PathVariable(value="id") Integer id) {
        logger.debug("Get data model fields by id: " + id);
        DataModel dataModel = this.dataModelService.getDataModel(id);
        List fields = this.dsdProcessing.getFields(dataModel.getDefinition());
        return ResponseEntity.ok((Object)fields);
    }

    @RequestMapping(value={"/{id}/constraints"}, method={RequestMethod.POST}, consumes={"application/json"}, produces={"application/json"})
    public ResponseEntity<String> addConstraint(@PathVariable(value="id") Integer id, @RequestBody ConstraintDefinition constraintDefinition) throws ServiceException, IOException {
        logger.debug("Add new constraintDefinition");
        Constraint constraintEntity = new Constraint();
        constraintEntity.setConstraint(constraintDefinition);
        constraintEntity.setConstraintType(constraintDefinition.getConstraintType());
        DataModel dm = new DataModel();
        dm.setId(id);
        constraintEntity.setDataModel(dm);
        constraintEntity = this.constraintsService.addConstraint(constraintEntity);
        URI location = UriComponentsBuilder.fromHttpUrl((String)this.hostname).pathSegment(new String[]{DATA_MODEL_ENDPOINT, "{id}", "constraints", "{constraintId}"}).buildAndExpand(new Object[]{id, constraintEntity.getId()}).toUri();
        return ResponseEntity.created((URI)location).body((Object)("Constraint of type " + constraintEntity.getConstraintType() + " [" + constraintEntity.getId() + "] successfully created"));
    }

    @RequestMapping(value={"/{id}/constraints"}, method={RequestMethod.GET}, produces={"application/json"})
    public ResponseEntity<ConstraintsWrapper> getAllConstraintsOfDataModel(@PathVariable(value="id") Integer id) throws ServiceException, IOException {
        logger.debug("Getting all constraints of dataModel");
        List constraints = this.constraintsService.getConstraintsByDataModelId(id).stream().map(constraintEntity -> {
            ConstraintDefinition constraintDefinition = (ConstraintDefinition)objectMapper.convertValue((Object)constraintEntity.getConstraint(), ConstraintDefinition.class);
            constraintDefinition.setId(constraintEntity.getId());
            return constraintDefinition;
        }).collect(Collectors.toList());
        boolean activeDataCollectionPeriod = this.dataModelService.isDataCollectionPeriodActiveByDataModelId(id);
        return ResponseEntity.ok((Object)new ConstraintsWrapper(activeDataCollectionPeriod, constraints));
    }

    @RequestMapping(value={"/{id}/constraints/{constraintId}"}, method={RequestMethod.DELETE}, produces={"application/json"})
    public ResponseEntity deleteConstraint(@PathVariable(value="id") Integer dataModelId, @PathVariable(value="constraintId") int constraintId) throws ServiceException, IOException {
        logger.debug("Delete constraint of dataModel");
        this.constraintsService.deleteConstraint(Integer.valueOf(constraintId));
        return ResponseEntity.noContent().build();
    }

    @RequestMapping(value={"/{id}/constraints/{constraintId}"}, method={RequestMethod.POST}, consumes={"application/json"}, produces={"application/json"})
    public ResponseEntity<String> updateConstraint(@PathVariable(value="id") Integer id, @PathVariable(value="constraintId") Integer constraintId, @RequestBody ConstraintDefinition constraintDefinition) throws ServiceException, IOException {
        logger.debug("Update a constraint");
        Constraint constraintEntity = new Constraint();
        constraintEntity.setId(constraintId);
        constraintEntity.setConstraintType(constraintDefinition.getConstraintType());
        constraintEntity.setConstraint(constraintDefinition);
        DataModel dm = new DataModel();
        dm.setId(id);
        constraintEntity.setDataModel(dm);
        constraintEntity = this.constraintsService.updateConstraint(constraintEntity);
        return ResponseEntity.ok((Object)("Constraint [" + constraintEntity.getId() + "] successfully updated"));
    }

    @RequestMapping(value={"/test"}, method={RequestMethod.GET}, produces={"application/json"})
    public ResponseEntity test() {
        String dsdXml = null;
        try {
            dsdXml = Files.readAllLines(Paths.get("/home/kapostolopoulos/Desktop/fao/DSD/Structures.xml", new String[0])).stream().collect(Collectors.joining(""));
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        List constraints = this.dsdProcessing.extractInherentConstraints(dsdXml);
        return ResponseEntity.ok((Object)constraints);
    }
}

