/*
 * Decompiled with CFR 0.152.
 */
package gr.cite.regional.data.collection.application.controllers;

import gr.cite.regional.data.collection.application.controllers.BaseController;
import gr.cite.regional.data.collection.application.core.EntityDtoMapper;
import gr.cite.regional.data.collection.application.dtos.AttributesDto;
import gr.cite.regional.data.collection.application.dtos.CdtDto;
import gr.cite.regional.data.collection.application.dtos.DataSubmissionDataDto;
import gr.cite.regional.data.collection.application.dtos.DataSubmissionDto;
import gr.cite.regional.data.collection.application.dtos.Dto;
import gr.cite.regional.data.collection.application.dtos.TabmanDto;
import gr.cite.regional.data.collection.application.dtos.TabmanInfoDto;
import gr.cite.regional.data.collection.application.tabman.TabmanManager;
import gr.cite.regional.data.collection.dataaccess.dsd.DsdProcessing;
import gr.cite.regional.data.collection.dataaccess.dsd.Field;
import gr.cite.regional.data.collection.dataaccess.entities.Cdt;
import gr.cite.regional.data.collection.dataaccess.entities.DataSubmission;
import gr.cite.regional.data.collection.dataaccess.entities.Entity;
import gr.cite.regional.data.collection.dataaccess.services.DataSubmissionService;
import gr.cite.regional.data.collection.dataaccess.types.DataSubmissionStatusType;
import gr.cite.regional.data.collection.dataccess.exceptions.ServiceException;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.time.Instant;
import java.util.Base64;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.bind.JAXBException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.gcube.data.analysis.tabulardata.commons.webservice.exception.NoSuchOperationException;
import org.gcube.data.analysis.tabulardata.commons.webservice.exception.NoSuchTabularResourceException;
import org.gcube.data.analysis.tabulardata.commons.webservice.exception.NoSuchTaskException;
import org.gcube.data.analysis.tabulardata.commons.webservice.types.TaskStatus;
import org.gcube.data.analysis.tabulardata.service.operation.Task;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
@CrossOrigin
@RequestMapping(value={"/dataSubmissions"})
public class DataSubmissionController
extends BaseController {
    static final String DATA_SUBMISSION_ENDPOINT = "dataSubmissions";
    private static final String DATA_SUBMISSION_AS_CSV_FILE_ENDPOINT = "{id}/data/file";
    private static final Logger logger = LogManager.getLogger(DataSubmissionController.class);
    private String hostname;
    private EntityDtoMapper entityDtoMapper;
    private DsdProcessing dsdProcessing;
    private DataSubmissionService dataSubmissionService;

    @Autowired
    public DataSubmissionController(DataSubmissionService dataSubmissionService, DsdProcessing dsdProcessing, String hostname, EntityDtoMapper entityDtoMapper) {
        this.hostname = hostname;
        this.entityDtoMapper = entityDtoMapper;
        this.dataSubmissionService = dataSubmissionService;
        this.dsdProcessing = dsdProcessing;
    }

    @RequestMapping(value={""}, method={RequestMethod.POST}, consumes={"application/json"}, produces={"application/json"})
    public ResponseEntity<DataSubmissionDto> addDataSubmission(@RequestBody DataSubmissionDto dataSubmissionDto) throws ServiceException {
        DataSubmission dataSubmissionEntity = (DataSubmission)this.entityDtoMapper.dtoToEntity((Dto)dataSubmissionDto, DataSubmission.class);
        dataSubmissionEntity = this.dataSubmissionService.addDataSubmission(dataSubmissionEntity);
        DataSubmissionDto newDataSubmission = new DataSubmissionDto();
        newDataSubmission.setId(dataSubmissionEntity.getId());
        return ResponseEntity.ok((Object)newDataSubmission);
    }

    @RequestMapping(value={"/{id}"}, method={RequestMethod.POST}, produces={"text/plain"})
    public ResponseEntity<String> updateDataSubmission(@PathVariable(value="id") Integer id, @RequestBody DataSubmissionDto dataSubmissionDto) throws ServiceException {
        dataSubmissionDto.setId(id);
        DataSubmission dataSubmissionEntity = (DataSubmission)this.entityDtoMapper.dtoToEntity((Dto)dataSubmissionDto, DataSubmission.class);
        dataSubmissionEntity = this.dataSubmissionService.updateDataSubmissionAndData(dataSubmissionEntity);
        return ResponseEntity.ok((Object)("Data Submission [" + dataSubmissionEntity.getId() + "] successfully replaced"));
    }

    @RequestMapping(value={"/{id}"}, method={RequestMethod.GET}, produces={"application/json"})
    public ResponseEntity<DataSubmissionDto> getDataSubmission(@PathVariable(value="id") Integer id) throws ServiceException {
        DataSubmission dataSubmission = this.dataSubmissionService.getDataSubmission(id);
        return ResponseEntity.ok((Object)this.entityDtoMapper.entityToDto((Entity)dataSubmission, DataSubmissionDto.class));
    }

    @RequestMapping(value={""}, method={RequestMethod.GET}, produces={"application/json"})
    public ResponseEntity<List<DataSubmissionDto>> getDataSubmissions(@RequestParam(name="dataCollection", required=false) Integer dataCollectionId, @RequestParam(name="owner", required=false) Integer ownerId) throws ServiceException {
        List dataSubmissions = dataCollectionId == null ? this.dataSubmissionService.getAllDataSubmissions() : (ownerId == null ? this.dataSubmissionService.getDataSubmissionsByDataCollectionId(dataCollectionId) : this.dataSubmissionService.getDataSubmissionsByDataCollectionAndOwner(dataCollectionId, ownerId));
        dataSubmissions.forEach(dataSubmission -> dataSubmission.getDataCollection().setDataModel(null));
        return ResponseEntity.ok((Object)this.entityDtoMapper.entitiesToDtos((Collection)dataSubmissions, DataSubmissionDto.class));
    }

    @RequestMapping(value={"/{id}/data"}, method={RequestMethod.GET}, produces={"application/json"})
    public ResponseEntity<DataSubmissionDataDto> getDataSubmissionData(@PathVariable(value="id") Integer id) throws ServiceException {
        DataSubmission dataSubmission = this.dataSubmissionService.getDataSubmission(id);
        List headers = this.getFieldNamesInOrder(dataSubmission.getDataCollection().getDataModel().getDefinition());
        DataSubmissionDataDto dataSubmissionData = new DataSubmissionDataDto();
        dataSubmissionData.setHeaders(headers);
        dataSubmissionData.setData(this.entityDtoMapper.entitiesToDtos((Collection)dataSubmission.getData(), CdtDto.class));
        return ResponseEntity.ok((Object)dataSubmissionData);
    }

    @RequestMapping(value={"/{id}/data"}, method={RequestMethod.GET}, produces={"text/csv"})
    public ResponseEntity<String> getDataSubmissionAsCsv(@PathVariable(value="id") Integer id) throws ServiceException {
        DataSubmission dataSubmission = this.dataSubmissionService.getDataSubmission(id);
        List fieldNames = this.getFieldNamesInOrder(dataSubmission.getDataCollection().getDataModel().getDefinition());
        String csv = this.constructDataSubmissionCsv(fieldNames, dataSubmission.getData());
        return ResponseEntity.ok((Object)csv);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/{id}/data/file"}, method={RequestMethod.GET}, produces={"text/csv"})
    public void getFileOfDataSubmissions(@PathVariable(value="id") Integer id, HttpServletRequest request, HttpServletResponse response) throws ServiceException {
        DataSubmission dataSubmission = this.dataSubmissionService.getDataSubmission(id);
        if (dataSubmission.getStatus().intValue() != DataSubmissionStatusType.VALIDATED.code()) {
            throw new ServiceException("Non validated file");
        }
        List fieldNames = this.getFieldNamesInOrder(dataSubmission.getDataCollection().getDataModel().getDefinition());
        String csv = this.constructDataSubmissionCsv(fieldNames, dataSubmission.getData());
        File file = new File("DataSubmission" + dataSubmission.getId().toString() + ".csv");
        FileWriter fileWriter = null;
        try {
            fileWriter = new FileWriter(file);
            fileWriter.write(csv);
            fileWriter.flush();
            fileWriter.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new ServiceException("An error occurred while creating the csv file");
        }
        response.setContentType("text/csv");
        response.setContentLength((int)file.length());
        response.setHeader("Content-Disposition", "attachment; filename=\"" + file.getName() + "\"");
        BufferedInputStream input = null;
        FilterOutputStream output = null;
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(file);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            throw new ServiceException("An error occurred while creating the stream for the csv file");
        }
        try {
            int length;
            input = new BufferedInputStream(fis);
            output = new BufferedOutputStream((OutputStream)response.getOutputStream());
            byte[] buffer = new byte[0x100000];
            while ((length = input.read(buffer)) > 0) {
                ((BufferedOutputStream)output).write(buffer, 0, length);
            }
        }
        catch (IOException e) {
            logger.error("There are errors in reading/writing the stream " + e.getMessage());
        }
        finally {
            if (output != null) {
                try {
                    output.close();
                }
                catch (IOException ignore) {
                    ignore.printStackTrace();
                }
            }
            if (input != null) {
                try {
                    input.close();
                }
                catch (IOException ignore) {
                    ignore.printStackTrace();
                }
            }
        }
    }

    @RequestMapping(value={"/{id}/tabman/import"}, method={RequestMethod.POST}, produces={"application/json"})
    public ResponseEntity importToTabman(@PathVariable(value="id") Integer id, @RequestBody TabmanDto tabmanDto, HttpServletRequest request) throws ServiceException {
        Task task;
        logger.debug("Importing dataCollection " + id + " to tabman");
        String scope = request.getHeader("scope");
        logger.debug("Scope: " + scope);
        String token = request.getHeader("token");
        String host = request.getHeader("discovered_host");
        byte[] encodedBytes = host.getBytes();
        String decodedHost = new String(Base64.getDecoder().decode(host));
        String fileURL = decodedHost + DATA_SUBMISSION_ENDPOINT + "/" + DATA_SUBMISSION_AS_CSV_FILE_ENDPOINT;
        logger.debug("fileURL: " + fileURL);
        DataSubmission dataSubmission = this.dataSubmissionService.getDataSubmission(id);
        if (dataSubmission.getStatus().intValue() != DataSubmissionStatusType.VALIDATED.code()) {
            throw new ServiceException("The submission is not validated");
        }
        try {
            List fieldNames = this.getFieldNamesInOrder(dataSubmission.getDataCollection().getDataModel().getDefinition());
            task = TabmanManager.exportDataSubmissionToTabman((DataSubmission)dataSubmission, (List)fieldNames, (String)scope, (String)token, (String)fileURL.replace("{id}", id.toString()), (TabmanDto)tabmanDto);
        }
        catch (InterruptedException | NoSuchOperationException | NoSuchTabularResourceException | NoSuchTaskException e) {
            e.printStackTrace();
            throw new ServiceException("An error occurred while exporting data collection [" + id + "] to tabman");
        }
        if (!task.getStatus().name().equals(TaskStatus.SUCCEDED.name())) {
            throw new ServiceException("Export to tabman for Data Submission [" + id + "]: " + task.getStatus().name() + ", " + task.getErrorCause().getMessage());
        }
        try {
            this.updateDataSubmissionForSuccessfulTabmanExport(dataSubmission, task);
        }
        catch (ServiceException | JAXBException e) {
            logger.error("Error on updating Data Submission [" + dataSubmission.getId() + "] for successful Tabman export", e);
        }
        return ResponseEntity.ok((Object)("Export to tabman for Datacollection [" + id + "]: " + task.getStatus().name()));
    }

    private void updateDataSubmissionForSuccessfulTabmanExport(DataSubmission dataSubmission, Task task) throws JAXBException, ServiceException {
        TabmanInfoDto tabmanInfo = new TabmanInfoDto();
        tabmanInfo.setExportDate(Date.from(Instant.now()));
        tabmanInfo.setResourceId(task.getTabularResourceId().getValue());
        AttributesDto attributes = new AttributesDto();
        if (dataSubmission.getAttributes() != null) {
            attributes = AttributesDto.fromXml((String)dataSubmission.getAttributes());
        }
        attributes.setTabmanInfo(tabmanInfo);
        DataSubmission dataSubmissionWithTabmanInfo = new DataSubmission();
        dataSubmissionWithTabmanInfo.setId(dataSubmission.getId());
        dataSubmissionWithTabmanInfo.setAttributes(AttributesDto.toXml((AttributesDto)attributes));
        this.dataSubmissionService.updateDataSubmission(dataSubmissionWithTabmanInfo);
    }

    private List<String> getFieldNamesInOrder(String dsd) {
        return this.dsdProcessing.getDefinitionForExcelAddIn(dsd).getFields().stream().sorted(Comparator.comparingInt(Field::getOrder)).map(Field::getLabel).collect(Collectors.toList());
    }

    private String constructDataSubmissionCsv(List<String> fieldNames, List<Cdt> data) {
        String csvHeaders = fieldNames.stream().collect(Collectors.joining(",", "", "\n"));
        String csvData = data.stream().map(cdt -> fieldNames.stream().map(field -> cdt.getData().get(field).toString()).collect(Collectors.joining(","))).collect(Collectors.joining("\n"));
        return csvHeaders + csvData;
    }

    @RequestMapping(value={"/{id}/status"}, method={RequestMethod.POST}, consumes={"application/json"}, produces={"application/json"})
    public ResponseEntity<DataSubmissionDto> changeDataSubmissionStatus(@PathVariable(value="id") Integer id, @RequestBody DataSubmissionDto dataSubmissionDto) throws ServiceException {
        dataSubmissionDto.setId(id);
        DataSubmission dataSubmissionEntity = (DataSubmission)this.entityDtoMapper.dtoToEntity((Dto)dataSubmissionDto, DataSubmission.class);
        dataSubmissionEntity = this.dataSubmissionService.updateDataSubmission(dataSubmissionEntity);
        return ResponseEntity.ok((Object)this.entityDtoMapper.entityToDto((Entity)dataSubmissionEntity, DataSubmissionDto.class));
    }
}

