/*
 * Decompiled with CFR 0.152.
 */
package gr.cite.regional.data.collection.application.controllers;

import gr.cite.regional.data.collection.application.controllers.BaseController;
import gr.cite.regional.data.collection.application.core.EntityDtoMapper;
import gr.cite.regional.data.collection.application.dtos.Dto;
import gr.cite.regional.data.collection.application.dtos.UserReferenceDto;
import gr.cite.regional.data.collection.dataaccess.entities.Entity;
import gr.cite.regional.data.collection.dataaccess.entities.UserReference;
import gr.cite.regional.data.collection.dataaccess.services.UserReferenceService;
import gr.cite.regional.data.collection.dataccess.exceptions.ServiceException;
import java.util.Collection;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
@CrossOrigin
@RequestMapping(value={"/userReferences"})
public class UserReferenceController
extends BaseController {
    private static final Logger logger = LogManager.getLogger(UserReferenceController.class);
    static final String USER_REFERENCE_ENDPOINT = "userReferences";
    private String hostname;
    private EntityDtoMapper entityDtoMapper;
    private UserReferenceService userReferenceService;

    @Autowired
    public UserReferenceController(UserReferenceService userReferenceService, String hostname, EntityDtoMapper entityDtoMapper) {
        this.hostname = hostname;
        this.entityDtoMapper = entityDtoMapper;
        this.userReferenceService = userReferenceService;
    }

    @RequestMapping(value={""}, method={RequestMethod.GET}, produces={"application/json"})
    public ResponseEntity<List<UserReferenceDto>> getAllUserReferences() throws ServiceException {
        List userReferrences = this.userReferenceService.getAllUserReferences();
        return ResponseEntity.ok((Object)this.entityDtoMapper.entitiesToDtos((Collection)userReferrences, UserReferenceDto.class));
    }

    @RequestMapping(value={""}, method={RequestMethod.POST}, produces={"application/json"})
    public ResponseEntity<String> addUserReference(@RequestBody UserReferenceDto userReferenceDto) throws ServiceException {
        UserReference userReferenceEntity = (UserReference)this.entityDtoMapper.dtoToEntity((Dto)userReferenceDto, UserReference.class);
        userReferenceEntity = this.userReferenceService.addUserReference(userReferenceEntity);
        return ResponseEntity.ok((Object)("User Reference " + userReferenceEntity.getLabel() + " [" + userReferenceEntity.getId() + "] successfully created"));
    }

    @RequestMapping(value={"/login"}, method={RequestMethod.POST}, produces={"application/json"})
    public ResponseEntity<UserReferenceDto> login(@RequestBody UserReferenceDto userReferenceDto) throws ServiceException {
        UserReference userReferenceEntity = this.userReferenceService.createUserReferenceIfNotExists((UserReference)this.entityDtoMapper.dtoToEntity((Dto)userReferenceDto, UserReference.class));
        UserReferenceDto userReference = (UserReferenceDto)this.entityDtoMapper.entityToDto((Entity)userReferenceEntity, UserReferenceDto.class);
        return ResponseEntity.ok((Object)userReference);
    }

    @RequestMapping(value={"/{id}"}, method={RequestMethod.POST}, produces={"application/json"})
    public ResponseEntity<String> updateUserReference(@PathVariable(value="id") Integer id, @RequestBody UserReferenceDto userReferenceDto) throws ServiceException {
        userReferenceDto.setId(id);
        UserReference userReferenceEntity = (UserReference)this.entityDtoMapper.dtoToEntity((Dto)userReferenceDto, UserReference.class);
        userReferenceEntity = this.userReferenceService.updateUserReference(userReferenceEntity);
        return ResponseEntity.ok((Object)("User Reference " + userReferenceEntity.getLabel() + " [" + userReferenceEntity.getId() + "] successfully updated"));
    }

    @RequestMapping(value={"/{id}"}, method={RequestMethod.GET}, produces={"application/json"})
    public ResponseEntity<UserReferenceDto> getUserReference(@PathVariable(value="id") Integer id) {
        UserReference userReference = this.userReferenceService.getUserReference(id);
        return ResponseEntity.ok((Object)this.entityDtoMapper.entityToDto((Entity)userReference, UserReferenceDto.class));
    }
}

