/*
 * Decompiled with CFR 0.152.
 */
package gr.cite.regional.data.collection.application.endpoint;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.net.SocketTimeoutException;
import java.util.Map;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.ForbiddenException;
import javax.ws.rs.InternalServerErrorException;
import javax.ws.rs.NotAcceptableException;
import javax.ws.rs.NotAllowedException;
import javax.ws.rs.NotAuthorizedException;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.NotSupportedException;
import javax.ws.rs.ServiceUnavailableException;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.glassfish.jersey.jackson.JacksonFeature;

/*
 * Exception performing whole class analysis ignored.
 */
public class HttpClientSocial {
    private static final Logger _log = LogManager.getLogger(HttpClientSocial.class);
    private static ObjectMapper mapper = new ObjectMapper();
    private static Integer HTTP_CONNECTION_TIMEOUT;
    private static Client singletonHttpClient;
    private String host;
    private String scope;
    private String token;
    private String userName;
    private String userFullName;
    private String userEmail;

    private static synchronized Client getSingletonHttpClient() {
        return singletonHttpClient == null ? (singletonHttpClient = ClientBuilder.newClient()) : singletonHttpClient;
    }

    public Response doGetCSV(String serviceUrl, Map<String, Object> headers) {
        _log.debug("GET request to: " + serviceUrl);
        this.augmentHeaders(headers);
        Client client = HttpClientSocial.getSingletonHttpClient();
        client.property("jersey.config.client.connectTimeout", (Object)HTTP_CONNECTION_TIMEOUT);
        client.register(JacksonFeature.class);
        WebTarget webTarget = client.target(this.getHost() + serviceUrl);
        Invocation.Builder builder = webTarget.request(new String[]{"application/octet-stream"});
        for (Map.Entry<String, Object> entry : headers.entrySet()) {
            builder.header(entry.getKey(), entry.getValue());
        }
        return builder.get();
    }

    public Response doGet(String serviceUrl, Map<String, Object> headers) {
        _log.debug("GET request to: " + serviceUrl);
        Client client = HttpClientSocial.getSingletonHttpClient();
        client.property("jersey.config.client.connectTimeout", (Object)HTTP_CONNECTION_TIMEOUT);
        client.register(JacksonFeature.class);
        WebTarget webTarget = client.target(serviceUrl);
        Invocation.Builder builder = webTarget.request(new String[]{"application/json"});
        builder.accept(new String[]{"application/json"});
        for (Map.Entry<String, Object> entry : headers.entrySet()) {
            builder.header(entry.getKey(), entry.getValue());
        }
        return builder.get();
    }

    public Response doPost(String serviceUrl, Map<String, Object> headers, Object bodyObject) {
        _log.debug("POST request to: " + serviceUrl);
        _log.info("POST request to: " + serviceUrl);
        System.out.println("POST request to: " + serviceUrl);
        this.augmentHeaders(headers);
        Client client = HttpClientSocial.getSingletonHttpClient();
        client.property("jersey.config.client.connectTimeout", (Object)HTTP_CONNECTION_TIMEOUT);
        client.register(JacksonFeature.class);
        WebTarget webTarget = client.target(serviceUrl);
        Invocation.Builder builder = webTarget.request(new String[]{"application/json"});
        builder.accept(new String[]{"application/json"});
        for (Map.Entry<String, Object> entry : headers.entrySet()) {
            builder.header(entry.getKey(), entry.getValue());
        }
        Invocation invocation = builder.buildPost(Entity.entity((Object)bodyObject, (MediaType)MediaType.APPLICATION_JSON_TYPE));
        return invocation.invoke();
    }

    public Response doDelete(String serviceUrl, Map<String, Object> headers) {
        _log.debug("DELETE request to: " + serviceUrl);
        this.augmentHeaders(headers);
        Client client = HttpClientSocial.getSingletonHttpClient();
        client.property("jersey.config.client.connectTimeout", (Object)HTTP_CONNECTION_TIMEOUT);
        client.register(JacksonFeature.class);
        WebTarget webTarget = client.target(this.getHost() + serviceUrl);
        Invocation.Builder builder = webTarget.request(new String[]{"application/json"});
        builder.accept(new String[]{"application/json"});
        for (Map.Entry<String, Object> entry : headers.entrySet()) {
            builder.header(entry.getKey(), entry.getValue());
        }
        Invocation invocation = builder.buildDelete();
        return invocation.invoke();
    }

    public Integer exceptionHandler(Exception e) {
        if (e instanceof BadRequestException) {
            return 400;
        }
        if (e instanceof NotAuthorizedException) {
            return 401;
        }
        if (e instanceof ForbiddenException) {
            return 403;
        }
        if (e instanceof NotFoundException) {
            return 404;
        }
        if (e instanceof NotAllowedException) {
            return 405;
        }
        if (e instanceof NotAcceptableException) {
            return 406;
        }
        if (e instanceof NotSupportedException) {
            return 415;
        }
        if (e instanceof InternalServerErrorException) {
            return 500;
        }
        if (e instanceof ServiceUnavailableException) {
            return 503;
        }
        if (e instanceof SocketTimeoutException) {
            return 504;
        }
        return 500;
    }

    public static String toJson(Object bodyObject) {
        String json = null;
        try {
            json = mapper.writeValueAsString(bodyObject);
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
        }
        return json;
    }

    public Integer getHTTP_CONNECTION_TIMEOUT() {
        return HTTP_CONNECTION_TIMEOUT;
    }

    public void setHTTP_CONNECTION_TIMEOUT(Integer httpConnectionTimeout) {
        HTTP_CONNECTION_TIMEOUT = httpConnectionTimeout;
    }

    public void augmentHeaders(Map<String, Object> headers) {
        headers.put("gcube-token", this.getToken());
        headers.put("username", this.getUserName());
        headers.put("userFullname", this.getUserFullName());
        headers.put("userEmail", this.getUserEmail());
        headers.put("gcube-user-scope", this.getScope());
        headers.put("Content-Type", "application/x-www-form-urlencoded");
    }

    public String getToken() {
        return this.token;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getUserFullName() {
        return this.userFullName;
    }

    public void setUserFullName(String userFullName) {
        this.userFullName = userFullName;
    }

    public String getUserEmail() {
        return this.userEmail;
    }

    public void setUserEmail(String userEmail) {
        this.userEmail = userEmail;
    }

    public String getScope() {
        return this.scope;
    }

    public void setScope(String scope) {
        this.scope = scope;
    }
}

