package gr.cite.regional.data.collection.application.core;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;

public class ScopeAndTokenInterceptor extends HandlerInterceptorAdapter{
	private static final Logger logger = LogManager.getLogger(ScopeAndTokenInterceptor.class);
	
	public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
		if (request.getMethod().equals(RequestMethod.OPTIONS.name())) return true;
		logger.debug(request.getRequestURI());
		if (request.getRequestURI().contains("/dataSubmissions/data/file")) return true;
		
		String scope = request.getHeader("gcube-scope");
		String token = request.getHeader("gcube-token");
		
		String errorMessage = null;
		if (scope == null) errorMessage = "No gcube-scope header defined";
		if (token == null) errorMessage = "No gcube-token header defined";
		if (scope == null && token == null) errorMessage = "No gcube-scope and gcube-token headers defined";
		
		if (scope == null || token == null) {
			response.sendError(HttpStatus.BAD_REQUEST.value(), errorMessage);
			return false;
		} else {
			return true;
		}
		
	}
}