/*
 * Decompiled with CFR 0.152.
 */
package gr.cite.regional.data.collection.application.controllers;

import gr.cite.regional.data.collection.application.controllers.BaseController;
import gr.cite.regional.data.collection.application.core.EntityDtoMapper;
import gr.cite.regional.data.collection.application.dtos.DomainDto;
import gr.cite.regional.data.collection.application.dtos.Dto;
import gr.cite.regional.data.collection.application.dtos.UserReferenceDto;
import gr.cite.regional.data.collection.application.endpoint.ServiceDiscoveryException;
import gr.cite.regional.data.collection.application.endpoint.social.SocialNetworkingService;
import gr.cite.regional.data.collection.application.endpoint.social.UserProfile;
import gr.cite.regional.data.collection.dataaccess.entities.Domain;
import gr.cite.regional.data.collection.dataaccess.entities.Entity;
import gr.cite.regional.data.collection.dataaccess.entities.UserReference;
import gr.cite.regional.data.collection.dataaccess.exceptions.ServiceException;
import gr.cite.regional.data.collection.dataaccess.services.DomainService;
import gr.cite.regional.data.collection.dataaccess.services.UserReferenceService;
import java.util.Collection;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
@CrossOrigin
@RequestMapping(value={"/userReferences"})
public class UserReferenceController
extends BaseController {
    private static final Logger logger = LogManager.getLogger(UserReferenceController.class);
    static final String USER_REFERENCE_ENDPOINT = "userReferences";
    private static final String VRE_MANAGER_ROLE = "VRE-Manager";
    private String hostname;
    private EntityDtoMapper entityDtoMapper;
    private UserReferenceService userReferenceService;
    private DomainService domainService;
    private SocialNetworkingService socialNetworkingService;

    @Autowired
    public UserReferenceController(UserReferenceService userReferenceService, DomainService domainService, SocialNetworkingService socialNetworkingService, String hostname, EntityDtoMapper entityDtoMapper) {
        this.hostname = hostname;
        this.entityDtoMapper = entityDtoMapper;
        this.userReferenceService = userReferenceService;
        this.domainService = domainService;
        this.socialNetworkingService = socialNetworkingService;
    }

    @RequestMapping(value={""}, method={RequestMethod.GET}, produces={"application/json"})
    public ResponseEntity<List<UserReferenceDto>> getAllUserReferences() throws ServiceException {
        List userReferences = this.userReferenceService.getAllUserReferences();
        return ResponseEntity.ok((Object)this.entityDtoMapper.entitiesToDtos((Collection)userReferences, UserReferenceDto.class));
    }

    @RequestMapping(value={""}, method={RequestMethod.POST}, produces={"application/json"})
    public ResponseEntity<String> addUserReference(@RequestBody UserReferenceDto userReferenceDto) throws ServiceException {
        UserReference userReferenceEntity = this.userReferenceService.addUserReference((UserReference)this.entityDtoMapper.dtoToEntity((Dto)userReferenceDto, UserReference.class));
        return ResponseEntity.ok((Object)("User Reference " + userReferenceEntity.getLabel() + " [" + userReferenceEntity.getId() + "] successfully created"));
    }

    @RequestMapping(value={"/login"}, method={RequestMethod.POST}, produces={"application/json"})
    public ResponseEntity<UserReferenceDto> login(@RequestBody UserReferenceDto userReferenceDto) throws ServiceException {
        String scope = this.getGCubeScope();
        try {
            this.domainService.getDomainByLabel(scope);
        }
        catch (NoSuchElementException e) {
            throw new ServiceException(scope + "does not exist");
        }
        UserReference userReferenceEntity = this.userReferenceService.createUserReferenceIfNotExists((UserReference)this.entityDtoMapper.dtoToEntity((Dto)userReferenceDto, UserReference.class));
        return ResponseEntity.ok((Object)this.entityDtoMapper.entityToDto((Entity)userReferenceEntity, UserReferenceDto.class));
    }

    @RequestMapping(value={"/{id}"}, method={RequestMethod.POST}, produces={"application/json"})
    public ResponseEntity<String> updateUserReference(@PathVariable(value="id") Integer id, @RequestBody UserReferenceDto userReferenceDto) throws ServiceException {
        userReferenceDto.setId(id);
        UserReference userReferenceEntity = this.userReferenceService.updateUserReference((UserReference)this.entityDtoMapper.dtoToEntity((Dto)userReferenceDto, UserReference.class));
        return ResponseEntity.ok((Object)("User Reference " + userReferenceEntity.getLabel() + " [" + userReferenceEntity.getId() + "] successfully updated"));
    }

    @RequestMapping(value={"/{id}"}, method={RequestMethod.GET}, produces={"application/json"})
    public ResponseEntity<UserReferenceDto> getUserReference(@PathVariable(value="id") Integer id) {
        UserReference userReference = this.userReferenceService.getUserReference(id);
        return ResponseEntity.ok((Object)this.entityDtoMapper.entityToDto((Entity)userReference, UserReferenceDto.class));
    }

    @RequestMapping(value={"/admin/register"}, method={RequestMethod.POST}, consumes={"application/json"}, produces={"application/json"})
    public ResponseEntity<UserReferenceDto> registerAdminUser() throws ServiceException {
        UserProfile userProfile;
        String scope = this.getGCubeScope();
        String token = this.getGCubeToken();
        try {
            userProfile = this.socialNetworkingService.getUserProfile(token, scope);
        }
        catch (ServiceDiscoveryException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new ServiceException("Failed at retrieving user profile");
        }
        if (userProfile == null) {
            throw new IllegalArgumentException("No user with token [" + token + "]");
        }
        Domain domain = this.domainService.getOrCreateDomainByLabel(scope);
        UserReferenceDto user = this.getOrCreateUserReference(userProfile, domain);
        return ResponseEntity.ok((Object)user);
    }

    @RequestMapping(value={"/register"}, method={RequestMethod.POST}, consumes={"application/json"}, produces={"application/json"})
    public ResponseEntity<UserReferenceDto> registerUser() throws ServiceException {
        UserProfile userProfile;
        String scope = this.getGCubeScope();
        String token = this.getGCubeToken();
        try {
            userProfile = this.socialNetworkingService.getUserProfile(token, scope);
        }
        catch (ServiceDiscoveryException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new ServiceException("Failed at retrieving user profile");
        }
        if (userProfile == null) {
            throw new IllegalArgumentException("No user with token [" + token + "]");
        }
        Domain domain = this.domainService.getDomainByLabel(scope);
        UserReferenceDto user = this.getOrCreateUserReference(userProfile, domain);
        return ResponseEntity.ok((Object)user);
    }

    private UserReferenceDto getOrCreateUserReference(UserProfile userProfile, Domain domain) throws ServiceException {
        UserReference userReference = this.mapUserProfileToUserReference(userProfile);
        userReference = this.userReferenceService.getOrCreateUserReferenceByLabel(userReference);
        UserReferenceDto user = (UserReferenceDto)this.entityDtoMapper.entityToDto((Entity)userReference, UserReferenceDto.class);
        user.setDomain((DomainDto)this.entityDtoMapper.entityToDto((Entity)domain, DomainDto.class));
        return user;
    }

    private UserReference mapUserProfileToUserReference(UserProfile userProfile) {
        UserReference userReference = null;
        if (userProfile != null) {
            userReference = new UserReference();
            userReference.setLabel(userProfile.getUsername());
            userReference.setEmail(userProfile.getEmail());
            userReference.setFullName(userProfile.getFullname());
            userReference.setUri(userProfile.getUri());
        }
        return userReference;
    }
}

