/*
 * Decompiled with CFR 0.152.
 */
package gr.cite.regional.data.collection.application.endpoint.social;

import gr.cite.regional.data.collection.application.dtos.AttributesDto;
import gr.cite.regional.data.collection.application.endpoint.EndpointManager;
import gr.cite.regional.data.collection.application.endpoint.HttpClientSocial;
import gr.cite.regional.data.collection.application.endpoint.NotificationDto;
import gr.cite.regional.data.collection.application.endpoint.ServiceDiscoveryException;
import gr.cite.regional.data.collection.application.endpoint.ServiceProfile;
import gr.cite.regional.data.collection.application.endpoint.social.SocialNetworkingPeopleProfileResponse;
import gr.cite.regional.data.collection.application.endpoint.social.SocialNetworkingUserProfile;
import gr.cite.regional.data.collection.application.endpoint.social.UserIdentificationService;
import gr.cite.regional.data.collection.application.endpoint.social.UserProfile;
import gr.cite.regional.data.collection.dataaccess.entities.DataCollection;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.stream.Collectors;
import javax.ws.rs.core.Response;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;

public class SocialNetworkingService
implements UserIdentificationService {
    private static final Logger _log = LogManager.getLogger(SocialNetworkingService.class);
    private String serviceName;
    private String socialNetworkingRestServiceName;
    private String socialNetworkingRestServiceClass;
    private String socialNetworkingRestServiceEndsWith;
    private String socialNetworkingRestServiceURL = null;
    private String socialNetworkingRestServiceJsonStatusSuccess;
    private String socialNetworkingRestServiceJsonStatusFailed;
    private String socialNetworkingRestServiceJsonStatusSuccessMessage;
    private String socialNetworkingRestServiceJsonStatusFailedMessage;
    private String socialNetworkingRestServiceJsonJobName;
    private String socialNetworkingRestServicesAndUserNotificationEndpoint;
    private String socialNetworkingUserProfileEndpoint;

    @Autowired
    public SocialNetworkingService(String socialNetworkingRestServiceName, String socialNetworkingRestServiceClass, String socialNetworkingRestServiceEndsWith, String socialNetworkingRestServiceJsonStatusSuccess, String socialNetworkingRestServiceJsonStatusFailed, String socialNetworkingRestServiceJsonStatusSuccessMessage, String socialNetworkingRestServiceJsonStatusFailedMessage, String socialNetworkingRestServiceJsonJobName, String serviceName, String socialNetworkingRestServicesAndUserNotificationEndpoint, String socialNetworkingUserProfileEndpoint) {
        this.socialNetworkingRestServiceName = socialNetworkingRestServiceName;
        this.socialNetworkingRestServiceClass = socialNetworkingRestServiceClass;
        this.socialNetworkingRestServiceJsonStatusSuccess = socialNetworkingRestServiceJsonStatusSuccess;
        this.socialNetworkingRestServiceJsonStatusFailed = socialNetworkingRestServiceJsonStatusFailed;
        this.socialNetworkingRestServiceJsonStatusSuccessMessage = socialNetworkingRestServiceJsonStatusSuccessMessage;
        this.socialNetworkingRestServiceJsonStatusFailedMessage = socialNetworkingRestServiceJsonStatusFailedMessage;
        this.socialNetworkingRestServiceJsonJobName = socialNetworkingRestServiceJsonJobName;
        this.socialNetworkingRestServiceEndsWith = socialNetworkingRestServiceEndsWith == null ? "" : socialNetworkingRestServiceEndsWith;
        this.serviceName = serviceName;
        this.socialNetworkingRestServicesAndUserNotificationEndpoint = socialNetworkingRestServicesAndUserNotificationEndpoint;
        this.socialNetworkingUserProfileEndpoint = socialNetworkingUserProfileEndpoint;
    }

    public void notifyUser(String scope, long jobId, String token, String recipient, DataCollection dataCollection, AttributesDto attributes, Boolean success) throws ServiceDiscoveryException {
        this.socialNetworkingRestServiceURL = this.socialNetworkingRestServiceURL == null ? this.discoverSocialNetworkingRestService(scope) : this.socialNetworkingRestServiceURL;
        String sender = attributes.getMetadata().getOwner();
        String statusMessage = MessageFormat.format(success != false ? this.socialNetworkingRestServiceJsonStatusSuccessMessage : this.socialNetworkingRestServiceJsonStatusFailedMessage, sender, dataCollection.getLabel(), dataCollection.getId());
        HttpClientSocial client = new HttpClientSocial();
        client.setToken(token);
        HashMap<String, Object> headers = new HashMap<String, Object>();
        client.augmentHeaders(headers);
        _log.debug((Object)"Headers for data submission notification");
        headers.forEach((s, o) -> _log.debug((Object)("Key: " + s + " Value: " + o)));
        NotificationDto notificationBody = new NotificationDto(recipient, jobId, this.socialNetworkingRestServiceJsonJobName, this.serviceName, success != false ? this.socialNetworkingRestServiceJsonStatusSuccess : this.socialNetworkingRestServiceJsonStatusFailed, statusMessage);
        _log.debug((Object)("Notification sent to admin: " + notificationBody.toString()));
        String url = this.getSocialNetworkingRestServiceURL(scope) + this.socialNetworkingRestServicesAndUserNotificationEndpoint;
        _log.debug((Object)("Notification URL: " + url));
        _log.debug((Object)("Notification recipient: " + notificationBody.getRecipient()));
        Response clientResponse = client.doPost(url, headers, (Object)notificationBody);
        String result = (String)clientResponse.readEntity(String.class);
        _log.debug((Object)("Notification result: " + result));
        if (clientResponse.getStatus() != HttpStatus.OK.value()) {
            _log.error((Object)("Notifying user: " + recipient + " via social networking service failed for the data submission with id: " + jobId));
        } else {
            _log.info((Object)("User: " + recipient + " was notified successfully for the data submission with id: " + jobId));
        }
    }

    public UserProfile getUserProfile(String userToken, String scope) throws ServiceDiscoveryException {
        HttpClientSocial client = new HttpClientSocial();
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("gcube-token", userToken);
        String url = this.getSocialNetworkingRestServiceURL(scope) + this.socialNetworkingUserProfileEndpoint;
        _log.info((Object)url);
        Response response = client.doGet(url, headers);
        SocialNetworkingPeopleProfileResponse profileResponse = (SocialNetworkingPeopleProfileResponse)response.readEntity(SocialNetworkingPeopleProfileResponse.class);
        return this.mapSocialNetworkingUserProfileToUserProfile(profileResponse.getResult());
    }

    private UserProfile mapSocialNetworkingUserProfileToUserProfile(SocialNetworkingUserProfile socialNetworkingUserProfile) {
        UserProfile userProfile = null;
        if (socialNetworkingUserProfile != null) {
            userProfile = new UserProfile();
            userProfile.setEmail(socialNetworkingUserProfile.getUsername());
            userProfile.setUsername(socialNetworkingUserProfile.getUsername());
            userProfile.setFullname(socialNetworkingUserProfile.getFullname());
            userProfile.setUri(socialNetworkingUserProfile.getAvatar());
            userProfile.setRoles(socialNetworkingUserProfile.getRoles());
        }
        return userProfile;
    }

    private String discoverSocialNetworkingRestService(String scope) throws ServiceDiscoveryException {
        EndpointManager em = new EndpointManager();
        String theUrl = (String)em.getServiceEndpoints(scope, this.getSocialNetworkingRestServiceProfile()).stream().filter(url -> url.indexOf("rest") > -1).collect(Collectors.toList()).get(0);
        _log.info((Object)("Social Networking Rest Service discovered: " + theUrl));
        return theUrl;
    }

    private ServiceProfile getSocialNetworkingRestServiceProfile() {
        ServiceProfile socialNetworkingRestServiceProfile = new ServiceProfile();
        socialNetworkingRestServiceProfile.setServiceClass(this.socialNetworkingRestServiceClass);
        socialNetworkingRestServiceProfile.setServiceName(this.socialNetworkingRestServiceName);
        socialNetworkingRestServiceProfile.setPathEndsWith(this.socialNetworkingRestServiceEndsWith);
        return socialNetworkingRestServiceProfile;
    }

    public String getSocialNetworkingRestServiceURL(String scope) throws ServiceDiscoveryException {
        return this.socialNetworkingRestServiceURL == null ? this.discoverSocialNetworkingRestService(scope) : this.socialNetworkingRestServiceURL;
    }
}

