/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.aginfra.data.analytics.visualization.model.data;

import gr.uoa.di.aginfra.data.analytics.visualization.model.data.CSVExtractor;
import gr.uoa.di.aginfra.data.analytics.visualization.model.data.DataSetExtractor;
import gr.uoa.di.aginfra.data.analytics.visualization.model.data.DataSetExtractorFactory;
import gr.uoa.di.aginfra.data.analytics.visualization.model.data.MongoDBExtractor;
import gr.uoa.di.aginfra.data.analytics.visualization.model.definitions.DataSource;
import gr.uoa.di.aginfra.data.analytics.visualization.model.repositories.DataDocumentRepository;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Component;

@Component
public class DataSetExtractorFactoryImpl
implements DataSetExtractorFactory {
    private ApplicationContext appContext;

    @Autowired
    public DataSetExtractorFactoryImpl(ApplicationContext appContext) {
        this.appContext = appContext;
    }

    @Override
    public DataSetExtractor getExtractor(DataSource dataSource) {
        switch (dataSource.getType()) {
            case CSV: {
                return new CSVExtractor();
            }
            case IMPORTED: {
                return new MongoDBExtractor((DataDocumentRepository)this.appContext.getBean(DataDocumentRepository.class));
            }
        }
        throw new UnsupportedOperationException();
    }
}

