/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.aginfra.data.analytics.visualization.model.visualization.extractors;

import gr.uoa.di.aginfra.data.analytics.visualization.model.definitions.Configuration;
import gr.uoa.di.aginfra.data.analytics.visualization.model.visualization.data.AxisDataType;
import gr.uoa.di.aginfra.data.analytics.visualization.model.visualization.data.DataSet;
import gr.uoa.di.aginfra.data.analytics.visualization.model.visualization.data.DataSetManipulator;
import gr.uoa.di.aginfra.data.analytics.visualization.model.visualization.data.TimeSeries;
import gr.uoa.di.aginfra.data.analytics.visualization.model.visualization.extractors.TimeSeriesExtractor;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Component;

@Component
public class TimeSeriesExtractorImpl
extends DataSetManipulator
implements TimeSeriesExtractor {
    @Override
    public Collection<TimeSeries> extract(DataSet dataSet, Configuration configuration) throws Exception {
        int yAxisFieldIndex;
        int xAxisFieldIndex;
        boolean hasGrouping = true;
        String groupBy = configuration.getGroupBy();
        String xAxisField = configuration.getXAxis();
        String yAxisField = configuration.getYAxis();
        String colorField = configuration.getColorField();
        String documentField = configuration.getDocumentField();
        int groupByIndex = -1;
        if (groupBy == null || (groupByIndex = this.getFieldIndex(dataSet, groupBy)) == -1) {
            hasGrouping = false;
        }
        if (xAxisField == null || (xAxisFieldIndex = this.getFieldIndex(dataSet, xAxisField)) == -1) {
            throw new Exception("Invalid data field provided " + xAxisField);
        }
        if (yAxisField == null || (yAxisFieldIndex = this.getFieldIndex(dataSet, yAxisField)) == -1) {
            throw new Exception("Invalid data field provided " + yAxisField);
        }
        int documentIndex = -1;
        if (documentField != null) {
            documentIndex = this.getFieldIndex(dataSet, documentField);
        }
        int colorIndex = -1;
        if (colorField != null) {
            colorIndex = this.getFieldIndex(dataSet, colorField);
        }
        return hasGrouping ? this.extractByGrouping(dataSet, groupByIndex, xAxisFieldIndex, yAxisFieldIndex, documentIndex, colorIndex) : this.extractNoGrouping(dataSet, xAxisFieldIndex, yAxisFieldIndex, documentIndex, colorIndex);
    }

    private Collection<TimeSeries> extractNoGrouping(DataSet dataSet, int xAxisFieldIndex, int yAxisFieldIndex, int documentIndex, int colorIndex) {
        TimeSeries timeSeries = new TimeSeries("All");
        List<Object> xAxisData = timeSeries.getXAxisData();
        List<BigDecimal> yAxisData = timeSeries.getYAxisData();
        List<String> documents = timeSeries.getDocuments();
        boolean isXAxisDate = this.isXAxisDate(dataSet, xAxisFieldIndex);
        timeSeries.setXAxisDataType(isXAxisDate ? AxisDataType.Date : AxisDataType.Decimal);
        for (List<String> row : dataSet.getData()) {
            Comparable<Date> xValue = isXAxisDate ? this.parseDate(row.get(xAxisFieldIndex)) : this.parseBigDecimal(row.get(xAxisFieldIndex));
            BigDecimal yValue = this.parseBigDecimal(row.get(yAxisFieldIndex));
            if (xValue == null || yValue == null) continue;
            xAxisData.add(xValue);
            yAxisData.add(yValue);
            if (documentIndex > -1) {
                documents.add(row.get(documentIndex));
            }
            if (colorIndex <= -1 || timeSeries.getColor() != null) continue;
            timeSeries.setColor(row.get(colorIndex));
        }
        ArrayList<TimeSeries> list = new ArrayList<TimeSeries>();
        list.add(timeSeries);
        return list;
    }

    private Collection<TimeSeries> extractByGrouping(DataSet dataSet, int groupByIndex, int xAxisFieldIndex, int yAxisFieldIndex, int documentIndex, int colorIndex) {
        HashMap<String, TimeSeries> timeSeries = new HashMap<String, TimeSeries>();
        boolean isXAxisDate = this.isXAxisDate(dataSet, xAxisFieldIndex);
        for (List<String> row : dataSet.getData()) {
            String group = row.get(groupByIndex);
            TimeSeries groupTimeSeries = this.getOrCreateTimeSeries(timeSeries, group);
            groupTimeSeries.setXAxisDataType(isXAxisDate ? AxisDataType.Date : AxisDataType.Decimal);
            List<Object> xAxisData = groupTimeSeries.getXAxisData();
            List<BigDecimal> yAxisData = groupTimeSeries.getYAxisData();
            List<String> documents = groupTimeSeries.getDocuments();
            Comparable<Date> xValue = isXAxisDate ? this.parseDate(row.get(xAxisFieldIndex)) : this.parseBigDecimal(row.get(xAxisFieldIndex));
            BigDecimal yValue = this.parseBigDecimal(row.get(yAxisFieldIndex));
            if (xValue == null || yValue == null) continue;
            xAxisData.add(xValue);
            yAxisData.add(yValue);
            if (documentIndex > -1) {
                documents.add(row.get(documentIndex));
            }
            if (colorIndex <= -1 || groupTimeSeries.getColor() != null) continue;
            groupTimeSeries.setColor(row.get(colorIndex));
        }
        return timeSeries.values();
    }

    private TimeSeries getOrCreateTimeSeries(Map<String, TimeSeries> available, String name) {
        if (available.containsKey(name)) {
            return available.get(name);
        }
        TimeSeries timeSeries = new TimeSeries(name);
        available.put(name, timeSeries);
        return timeSeries;
    }

    private boolean isXAxisDate(DataSet dataSet, int xAxisFieldIndex) {
        Iterator<List<String>> iterator = dataSet.getData().iterator();
        if (iterator.hasNext()) {
            List<String> row = iterator.next();
            return this.parseDate(row.get(xAxisFieldIndex)) != null;
        }
        return false;
    }
}

