/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.aginfra.data.analytics.visualization.model.visualization.transformations;

import gr.uoa.di.aginfra.data.analytics.visualization.model.definitions.Transformation;
import gr.uoa.di.aginfra.data.analytics.visualization.model.definitions.UnpivotStructure;
import gr.uoa.di.aginfra.data.analytics.visualization.model.exceptions.InvalidFormatException;
import gr.uoa.di.aginfra.data.analytics.visualization.model.visualization.data.DataSet;
import gr.uoa.di.aginfra.data.analytics.visualization.model.visualization.transformations.UnpivotTransformer;
import java.util.ArrayList;
import java.util.List;
import org.springframework.stereotype.Component;

@Component
public class UnpivotTransformerImpl
implements UnpivotTransformer {
    @Override
    public DataSet unPivot(DataSet dataSet, Transformation transformation) throws Exception {
        if (transformation != null) {
            UnpivotStructure unpivotStructure = new UnpivotStructure();
            try {
                ArrayList<String> updatedFields = new ArrayList<String>();
                ArrayList<Integer> columnsPosition = new ArrayList<Integer>();
                for (int j = 0; j < dataSet.getFields().size(); ++j) {
                    String f = dataSet.getFields().get(j);
                    boolean addColumn = true;
                    for (String column : transformation.getTransformationColumns()) {
                        if (!f.equals(column)) continue;
                        addColumn = false;
                    }
                    if (addColumn) {
                        updatedFields.add(f);
                        continue;
                    }
                    columnsPosition.add(j);
                }
                updatedFields.add(transformation.getTransformationLabel());
                updatedFields.add(transformation.getTransformationLabelValue());
                unpivotStructure.setNewColumnValue(transformation.getTransformationLabelValue());
                unpivotStructure.setNewColumnName(transformation.getTransformationLabel());
                unpivotStructure.setColumnsToUnpivot(transformation.getTransformationColumns());
                unpivotStructure.setColumnsPosition(columnsPosition);
                ArrayList<List<String>> list = new ArrayList<List<String>>();
                for (int i = 0; i < dataSet.getData().size(); ++i) {
                    for (Integer oldColumns : unpivotStructure.getColumnsPosition()) {
                        ArrayList<String> item = new ArrayList<String>();
                        boolean oldColumnFound = false;
                        int oldColumnPosition = 0;
                        String oldColumnValue = null;
                        for (int j = 0; j < dataSet.getFields().size(); ++j) {
                            String f = dataSet.getFields().get(j);
                            if (dataSet.getData().get(i).size() > j) {
                                if (!oldColumnFound && oldColumns == j) {
                                    oldColumnValue = dataSet.getData().get(i).get(j);
                                    oldColumnFound = true;
                                    oldColumnPosition = j;
                                    continue;
                                }
                                if (oldColumns == j || unpivotStructure.getColumnsPosition().contains(j)) continue;
                                item.add(dataSet.getData().get(i).get(j));
                                continue;
                            }
                            item.add(null);
                        }
                        String[] s = dataSet.getFields().get(oldColumnPosition).split("-");
                        if (s.length > 1) {
                            item.add(s[1]);
                        } else {
                            item.add(dataSet.getFields().get(oldColumnPosition));
                        }
                        item.add(oldColumnValue);
                        list.add(item);
                    }
                }
                dataSet.setFields(updatedFields);
                dataSet.setData(list);
                return dataSet;
            }
            catch (Exception e) {
                throw new InvalidFormatException("Invalid csv format provided", e);
            }
        }
        return dataSet;
    }
}

